/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Event;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.debug.Simulator;
import org.jgroups.protocols.FRAG;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;

public class FRAG_Test
extends TestCase {
    IpAddress a1;
    Vector members;
    View v;
    static Simulator s = null;
    static int num_done = 0;
    static Sender[] senders = null;
    public static final int SIZE = 10000;
    public static final int NUM_MSGS = 10;
    public static final int NUM_THREADS = 100;

    public FRAG_Test(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.a1 = new IpAddress(1111);
        this.members = new Vector();
        this.members.add(this.a1);
        this.v = new View(this.a1, 1L, this.members);
        s = new Simulator();
        s.setLocalAddress(this.a1);
        s.setView(this.v);
        s.addMember(this.a1);
        Protocol frag = this.createProtocol();
        System.out.println("protocol to be tested: " + frag);
        Properties props = new Properties();
        props.setProperty("frag_size", "512");
        frag.setPropertiesInternal(props);
        Protocol[] stack = new Protocol[]{frag};
        s.setProtocolStack(stack);
        s.start();
    }

    protected Protocol createProtocol() {
        return new FRAG();
    }

    public void tearDown() throws Exception {
        super.tearDown();
        s.stop();
    }

    public void testFragmentation() throws InterruptedException {
        Sender sender;
        int i;
        Receiver r = new Receiver();
        s.setReceiver(r);
        senders = new Sender[100];
        for (i = 0; i < senders.length; ++i) {
            FRAG_Test.senders[i] = new Sender(i);
        }
        for (i = 0; i < senders.length; ++i) {
            sender = senders[i];
            sender.start();
        }
        for (i = 0; i < senders.length; ++i) {
            sender = senders[i];
            sender.join(5000L);
            if (!sender.isAlive()) continue;
            System.err.println("sender #" + i + " could not be joined (still alive)");
        }
        int sent = 0;
        int received = 0;
        int corrupted = 0;
        for (int i2 = 0; i2 < senders.length; ++i2) {
            Sender sender2 = senders[i2];
            received += sender2.getNumReceived();
            sent += sender2.getNumSent();
            corrupted += sender2.getNumCorrupted();
        }
        System.out.println("sent: " + sent + ", received: " + received + ", corrupted: " + corrupted);
        FRAG_Test.assertEquals((String)"sent and received should be the same", (int)sent, (int)received);
        FRAG_Test.assertEquals((String)"we should have 0 corrupted messages", (int)0, (int)corrupted);
    }

    public static Test suite() {
        return new TestSuite(FRAG_Test.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)FRAG_Test.suite());
    }

    static class Receiver
    implements Simulator.Receiver {
        int received = 0;

        Receiver() {
        }

        public void receive(Event evt) {
            if (evt.getType() == 1) {
                ++this.received;
                if (this.received % 1000 == 0) {
                    System.out.println("<== " + this.received);
                }
                Message msg = (Message)evt.getArg();
                byte[] data = msg.getBuffer();
                ByteBuffer buf = ByteBuffer.wrap(data);
                int id = buf.getInt();
                Sender sender = senders[id];
                sender.verify(buf);
            }
        }
    }

    static class Sender
    extends Thread {
        int id = -1;
        int num_sent = 0;
        int num_received = 0;
        int num_corrupted = 0;
        boolean done = false;

        public int getIdent() {
            return this.id;
        }

        public int getNumReceived() {
            return this.num_received;
        }

        public int getNumSent() {
            return this.num_sent;
        }

        public int getNumCorrupted() {
            return this.num_corrupted;
        }

        public Sender(int id) {
            super("sender #" + id);
            this.id = id;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            byte[] buf = this.createBuffer(this.id);
            for (int i = 0; i < 10; ++i) {
                Message msg = new Message(null, null, buf);
                Event evt = new Event(1, msg);
                s.send(evt);
                ++this.num_sent;
            }
            Sender sender = this;
            synchronized (sender) {
                try {
                    while (!this.done) {
                        this.wait(500L);
                    }
                    System.out.println("thread #" + this.id + " is done (" + ++num_done + ")");
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
        }

        private byte[] createBuffer(int id) {
            ByteBuffer buf = ByteBuffer.allocate(10000);
            int elements = 2500;
            for (int i = 0; i < elements; ++i) {
                buf.putInt(id);
            }
            return buf.array();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void verify(ByteBuffer buf) {
            boolean corrupted = false;
            int num_elements = 2499;
            for (int i = 0; i < num_elements; ++i) {
                int tmp = buf.getInt();
                if (tmp == this.id) continue;
                corrupted = true;
                break;
            }
            if (corrupted) {
                ++this.num_corrupted;
            } else {
                ++this.num_received;
            }
            if (this.num_corrupted + this.num_received >= 10) {
                Sender sender = this;
                synchronized (sender) {
                    this.done = true;
                    this.notify();
                }
            }
        }
    }
}

