/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Term;
import org.hibernate.Hibernate;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMember;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.search.SearchException;
import org.hibernate.search.analyzer.Discriminator;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.ProvidedId;
import org.hibernate.search.annotations.Store;
import org.hibernate.search.annotations.TermVector;
import org.hibernate.search.backend.AddLuceneWork;
import org.hibernate.search.backend.DeleteLuceneWork;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.PurgeAllLuceneWork;
import org.hibernate.search.backend.WorkType;
import org.hibernate.search.bridge.BridgeFactory;
import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.bridge.TwoWayFieldBridge;
import org.hibernate.search.bridge.TwoWayString2FieldBridgeAdaptor;
import org.hibernate.search.bridge.TwoWayStringBridge;
import org.hibernate.search.engine.DocumentBuilderContainedEntity;
import org.hibernate.search.engine.EntityState;
import org.hibernate.search.engine.LuceneOptionsImpl;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.impl.InitContext;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.IndexShardingStrategy;
import org.hibernate.search.util.LoggerFactory;
import org.hibernate.search.util.ReflectionHelper;
import org.hibernate.util.ReflectHelper;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentBuilderIndexedEntity<T>
extends DocumentBuilderContainedEntity<T> {
    private static final Logger log = LoggerFactory.make();
    private final DirectoryProvider[] directoryProviders;
    private final IndexShardingStrategy shardingStrategy;
    private boolean explicitDocumentId = false;
    private boolean allowFieldSelectionInProjection = false;
    protected XMember idGetter;
    protected String idKeywordName;
    private Float idBoost;
    private TwoWayFieldBridge idBridge;
    private boolean idProvided = false;
    private boolean safeFromTupleId;

    public DocumentBuilderIndexedEntity(XClass clazz, InitContext context, DirectoryProvider[] directoryProviders, IndexShardingStrategy shardingStrategy, ReflectionManager reflectionManager) {
        super(clazz, context, reflectionManager);
        this.entityState = EntityState.INDEXED;
        this.directoryProviders = directoryProviders;
        this.shardingStrategy = shardingStrategy;
        if (this.idKeywordName == null) {
            ProvidedId provided = this.findProvidedId(clazz, reflectionManager);
            if (provided == null) {
                throw new SearchException("No document id in: " + clazz.getName());
            }
            this.idBridge = BridgeFactory.extractTwoWayType(provided.bridge());
            this.idKeywordName = provided.name();
        }
    }

    @Override
    protected void init(XClass clazz, InitContext context) {
        super.init(clazz, context);
        this.safeFromTupleId = this.entityState != EntityState.INDEXED || TwoWayString2FieldBridgeAdaptor.class.isAssignableFrom(this.idBridge.getClass());
        this.checkAllowFieldSelection();
        if (log.isDebugEnabled()) {
            log.debug("Field selection in projections is set to {} for entity {}.", (Object)this.allowFieldSelectionInProjection, (Object)clazz.getName());
        }
    }

    @Override
    protected void checkDocumentId(XProperty member, DocumentBuilderContainedEntity.PropertiesMetadata propertiesMetadata, boolean isRoot, String prefix, InitContext context) {
        Annotation idAnnotation = this.getIdAnnotation(member, context);
        if (idAnnotation != null) {
            String attributeName = this.getIdAttributeName(member, idAnnotation);
            if (isRoot) {
                if (this.idKeywordName != null && this.explicitDocumentId) {
                    throw new AssertionFailure("Two document id assigned: " + this.idKeywordName + " and " + attributeName);
                }
                this.idKeywordName = prefix + attributeName;
                FieldBridge fieldBridge = BridgeFactory.guessType(null, member, this.reflectionManager);
                if (!(fieldBridge instanceof TwoWayFieldBridge)) {
                    throw new SearchException("Bridge for document id does not implement TwoWayFieldBridge: " + member.getName());
                }
                this.idBridge = (TwoWayFieldBridge)fieldBridge;
                this.idBoost = this.getBoost(member, null);
                ReflectionHelper.setAccessible(member);
                this.idGetter = member;
            } else {
                ReflectionHelper.setAccessible(member);
                propertiesMetadata.fieldGetters.add(member);
                String fieldName = prefix + attributeName;
                propertiesMetadata.fieldNames.add(fieldName);
                propertiesMetadata.fieldStore.add(this.getStore(Store.YES));
                propertiesMetadata.fieldIndex.add(this.getIndex(Index.UN_TOKENIZED));
                propertiesMetadata.fieldTermVectors.add(this.getTermVector(TermVector.NO));
                propertiesMetadata.fieldBridges.add(BridgeFactory.guessType(null, member, this.reflectionManager));
                propertiesMetadata.fieldBoosts.add(this.getBoost(member, null));
                Analyzer analyzer = this.getAnalyzer(member, context);
                if (analyzer == null) {
                    analyzer = propertiesMetadata.analyzer;
                }
                if (analyzer == null) {
                    throw new AssertionFailure("Analizer should not be undefined");
                }
                this.analyzer.addScopedAnalyzer(fieldName, analyzer);
            }
        }
    }

    private Annotation getIdAnnotation(XProperty member, InitContext context) {
        DocumentId documentIdAnn = member.getAnnotation(DocumentId.class);
        if (documentIdAnn != null) {
            this.explicitDocumentId = true;
            return documentIdAnn;
        }
        if (!this.explicitDocumentId && context.isJpaPresent()) {
            Class idClass;
            try {
                idClass = ReflectHelper.classForName("javax.persistence.Id", InitContext.class);
            }
            catch (ClassNotFoundException e) {
                throw new SearchException("Unable to load @Id.class even though it should be present ?!");
            }
            documentIdAnn = member.getAnnotation(idClass);
            if (documentIdAnn != null) {
                log.debug("Found JPA id and using it as document id");
            }
        }
        return documentIdAnn;
    }

    private ProvidedId findProvidedId(XClass clazz, ReflectionManager reflectionManager) {
        ProvidedId id = null;
        XClass currentClass = clazz;
        while (id == null && !reflectionManager.equals(currentClass, Object.class)) {
            id = currentClass.getAnnotation(ProvidedId.class);
            currentClass = clazz.getSuperclass();
        }
        return id;
    }

    @Override
    public void addWorkToQueue(Class<T> entityClass, T entity, Serializable id, WorkType workType, List<LuceneWork> queue, SearchFactoryImplementor searchFactoryImplementor) {
        ArrayList<LuceneWork> toDelete = new ArrayList<LuceneWork>();
        boolean duplicateDelete = false;
        for (LuceneWork luceneWork : queue) {
            Serializable currentId;
            if (luceneWork.getEntityClass() != entityClass || (currentId = luceneWork.getId()) == null || !currentId.equals(id)) continue;
            if (workType == WorkType.DELETE) {
                if (luceneWork instanceof AddLuceneWork) {
                    toDelete.add(luceneWork);
                    continue;
                }
                if (!(luceneWork instanceof DeleteLuceneWork)) continue;
                duplicateDelete = true;
                continue;
            }
            return;
        }
        for (LuceneWork luceneWork : toDelete) {
            queue.remove(luceneWork);
        }
        if (duplicateDelete) {
            return;
        }
        String idInString = this.idBridge.objectToString(id);
        if (workType == WorkType.ADD) {
            queue.add(this.createAddWork(entityClass, entity, id, idInString, false));
        } else if (workType == WorkType.DELETE || workType == WorkType.PURGE) {
            queue.add(new DeleteLuceneWork(id, idInString, entityClass));
        } else if (workType == WorkType.PURGE_ALL) {
            queue.add(new PurgeAllLuceneWork(entityClass));
        } else if (workType == WorkType.UPDATE || workType == WorkType.COLLECTION) {
            queue.add(new DeleteLuceneWork(id, idInString, entityClass));
            queue.add(this.createAddWork(entityClass, entity, id, idInString, false));
        } else if (workType == WorkType.INDEX) {
            queue.add(new DeleteLuceneWork(id, idInString, entityClass));
            queue.add(this.createAddWork(entityClass, entity, id, idInString, true));
        } else {
            throw new AssertionFailure("Unknown WorkType: " + (Object)((Object)workType));
        }
        super.addWorkToQueue(entityClass, entity, id, workType, queue, searchFactoryImplementor);
    }

    private AddLuceneWork createAddWork(Class<T> entityClass, T entity, Serializable id, String idInString, boolean isBatch) {
        HashMap<String, String> fieldToAnalyzerMap = new HashMap<String, String>();
        Document doc = this.getDocument(entity, id, fieldToAnalyzerMap);
        AddLuceneWork addWork = fieldToAnalyzerMap.isEmpty() ? new AddLuceneWork(id, idInString, entityClass, doc, isBatch) : new AddLuceneWork(id, idInString, entityClass, doc, fieldToAnalyzerMap, isBatch);
        return addWork;
    }

    public Document getDocument(T instance, Serializable id, Map<String, String> fieldToAnalyzerMap) {
        if (fieldToAnalyzerMap == null) {
            throw new IllegalArgumentException("fieldToAnalyzerMap cannot be null");
        }
        Document doc = new Document();
        Class entityType = Hibernate.getClass(instance);
        if (this.metadata.boost != null) {
            doc.setBoost(this.metadata.boost.floatValue());
        }
        Field classField = new Field("_hibernate_class", entityType.getName(), Field.Store.YES, Field.Index.NOT_ANALYZED, Field.TermVector.NO);
        doc.add(classField);
        LuceneOptionsImpl luceneOptions = new LuceneOptionsImpl(Field.Store.YES, Field.Index.NOT_ANALYZED, Field.TermVector.NO, this.idBoost);
        this.idBridge.set(this.idKeywordName, id, doc, luceneOptions);
        HashSet<String> processedFieldNames = new HashSet<String>();
        this.buildDocumentFields(instance, doc, this.metadata, fieldToAnalyzerMap, processedFieldNames);
        return doc;
    }

    private void buildDocumentFields(Object instance, Document doc, DocumentBuilderContainedEntity.PropertiesMetadata propertiesMetadata, Map<String, String> fieldToAnalyzerMap, Set<String> processedFieldNames) {
        Object value;
        XMember member;
        int i;
        if (instance == null) {
            return;
        }
        Object unproxiedInstance = this.unproxy(instance);
        for (i = 0; i < propertiesMetadata.classBridges.size(); ++i) {
            FieldBridge fb = propertiesMetadata.classBridges.get(i);
            fb.set(propertiesMetadata.classNames.get(i), unproxiedInstance, doc, propertiesMetadata.getClassLuceneOptions(i));
        }
        for (i = 0; i < propertiesMetadata.fieldNames.size(); ++i) {
            member = propertiesMetadata.fieldGetters.get(i);
            value = ReflectionHelper.getMemberValue(unproxiedInstance, member);
            propertiesMetadata.fieldBridges.get(i).set(propertiesMetadata.fieldNames.get(i), value, doc, propertiesMetadata.getFieldLuceneOptions(i));
        }
        this.allowAnalyzerDiscriminatorOverride(doc, propertiesMetadata, fieldToAnalyzerMap, processedFieldNames, unproxiedInstance);
        block8: for (i = 0; i < propertiesMetadata.embeddedGetters.size(); ++i) {
            member = propertiesMetadata.embeddedGetters.get(i);
            value = ReflectionHelper.getMemberValue(unproxiedInstance, member);
            if (value == null) continue;
            DocumentBuilderContainedEntity.PropertiesMetadata embeddedMetadata = propertiesMetadata.embeddedPropertiesMetadata.get(i);
            switch (propertiesMetadata.embeddedContainers.get(i)) {
                case ARRAY: {
                    for (Object arrayValue : (Object[])value) {
                        this.buildDocumentFields(arrayValue, doc, embeddedMetadata, fieldToAnalyzerMap, processedFieldNames);
                    }
                    continue block8;
                }
                case COLLECTION: {
                    for (Object collectionValue : (Collection)value) {
                        this.buildDocumentFields(collectionValue, doc, embeddedMetadata, fieldToAnalyzerMap, processedFieldNames);
                    }
                    continue block8;
                }
                case MAP: {
                    for (Object collectionValue : ((Map)value).values()) {
                        this.buildDocumentFields(collectionValue, doc, embeddedMetadata, fieldToAnalyzerMap, processedFieldNames);
                    }
                    continue block8;
                }
                case OBJECT: {
                    this.buildDocumentFields(value, doc, embeddedMetadata, fieldToAnalyzerMap, processedFieldNames);
                    continue block8;
                }
                default: {
                    throw new AssertionFailure("Unknown embedded container: " + (Object)((Object)propertiesMetadata.embeddedContainers.get(i)));
                }
            }
        }
    }

    private void allowAnalyzerDiscriminatorOverride(Document doc, DocumentBuilderContainedEntity.PropertiesMetadata propertiesMetadata, Map<String, String> fieldToAnalyzerMap, Set<String> processedFieldNames, Object unproxiedInstance) {
        Discriminator discriminator = propertiesMetadata.discriminator;
        if (discriminator == null) {
            return;
        }
        Object value = null;
        if (propertiesMetadata.discriminatorGetter != null) {
            value = ReflectionHelper.getMemberValue(unproxiedInstance, propertiesMetadata.discriminatorGetter);
        }
        for (Object o : doc.getFields()) {
            Field field = (Field)o;
            if (processedFieldNames.contains(field.name())) continue;
            String analyzerName = discriminator.getAnanyzerDefinitionName(value, unproxiedInstance, field.name());
            if (analyzerName != null) {
                fieldToAnalyzerMap.put(field.name(), analyzerName);
            }
            processedFieldNames.add(field.name());
        }
    }

    private Object unproxy(Object value) {
        if (value instanceof HibernateProxy) {
            value = ((HibernateProxy)value).getHibernateLazyInitializer().getImplementation();
        }
        return value;
    }

    public String getIdentifierName() {
        return this.idGetter.getName();
    }

    public DirectoryProvider[] getDirectoryProviders() {
        if (this.entityState != EntityState.INDEXED) {
            throw new AssertionFailure("Contained in only entity: getDirectoryProvider should not have been called.");
        }
        return this.directoryProviders;
    }

    public IndexShardingStrategy getDirectoryProviderSelectionStrategy() {
        if (this.entityState != EntityState.INDEXED) {
            throw new AssertionFailure("Contained in only entity: getDirectoryProviderSelectionStrategy should not have been called.");
        }
        return this.shardingStrategy;
    }

    public boolean allowFieldSelectionInProjection() {
        return this.allowFieldSelectionInProjection;
    }

    public boolean isSafeFromTupleId() {
        return this.safeFromTupleId;
    }

    public Term getTerm(Serializable id) {
        if (this.idProvided) {
            return new Term(this.idKeywordName, (String)((Object)id));
        }
        return new Term(this.idKeywordName, this.idBridge.objectToString(id));
    }

    public TwoWayFieldBridge getIdBridge() {
        return this.idBridge;
    }

    public static Class getDocumentClass(Document document) {
        String className = document.get("_hibernate_class");
        try {
            return org.hibernate.annotations.common.util.ReflectHelper.classForName(className);
        }
        catch (ClassNotFoundException e) {
            throw new SearchException("Unable to load indexed class: " + className, e);
        }
    }

    public String getIdKeywordName() {
        return this.idKeywordName;
    }

    public static Serializable getDocumentId(SearchFactoryImplementor searchFactoryImplementor, Class<?> clazz, Document document) {
        DocumentBuilderIndexedEntity<?> builderIndexedEntity = searchFactoryImplementor.getDocumentBuilderIndexedEntity(clazz);
        if (builderIndexedEntity == null) {
            throw new SearchException("No Lucene configuration set up for: " + clazz.getName());
        }
        return (Serializable)builderIndexedEntity.getIdBridge().get(builderIndexedEntity.getIdKeywordName(), document);
    }

    public static Object[] getDocumentFields(SearchFactoryImplementor searchFactoryImplementor, Class<?> clazz, Document document, String[] fields) {
        DocumentBuilderIndexedEntity<?> builderIndexedEntity = searchFactoryImplementor.getDocumentBuilderIndexedEntity(clazz);
        if (builderIndexedEntity == null) {
            throw new SearchException("No Lucene configuration set up for: " + clazz.getName());
        }
        int fieldNbr = fields.length;
        Object[] result = new Object[fieldNbr];
        if (builderIndexedEntity.idKeywordName != null) {
            DocumentBuilderIndexedEntity.populateResult(builderIndexedEntity.idKeywordName, builderIndexedEntity.idBridge, Field.Store.YES, fields, result, document);
        }
        DocumentBuilderContainedEntity.PropertiesMetadata metadata = builderIndexedEntity.metadata;
        DocumentBuilderIndexedEntity.processFieldsForProjection(metadata, fields, result, document);
        return result;
    }

    private static void populateResult(String fieldName, FieldBridge fieldBridge, Field.Store store, String[] fields, Object[] result, Document document) {
        int matchingPosition = DocumentBuilderIndexedEntity.getFieldPosition(fields, fieldName);
        if (matchingPosition != -1) {
            if (store != Field.Store.NO && TwoWayFieldBridge.class.isAssignableFrom(fieldBridge.getClass())) {
                result[matchingPosition] = ((TwoWayFieldBridge)fieldBridge).get(fieldName, document);
                if (log.isTraceEnabled()) {
                    log.trace("Field {} projected as {}", (Object)fieldName, result[matchingPosition]);
                }
            } else {
                if (store == Field.Store.NO) {
                    throw new SearchException("Projecting an unstored field: " + fieldName);
                }
                throw new SearchException("FieldBridge is not a TwoWayFieldBridge: " + fieldBridge.getClass());
            }
        }
    }

    private static void processFieldsForProjection(DocumentBuilderContainedEntity.PropertiesMetadata metadata, String[] fields, Object[] result, Document document) {
        int nbrFoEntityFields = metadata.fieldNames.size();
        for (int index = 0; index < nbrFoEntityFields; ++index) {
            DocumentBuilderIndexedEntity.populateResult(metadata.fieldNames.get(index), metadata.fieldBridges.get(index), metadata.fieldStore.get(index), fields, result, document);
        }
        int nbrOfEmbeddedObjects = metadata.embeddedPropertiesMetadata.size();
        for (int index = 0; index < nbrOfEmbeddedObjects; ++index) {
            if (metadata.embeddedContainers.get(index) != DocumentBuilderContainedEntity.PropertiesMetadata.Container.OBJECT) continue;
            DocumentBuilderIndexedEntity.processFieldsForProjection(metadata.embeddedPropertiesMetadata.get(index), fields, result, document);
        }
    }

    private static int getFieldPosition(String[] fields, String fieldName) {
        int fieldNbr = fields.length;
        for (int index = 0; index < fieldNbr; ++index) {
            if (!fieldName.equals(fields[index])) continue;
            return index;
        }
        return -1;
    }

    private void checkAllowFieldSelection() {
        this.allowFieldSelectionInProjection = true;
        if (!(this.idBridge instanceof TwoWayStringBridge) && !(this.idBridge instanceof TwoWayString2FieldBridgeAdaptor)) {
            this.allowFieldSelectionInProjection = false;
            return;
        }
        for (FieldBridge bridge : this.metadata.fieldBridges) {
            if (bridge instanceof TwoWayStringBridge || bridge instanceof TwoWayString2FieldBridgeAdaptor) continue;
            this.allowFieldSelectionInProjection = false;
            return;
        }
    }
}

