/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxb.JAXBUtils;
import org.apache.cxf.service.ServiceModelVisitor;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.ServiceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JAXBContextInitializer
extends ServiceModelVisitor {
    private Set<Class<?>> classes;

    public JAXBContextInitializer(ServiceInfo serviceInfo, Set<Class<?>> classes) {
        super(serviceInfo);
        this.classes = classes;
    }

    @Override
    public void begin(MessagePartInfo part) {
        Class<?> genericType;
        boolean isFromWrapper;
        Class<?> clazz = part.getTypeClass();
        if (clazz == null) {
            return;
        }
        if (Exception.class.isAssignableFrom(clazz)) {
            part.setProperty(JAXBDataBinding.class.getName() + ".CUSTOM_EXCEPTION", Boolean.TRUE);
        }
        if ((isFromWrapper = part.getMessageInfo().getOperation().isUnwrapped()) && clazz.isArray() && !Byte.TYPE.equals(clazz.getComponentType())) {
            clazz = clazz.getComponentType();
        }
        if ((genericType = (Class<?>)part.getProperty("generic.type")) != null) {
            boolean isList = Collection.class.isAssignableFrom(clazz);
            if (isFromWrapper) {
                if (genericType instanceof Class && ((Class)genericType).isArray()) {
                    Class cl2 = genericType;
                    if (cl2.isArray() && !Byte.TYPE.equals(cl2.getComponentType())) {
                        genericType = cl2.getComponentType();
                    }
                    this.addType(genericType);
                } else if (!isList) {
                    this.addType(genericType);
                }
            } else {
                this.addType(genericType);
            }
            if (isList && genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)((Object)genericType);
                if (pt.getActualTypeArguments().length > 0 && pt.getActualTypeArguments()[0] instanceof Class) {
                    Class<?> arrayCls = Array.newInstance((Class)pt.getActualTypeArguments()[0], 0).getClass();
                    clazz = arrayCls;
                    part.setTypeClass(clazz);
                    if (isFromWrapper) {
                        this.addType(clazz.getComponentType());
                    }
                } else if (pt.getActualTypeArguments().length > 0 && pt.getActualTypeArguments()[0] instanceof GenericArrayType) {
                    GenericArrayType gat = (GenericArrayType)pt.getActualTypeArguments()[0];
                    gat.getGenericComponentType();
                    Class<?> arrayCls = Array.newInstance((Class)gat.getGenericComponentType(), 0).getClass();
                    clazz = Array.newInstance(arrayCls, 0).getClass();
                    part.setTypeClass(clazz);
                    if (isFromWrapper) {
                        this.addType(clazz.getComponentType());
                    }
                }
            }
            if (isFromWrapper && isList) {
                clazz = null;
            }
        }
        if (clazz != null) {
            this.addClass(clazz);
        }
    }

    private void addType(Type cls) {
        if (cls instanceof Class) {
            this.addClass((Class)cls);
        } else if (cls instanceof ParameterizedType) {
            for (Type t2 : ((ParameterizedType)cls).getActualTypeArguments()) {
                this.addType(t2);
            }
        } else if (cls instanceof GenericArrayType) {
            GenericArrayType gt = (GenericArrayType)cls;
            Class<?> ct = (Class<?>)gt.getGenericComponentType();
            ct = Array.newInstance(ct, 0).getClass();
            this.addClass(ct);
        }
    }

    private void addClass(Class<?> cls) {
        if (cls.isArray() && cls.getComponentType().isPrimitive()) {
            return;
        }
        if (Throwable.class.isAssignableFrom(cls)) {
            if (!Throwable.class.equals(cls) && !Exception.class.equals(cls)) {
                this.walkReferences(cls);
            }
            this.addClass(String.class);
        } else if (null != (cls = JAXBUtils.getValidClass(cls))) {
            if (this.classes.contains(cls)) {
                return;
            }
            if (cls.getSuperclass() != null) {
                this.addClass(cls.getSuperclass());
            }
            if (cls.isEnum()) {
                this.classes.add(cls);
            }
            this.classes.add(cls);
            this.walkReferences(cls);
        }
    }

    private void walkReferences(Class<?> cls) {
        XmlAccessType accessType;
        if (cls == null) {
            return;
        }
        if (cls.getName().startsWith("java.") || cls.getName().startsWith("javax.")) {
            return;
        }
        XmlAccessorType accessorType = cls.getAnnotation(XmlAccessorType.class);
        if (accessorType == null && cls.getPackage() != null) {
            accessorType = cls.getPackage().getAnnotation(XmlAccessorType.class);
        }
        XmlAccessType xmlAccessType = accessType = accessorType != null ? accessorType.value() : XmlAccessType.PUBLIC_MEMBER;
        if (accessType != XmlAccessType.PROPERTY) {
            Field[] fields = cls.getDeclaredFields();
            for (AccessibleObject accessibleObject : fields) {
                if (!JAXBContextInitializer.isFieldAccepted((Field)accessibleObject, accessType)) continue;
                this.addType(((Field)accessibleObject).getGenericType());
            }
            this.walkReferences(cls.getSuperclass());
        }
        if (accessType != XmlAccessType.FIELD) {
            Method[] methods = cls.getDeclaredMethods();
            for (AccessibleObject accessibleObject : methods) {
                if (!JAXBContextInitializer.isMethodAccepted((Method)accessibleObject, accessType)) continue;
                this.addType(((Method)accessibleObject).getGenericReturnType());
                for (Type t : ((Method)accessibleObject).getGenericParameterTypes()) {
                    this.addType(t);
                }
            }
        }
    }

    static boolean isFieldAccepted(Field field, XmlAccessType accessType) {
        if (Modifier.isStatic(field.getModifiers()) || field.isAnnotationPresent(XmlTransient.class)) {
            return false;
        }
        if (accessType == XmlAccessType.PUBLIC_MEMBER && !Modifier.isPublic(field.getModifiers())) {
            return false;
        }
        if (field.getAnnotation(XmlJavaTypeAdapter.class) != null) {
            return false;
        }
        if (accessType == XmlAccessType.NONE || accessType == XmlAccessType.PROPERTY) {
            return JAXBContextInitializer.checkJaxbAnnotation(field.getAnnotations());
        }
        return true;
    }

    static boolean isMethodAccepted(Method method, XmlAccessType accessType) {
        boolean isPropGetter;
        if (Modifier.isStatic(method.getModifiers()) || method.isAnnotationPresent(XmlTransient.class) || !Modifier.isPublic(method.getModifiers())) {
            return false;
        }
        if (method.getReturnType() == Void.class || method.getParameterTypes().length != 0 || method.getDeclaringClass().equals(Throwable.class)) {
            return false;
        }
        boolean bl = isPropGetter = method.getName().startsWith("get") || method.getName().startsWith("is");
        if (!isPropGetter || method.getAnnotation(XmlJavaTypeAdapter.class) != null) {
            return false;
        }
        int beginIndex = 3;
        if (method.getName().startsWith("is")) {
            beginIndex = 2;
        }
        try {
            method.getDeclaringClass().getMethod("set" + method.getName().substring(beginIndex), method.getReturnType());
        }
        catch (Exception e) {
            return false;
        }
        if (accessType == XmlAccessType.NONE || accessType == XmlAccessType.FIELD) {
            return JAXBContextInitializer.checkJaxbAnnotation(method.getAnnotations());
        }
        return true;
    }

    private static boolean checkJaxbAnnotation(Annotation[] annotations) {
        Package jaxbAnnotationsPackage = XmlElement.class.getPackage();
        for (Annotation annotation : annotations) {
            if (annotation.annotationType().getPackage() != jaxbAnnotationsPackage) continue;
            return true;
        }
        return false;
    }
}

