/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.felix.framework.Logger;
import org.apache.felix.framework.ServiceReferenceImpl;
import org.apache.felix.framework.ServiceRegistrationImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.hooks.service.ListenerHook;

public class ServiceRegistry {
    private Logger m_logger = null;
    private long m_currentServiceId = 1L;
    private Map m_serviceRegsMap = new HashMap();
    private Map m_lockedRegsMap = new HashMap();
    private Map m_inUseMap = new HashMap();
    private ServiceListener m_serviceListener = null;
    private final List m_listenerHooks = new ArrayList();
    static /* synthetic */ Class class$org$osgi$framework$hooks$service$ListenerHook;

    public ServiceRegistry(Logger logger) {
        this.m_logger = logger;
    }

    public synchronized ServiceReference[] getRegisteredServices(Bundle bundle) {
        ServiceRegistration[] regs = (ServiceRegistration[])this.m_serviceRegsMap.get(bundle);
        if (regs != null) {
            ServiceReference[] refs = new ServiceReference[regs.length];
            for (int i = 0; i < refs.length; ++i) {
                refs[i] = regs[i].getReference();
            }
            return refs;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceRegistration registerService(Bundle bundle, String[] classNames, Object svcObj, Dictionary dict) {
        ServiceRegistrationImpl reg = null;
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            this.addHooks(classNames, svcObj);
            reg = new ServiceRegistrationImpl(this, bundle, classNames, new Long(this.m_currentServiceId++), svcObj, dict);
            ServiceRegistration[] regs = (ServiceRegistration[])this.m_serviceRegsMap.get(bundle);
            this.m_serviceRegsMap.put(bundle, ServiceRegistry.addServiceRegistration(regs, reg));
        }
        this.fireServiceChanged(new ServiceEvent(1, reg.getReference()));
        return reg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterService(Bundle bundle, ServiceRegistration reg) {
        this.removeHook(((ServiceRegistrationImpl)reg).getService());
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            ServiceRegistration[] regs = (ServiceRegistration[])this.m_serviceRegsMap.get(bundle);
            this.m_serviceRegsMap.put(bundle, ServiceRegistry.removeServiceRegistration(regs, reg));
        }
        this.fireServiceChanged(new ServiceEvent(4, reg.getReference()));
        serviceRegistry = this;
        synchronized (serviceRegistry) {
            Bundle[] clients = this.getUsingBundles(reg.getReference());
            for (int i = 0; clients != null && i < clients.length; ++i) {
                while (this.ungetService(clients[i], reg.getReference())) {
                }
            }
            ((ServiceRegistrationImpl)reg).invalidate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterServices(Bundle bundle) {
        ServiceRegistration[] regs = null;
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            regs = (ServiceRegistration[])this.m_serviceRegsMap.get(bundle);
        }
        for (int i = 0; regs != null && i < regs.length; ++i) {
            regs[i].unregister();
        }
        ServiceRegistry serviceRegistry2 = this;
        synchronized (serviceRegistry2) {
            this.m_serviceRegsMap.remove(bundle);
        }
    }

    public synchronized List getServiceReferences(String className, Filter filter) {
        ArrayList<ServiceReference> list = new ArrayList<ServiceReference>();
        Iterator i = this.m_serviceRegsMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            ServiceRegistration[] regs = (ServiceRegistration[])entry.getValue();
            for (int regIdx = 0; regs != null && regIdx < regs.length; ++regIdx) {
                boolean matched = false;
                if (className == null && (filter == null || filter.match(regs[regIdx].getReference()))) {
                    matched = true;
                } else if (className != null) {
                    String[] objectClass = (String[])((ServiceRegistrationImpl)regs[regIdx]).getProperty("objectClass");
                    for (int classIdx = 0; classIdx < objectClass.length; ++classIdx) {
                        if (!objectClass[classIdx].equals(className) || filter != null && !filter.match(regs[regIdx].getReference())) continue;
                        matched = true;
                        break;
                    }
                }
                if (!matched) continue;
                list.add(regs[regIdx].getReference());
            }
        }
        return list;
    }

    public synchronized ServiceReference[] getServicesInUse(Bundle bundle) {
        UsageCount[] usages = (UsageCount[])this.m_inUseMap.get(bundle);
        if (usages != null) {
            ServiceReference[] refs = new ServiceReference[usages.length];
            for (int i = 0; i < refs.length; ++i) {
                refs[i] = usages[i].m_ref;
            }
            return refs;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(Bundle bundle, ServiceReference ref) {
        Object svcObj;
        block24: {
            UsageCount usage = null;
            svcObj = null;
            ServiceRegistrationImpl reg = ((ServiceReferenceImpl)ref).getServiceRegistration();
            ServiceRegistry serviceRegistry = this;
            synchronized (serviceRegistry) {
                Object o = this.m_lockedRegsMap.get(reg);
                while (o != null) {
                    if (o.equals(Thread.currentThread())) {
                        throw new IllegalStateException("ServiceFactory.getService() resulted in a cycle.");
                    }
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    o = this.m_lockedRegsMap.get(reg);
                }
                this.m_lockedRegsMap.put(reg, Thread.currentThread());
                if (!reg.isValid()) {
                    this.flushUsageCount(bundle, ref);
                } else {
                    usage = this.getUsageCount(bundle, ref);
                    if (usage != null) {
                        ++usage.m_count;
                        svcObj = usage.m_svcObj;
                    }
                }
            }
            try {
                if (!reg.isValid() || usage != null || (svcObj = reg.getService(bundle)) == null) break block24;
                serviceRegistry = this;
                synchronized (serviceRegistry) {
                    if (reg.isValid()) {
                        this.addUsageCount(bundle, ref, svcObj);
                    } else {
                        svcObj = null;
                    }
                }
            }
            finally {
                serviceRegistry = this;
                synchronized (serviceRegistry) {
                    this.m_lockedRegsMap.remove(reg);
                    this.notifyAll();
                }
            }
        }
        return svcObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean ungetService(Bundle bundle, ServiceReference ref) {
        UsageCount usage = null;
        ServiceRegistrationImpl reg = ((ServiceReferenceImpl)ref).getServiceRegistration();
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            Object o = this.m_lockedRegsMap.get(reg);
            while (o != null) {
                if (o.equals(Thread.currentThread())) {
                    throw new IllegalStateException("ServiceFactory.ungetService() resulted in a cycle.");
                }
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                o = this.m_lockedRegsMap.get(reg);
            }
            usage = this.getUsageCount(bundle, ref);
            if (usage == null) {
                return false;
            }
            this.m_lockedRegsMap.put(reg, Thread.currentThread());
            if (!reg.isValid()) {
                this.flushUsageCount(bundle, ref);
            } else if (reg.isValid()) {
                --usage.m_count;
            }
            if (usage.m_count == 0) {
                this.flushUsageCount(bundle, ref);
            }
        }
        try {
            if (usage.m_count == 0) {
                ((ServiceReferenceImpl)ref).getServiceRegistration().ungetService(bundle, usage.m_svcObj);
                usage.m_svcObj = null;
            }
        }
        finally {
            serviceRegistry = this;
            synchronized (serviceRegistry) {
                this.m_lockedRegsMap.remove(reg);
                this.notifyAll();
            }
        }
        return usage.m_count > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ungetServices(Bundle bundle) {
        UsageCount[] usages;
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            usages = (UsageCount[])this.m_inUseMap.get(bundle);
        }
        if (usages == null) {
            return;
        }
        for (int i = 0; i < usages.length; ++i) {
            while (this.ungetService(bundle, usages[i].m_ref)) {
            }
        }
    }

    public synchronized Bundle[] getUsingBundles(ServiceReference ref) {
        Bundle[] bundles = null;
        Iterator iter = this.m_inUseMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Bundle bundle = (Bundle)entry.getKey();
            UsageCount[] usages = (UsageCount[])entry.getValue();
            for (int useIdx = 0; useIdx < usages.length; ++useIdx) {
                if (!usages[useIdx].m_ref.equals(ref)) continue;
                if (bundles == null) {
                    bundles = new Bundle[]{bundle};
                    continue;
                }
                Bundle[] nbs = new Bundle[bundles.length + 1];
                System.arraycopy(bundles, 0, nbs, 0, bundles.length);
                nbs[bundles.length] = bundle;
                bundles = nbs;
            }
        }
        return bundles;
    }

    public void servicePropertiesModified(ServiceRegistration reg) {
        this.fireServiceChanged(new ServiceEvent(2, reg.getReference()));
    }

    public Logger getLogger() {
        return this.m_logger;
    }

    private static ServiceRegistration[] addServiceRegistration(ServiceRegistration[] regs, ServiceRegistration reg) {
        if (regs == null) {
            regs = new ServiceRegistration[]{reg};
        } else {
            ServiceRegistration[] newRegs = new ServiceRegistration[regs.length + 1];
            System.arraycopy(regs, 0, newRegs, 0, regs.length);
            newRegs[regs.length] = reg;
            regs = newRegs;
        }
        return regs;
    }

    private static ServiceRegistration[] removeServiceRegistration(ServiceRegistration[] regs, ServiceRegistration reg) {
        for (int i = 0; regs != null && i < regs.length; ++i) {
            if (!regs[i].equals(reg)) continue;
            if (regs.length - 1 == 0) {
                regs = new ServiceRegistration[]{};
                continue;
            }
            ServiceRegistration[] newRegs = new ServiceRegistration[regs.length - 1];
            System.arraycopy(regs, 0, newRegs, 0, i);
            if (i < newRegs.length) {
                System.arraycopy(regs, i + 1, newRegs, i, newRegs.length - i);
            }
            regs = newRegs;
        }
        return regs;
    }

    public synchronized void addServiceListener(ServiceListener l) {
        this.m_serviceListener = ServiceListenerMulticaster.add(this.m_serviceListener, l);
    }

    public synchronized void removeServiceListener(ServiceListener l) {
        this.m_serviceListener = ServiceListenerMulticaster.remove(this.m_serviceListener, l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireServiceChanged(ServiceEvent event) {
        ServiceListener listener;
        ServiceRegistry serviceRegistry = this;
        synchronized (serviceRegistry) {
            listener = this.m_serviceListener;
        }
        if (listener != null) {
            listener.serviceChanged(event);
        }
    }

    private UsageCount getUsageCount(Bundle bundle, ServiceReference ref) {
        UsageCount[] usages = (UsageCount[])this.m_inUseMap.get(bundle);
        for (int i = 0; usages != null && i < usages.length; ++i) {
            if (!usages[i].m_ref.equals(ref)) continue;
            return usages[i];
        }
        return null;
    }

    private void addUsageCount(Bundle bundle, ServiceReference ref, Object svcObj) {
        UsageCount[] usages = (UsageCount[])this.m_inUseMap.get(bundle);
        UsageCount usage = new UsageCount();
        usage.m_ref = ref;
        usage.m_svcObj = svcObj;
        ++usage.m_count;
        if (usages == null) {
            usages = new UsageCount[]{usage};
        } else {
            UsageCount[] newUsages = new UsageCount[usages.length + 1];
            System.arraycopy(usages, 0, newUsages, 0, usages.length);
            newUsages[usages.length] = usage;
            usages = newUsages;
        }
        this.m_inUseMap.put(bundle, usages);
    }

    private void flushUsageCount(Bundle bundle, ServiceReference ref) {
        UsageCount[] usages = (UsageCount[])this.m_inUseMap.get(bundle);
        for (int i = 0; usages != null && i < usages.length; ++i) {
            if (!usages[i].m_ref.equals(ref)) continue;
            if (usages.length - 1 == 0) {
                usages = null;
                continue;
            }
            UsageCount[] newUsages = new UsageCount[usages.length - 1];
            System.arraycopy(usages, 0, newUsages, 0, i);
            if (i < newUsages.length) {
                System.arraycopy(usages, i + 1, newUsages, i, newUsages.length - i);
            }
            usages = newUsages;
        }
        if (usages != null) {
            this.m_inUseMap.put(bundle, usages);
        } else {
            this.m_inUseMap.remove(bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addHooks(String[] classNames, Object svcObj) {
        if (this.isHook(classNames, class$org$osgi$framework$hooks$service$ListenerHook == null ? (class$org$osgi$framework$hooks$service$ListenerHook = ServiceRegistry.class$("org.osgi.framework.hooks.service.ListenerHook")) : class$org$osgi$framework$hooks$service$ListenerHook, svcObj)) {
            List list = this.m_listenerHooks;
            synchronized (list) {
                this.m_listenerHooks.add(svcObj);
            }
        }
    }

    boolean isHook(String[] classNames, Class hookClass, Object svcObj) {
        if (hookClass.isAssignableFrom(svcObj.getClass())) {
            String hookName = hookClass.getName();
            for (int i = 0; i < classNames.length; ++i) {
                if (!classNames[i].equals(hookName)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeHook(Object svcObj) {
        if (svcObj instanceof ListenerHook) {
            List list = this.m_listenerHooks;
            synchronized (list) {
                this.m_listenerHooks.remove(svcObj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ListenerHook[] getListenerHooks() {
        List list = this.m_listenerHooks;
        synchronized (list) {
            return this.m_listenerHooks.toArray(new ListenerHook[this.m_listenerHooks.size()]);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class UsageCount {
        public int m_count = 0;
        public ServiceReference m_ref = null;
        public Object m_svcObj = null;

        private UsageCount() {
        }
    }

    private static class ServiceListenerMulticaster
    implements ServiceListener {
        protected ServiceListener m_a = null;
        protected ServiceListener m_b = null;

        protected ServiceListenerMulticaster(ServiceListener a, ServiceListener b) {
            this.m_a = a;
            this.m_b = b;
        }

        public void serviceChanged(ServiceEvent e) {
            this.m_a.serviceChanged(e);
            this.m_b.serviceChanged(e);
        }

        public static ServiceListener add(ServiceListener a, ServiceListener b) {
            if (a == null) {
                return b;
            }
            if (b == null) {
                return a;
            }
            return new ServiceListenerMulticaster(a, b);
        }

        public static ServiceListener remove(ServiceListener a, ServiceListener b) {
            if (a == null || a == b) {
                return null;
            }
            if (a instanceof ServiceListenerMulticaster) {
                return ServiceListenerMulticaster.add(ServiceListenerMulticaster.remove(((ServiceListenerMulticaster)a).m_a, b), ServiceListenerMulticaster.remove(((ServiceListenerMulticaster)a).m_b, b));
            }
            return a;
        }
    }
}

