/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.framework.util.manifestparser;

public class R4Library {
    private String m_libraryFile;
    private String[] m_osnames;
    private String[] m_processors;
    private String[] m_osversions;
    private String[] m_languages;
    private String m_selectionFilter;

    public R4Library(String libraryFile, String[] osnames, String[] processors, String[] osversions, String[] languages, String selectionFilter) throws Exception {
        this.m_libraryFile = libraryFile;
        this.m_osnames = osnames;
        this.m_processors = processors;
        this.m_osversions = osversions;
        this.m_languages = languages;
        this.m_selectionFilter = selectionFilter;
    }

    public String getEntryName() {
        return this.m_libraryFile;
    }

    public String[] getOSNames() {
        return this.m_osnames;
    }

    public String[] getProcessors() {
        return this.m_processors;
    }

    public String[] getOSVersions() {
        return this.m_osversions;
    }

    public String[] getLanguages() {
        return this.m_languages;
    }

    public String getSelectionFilter() {
        return this.m_selectionFilter;
    }

    public boolean match(String name) {
        String libname = System.mapLibraryName(name);
        if (this.m_libraryFile.equals(libname) || this.m_libraryFile.endsWith("/" + libname)) {
            return true;
        }
        return libname.endsWith(".jnilib") && this.m_libraryFile.endsWith(".dylib") ? this.m_libraryFile.equals(libname = libname.substring(0, libname.length() - 6) + "dylib") || this.m_libraryFile.endsWith("/" + libname) : this.m_libraryFile.equals(name) || this.m_libraryFile.endsWith("/" + name);
    }

    public String toString() {
        if (this.m_libraryFile != null) {
            int i;
            StringBuffer sb = new StringBuffer();
            sb.append(this.m_libraryFile);
            sb.append(';');
            for (i = 0; this.m_osnames != null && i < this.m_osnames.length; ++i) {
                sb.append("osname");
                sb.append('=');
                sb.append(this.m_osnames[i]);
                sb.append(';');
            }
            for (i = 0; this.m_processors != null && i < this.m_processors.length; ++i) {
                sb.append("processor");
                sb.append(this.m_processors[i]);
                sb.append(';');
            }
            for (i = 0; this.m_osversions != null && i < this.m_osversions.length; ++i) {
                sb.append("osversion");
                sb.append(this.m_osversions[i]);
                sb.append(';');
            }
            for (i = 0; this.m_languages != null && i < this.m_languages.length; ++i) {
                sb.append("language");
                sb.append(this.m_languages[i]);
                sb.append(';');
            }
            sb.append("selection-filter");
            sb.append('=');
            sb.append('\'');
            sb.append(this.m_selectionFilter);
            sb.append('\'');
            return sb.toString();
        }
        return "*";
    }
}

