/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.cxf.client.factory;

import java.io.IOException;
import java.net.URL;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.HandlerResolver;
import org.ow2.jonas.ws.jaxws.handler.JOnASHandlerResolver;
import org.ow2.jonas.ws.jaxws.handler.builder.DescriptorHandlerChainBuilder;
import org.ow2.jonas.ws.jaxws.handler.builder.HandlerChainBuilder;
import org.ow2.util.ee.builder.webserviceref.Constants;
import org.ow2.util.ee.builder.webserviceref.ReferenceHelper;
import org.ow2.util.ee.builder.webserviceref.factory.WebServiceRefObjectFactory;
import org.ow2.util.ee.metadata.common.api.xml.struct.IHandlerChains;
import org.ow2.util.ee.metadata.common.impl.xml.parsing.HandlerChainsLoader;
import org.ow2.util.ee.metadata.common.impl.xml.parsing.ParsingException;
import org.ow2.util.ee.metadata.common.impl.xml.struct.HandlerChains;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

public class CXFWebServiceRefObjectFactory
extends WebServiceRefObjectFactory {
    private static Log logger = LogFactory.getLog(CXFWebServiceRefObjectFactory.class);

    protected void processObjectInstance(Service service, ReferenceHelper reference) throws Exception {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        HandlerChains handlerChain = (HandlerChains)reference.extract(Constants.HANDLER_CHAIN_STRUCT.name(), HandlerChains.class);
        if (handlerChain != null) {
            JOnASHandlerResolver resolver = new JOnASHandlerResolver(service.getClass(), tccl);
            resolver.setHandlerChainBuilder((HandlerChainBuilder)new DescriptorHandlerChainBuilder((IHandlerChains)handlerChain));
            service.setHandlerResolver((HandlerResolver)resolver);
        } else {
            String file = reference.extract(Constants.HANDLER_CHAIN_FILE.name());
            String declaringClass = reference.extract(Constants.DECLARING_CLASS.name());
            if (file != null && declaringClass != null) {
                IHandlerChains handlerChainsElement;
                URL location;
                try {
                    location = new URL(file);
                }
                catch (IOException mue) {
                    Class<?> supportingClass = Class.forName(declaringClass, true, tccl);
                    logger.debug((Object)"@HandlerChain declaring class -> ''{0}''", new Object[]{supportingClass});
                    location = supportingClass.getResource(file);
                }
                logger.debug((Object)"@HandlerChain.file -> ''{0}''", new Object[]{location});
                try {
                    handlerChainsElement = HandlerChainsLoader.loadHandlerChains((URL)location, (boolean)true);
                }
                catch (ParsingException e) {
                    throw new WebServiceException("Cannot parse <handler-chains>", (Throwable)e);
                }
                JOnASHandlerResolver resolver = new JOnASHandlerResolver(service.getClass(), tccl);
                resolver.setHandlerChainBuilder((HandlerChainBuilder)new DescriptorHandlerChainBuilder(handlerChainsElement));
                service.setHandlerResolver((HandlerResolver)resolver);
            }
        }
    }
}

