/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.lifecycle;

import com.sun.faces.lifecycle.Phase;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.RequestStateManager;
import com.sun.faces.util.TypedCollections;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseId;

public class RenderResponsePhase
extends Phase {
    private static Logger LOGGER = FacesLogger.LIFECYCLE.getLogger();

    public void execute(FacesContext facesContext) throws FacesException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Entering RenderResponsePhase");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("About to render view " + facesContext.getViewRoot().getViewId());
        }
        try {
            Set<String> clientIds;
            Iterator clientIdIter;
            if (LOGGER.isLoggable(Level.INFO) && (clientIdIter = facesContext.getClientIdsWithMessages()).hasNext()) {
                HashSet clientIds2 = new HashSet();
                while (clientIdIter.hasNext()) {
                    clientIds2.add(clientIdIter.next());
                }
                RequestStateManager.set(facesContext, "com.sun.faces.clientIdMessagesNotDisplayed", clientIds2);
            }
            facesContext.getApplication().getViewHandler().renderView(facesContext, facesContext.getViewRoot());
            if (LOGGER.isLoggable(Level.INFO) && RequestStateManager.containsKey(facesContext, "com.sun.faces.clientIdMessagesNotDisplayed") && !(clientIds = TypedCollections.dynamicallyCastSet((Set)RequestStateManager.remove(facesContext, "com.sun.faces.clientIdMessagesNotDisplayed"), String.class)).isEmpty()) {
                StringBuilder builder = new StringBuilder();
                for (String clientId : clientIds) {
                    Iterator messages = facesContext.getMessages(clientId);
                    while (messages.hasNext()) {
                        FacesMessage message = (FacesMessage)messages.next();
                        builder.append("\n");
                        builder.append("sourceId=").append(clientId);
                        builder.append("[severity=(").append(message.getSeverity());
                        builder.append("), summary=(").append(message.getSummary());
                        builder.append("), detail=(").append(message.getDetail()).append(")]");
                    }
                }
                LOGGER.log(Level.INFO, "jsf.non_displayed_message", builder.toString());
            }
        }
        catch (IOException e) {
            throw new FacesException(e.getMessage(), (Throwable)e);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Exiting RenderResponsePhase");
        }
    }

    public PhaseId getId() {
        return PhaseId.RENDER_RESPONSE;
    }
}

