/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.handlers.dependency;

import java.util.Comparator;
import java.util.List;
import org.apache.felix.ipojo.handlers.dependency.Dependency;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;

public class DependencyDescription {
    private Dependency m_dependency;

    public DependencyDescription(Dependency dep) {
        this.m_dependency = dep;
    }

    public boolean isMultiple() {
        return this.m_dependency.isAggregate();
    }

    public boolean isOptional() {
        return this.m_dependency.isOptional();
    }

    public String getFilter() {
        return this.m_dependency.getFilter();
    }

    public String getInterface() {
        return this.m_dependency.getSpecification().getName();
    }

    public int getState() {
        return this.m_dependency.getState();
    }

    public String getId() {
        return this.m_dependency.getId();
    }

    public boolean supportsNullable() {
        return this.m_dependency.supportsNullable();
    }

    public String getDefaultImplementation() {
        return this.m_dependency.getDefaultImplementation();
    }

    public int getPolicy() {
        return this.m_dependency.getBindingPolicy();
    }

    public String getComparator() {
        return this.m_dependency.getComparator();
    }

    public boolean isFrozen() {
        return this.m_dependency.isFrozen();
    }

    public List getServiceReferences() {
        return this.m_dependency.getServiceReferencesAsList();
    }

    public ServiceReference getServiceReference() {
        List list = this.getServiceReferences();
        if (list == null) {
            return null;
        }
        return (ServiceReference)list.get(0);
    }

    public List getUsedServices() {
        return this.m_dependency.getUsedServiceReferences();
    }

    public void setComparator(Comparator cmp) {
        this.m_dependency.setComparator(cmp);
    }

    public void setFilter(Filter filter) {
        this.m_dependency.setFilter(filter);
    }

    public void setAggregate(boolean isAgg) {
        this.m_dependency.setAggregate(isAgg);
    }

    public void setOptional(boolean isOpt) {
        this.m_dependency.setOptionality(isOpt);
    }

    public String getSpecification() {
        return this.m_dependency.getSpecification().getName();
    }
}

