/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.parser;

import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.metadata.Element;
import org.apache.felix.ipojo.parser.FieldMetadata;
import org.apache.felix.ipojo.parser.MethodMetadata;

public class PojoMetadata {
    private String[] m_interfaces = new String[0];
    private FieldMetadata[] m_fields = new FieldMetadata[0];
    private MethodMetadata[] m_methods = new MethodMetadata[0];
    private String m_super;

    public PojoMetadata(Element metadata) throws ConfigurationException {
        Element[] elems = metadata.getElements("manipulation", "");
        if (elems == null) {
            throw new ConfigurationException("The component " + metadata.getAttribute("classname") + " has no manipulation metadata");
        }
        Element manip = elems[0];
        this.m_super = manip.getAttribute("super");
        Element[] fields = manip.getElements("field");
        for (int i = 0; fields != null && i < fields.length; ++i) {
            FieldMetadata field = new FieldMetadata(fields[i]);
            this.addField(field);
        }
        Element[] methods = manip.getElements("method");
        for (int i = 0; methods != null && i < methods.length; ++i) {
            MethodMetadata method = new MethodMetadata(methods[i]);
            this.addMethod(method);
        }
        Element[] itfs = manip.getElements("interface");
        for (int i = 0; itfs != null && i < itfs.length; ++i) {
            this.addInterface(itfs[i].getAttribute("name"));
        }
    }

    public MethodMetadata[] getMethods() {
        return this.m_methods;
    }

    public FieldMetadata[] getFields() {
        return this.m_fields;
    }

    public String[] getInterfaces() {
        return this.m_interfaces;
    }

    public FieldMetadata getField(String name) {
        for (int i = 0; i < this.m_fields.length; ++i) {
            if (!this.m_fields[i].getFieldName().equalsIgnoreCase(name)) continue;
            return this.m_fields[i];
        }
        return null;
    }

    public FieldMetadata getField(String name, String type) {
        for (int i = 0; i < this.m_fields.length; ++i) {
            if (!this.m_fields[i].getFieldName().equalsIgnoreCase(name) || !this.m_fields[i].getFieldType().equalsIgnoreCase(type)) continue;
            return this.m_fields[i];
        }
        return null;
    }

    public boolean isInterfaceImplemented(String itf) {
        for (int i = 0; i < this.m_interfaces.length; ++i) {
            if (!this.m_interfaces[i].equals(itf)) continue;
            return true;
        }
        return false;
    }

    public MethodMetadata getMethod(String name) {
        for (int i = 0; i < this.m_methods.length; ++i) {
            if (!this.m_methods[i].getMethodName().equalsIgnoreCase(name)) continue;
            return this.m_methods[i];
        }
        return null;
    }

    public MethodMetadata[] getMethods(String name) {
        MethodMetadata[] mms = new MethodMetadata[]{};
        for (int i = 0; i < this.m_methods.length; ++i) {
            if (!this.m_methods[i].getMethodName().equalsIgnoreCase(name)) continue;
            if (mms.length > 0) {
                MethodMetadata[] newInstances = new MethodMetadata[mms.length + 1];
                System.arraycopy(mms, 0, newInstances, 0, mms.length);
                newInstances[mms.length] = this.m_methods[i];
                mms = newInstances;
                continue;
            }
            mms = new MethodMetadata[]{this.m_methods[i]};
        }
        return mms;
    }

    public MethodMetadata getMethod(String name, String[] types) {
        for (int i = 0; i < this.m_methods.length; ++i) {
            int argIndex;
            if (!this.m_methods[i].getMethodName().equalsIgnoreCase(name) || this.m_methods[i].getMethodArguments().length != types.length) continue;
            for (argIndex = 0; argIndex < types.length && types[argIndex].equals(this.m_methods[i].getMethodArguments()[argIndex]); ++argIndex) {
            }
            if (argIndex != types.length) continue;
            return this.m_methods[i];
        }
        return null;
    }

    private void addMethod(MethodMetadata method) {
        if (this.m_methods.length > 0) {
            MethodMetadata[] newInstances = new MethodMetadata[this.m_methods.length + 1];
            System.arraycopy(this.m_methods, 0, newInstances, 0, this.m_methods.length);
            newInstances[this.m_methods.length] = method;
            this.m_methods = newInstances;
        } else {
            this.m_methods = new MethodMetadata[]{method};
        }
    }

    private void addField(FieldMetadata field) {
        if (this.m_fields.length > 0) {
            FieldMetadata[] newInstances = new FieldMetadata[this.m_fields.length + 1];
            System.arraycopy(this.m_fields, 0, newInstances, 0, this.m_fields.length);
            newInstances[this.m_fields.length] = field;
            this.m_fields = newInstances;
        } else {
            this.m_fields = new FieldMetadata[]{field};
        }
    }

    private void addInterface(String itf) {
        if (this.m_interfaces.length > 0) {
            String[] newInstances = new String[this.m_interfaces.length + 1];
            System.arraycopy(this.m_interfaces, 0, newInstances, 0, this.m_interfaces.length);
            newInstances[this.m_interfaces.length] = itf;
            this.m_interfaces = newInstances;
        } else {
            this.m_interfaces = new String[]{itf};
        }
    }

    public String getSuperClass() {
        return this.m_super;
    }
}

