/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.hsqldb.util.RCData;
import org.hsqldb.util.SqlFile;
import org.hsqldb.util.SqlToolError;

public class SqlTool {
    private static final String DEFAULT_RCFILE = System.getProperty("user.home") + "/sqltool.rc";
    private static Connection conn;
    private static boolean noexit;
    private static String revnum;
    private static String CMDLINE_ID;
    private static final String SYNTAX_MESSAGE;
    private static BadCmdline bcl;
    static /* synthetic */ Class class$org$hsqldb$util$SqlTool;

    private static void exitMain(int n) throws SqlToolException {
        SqlTool.exitMain(n, null);
    }

    private static void exitMain(int n, String string) throws SqlToolException {
        if (noexit) {
            if (n == 0) {
                return;
            }
            if (string == null) {
                throw new SqlToolException();
            }
            throw new SqlToolException(string);
        }
        if (string != null) {
            (n == 0 ? System.out : System.err).println(string);
        }
        System.exit(n);
    }

    private static String promptForPassword(String string) throws SqlToolException {
        String string2 = null;
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            System.out.print(string + "'s password: ");
            string2 = bufferedReader.readLine();
            string2 = string2 == null ? "" : string2.trim();
        }
        catch (IOException iOException) {
            SqlTool.exitMain(30, "Error while reading password from console: " + iOException.getMessage());
        }
        return string2;
    }

    private static void varParser(String string, Map map, boolean bl) throws SqlToolException {
        if (map == null || string == null) {
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            int n = string2.indexOf(61);
            if (n < 1) {
                throw new SqlToolException("Var settings not of format NAME=var[,...]");
            }
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            if (string3.length() < 1 || string4.length() < 1) {
                throw new SqlToolException("Var settings not of format NAME=var[,...]");
            }
            if (bl) {
                string3 = string3.toLowerCase();
            }
            map.put(string3, string4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws SqlToolException {
        int n;
        int n2;
        File[] fileArray;
        String string = null;
        File file = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl = false;
        File[] fileArray2 = null;
        int n3 = -1;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        Boolean bl7 = null;
        Boolean bl8 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        HashMap hashMap = null;
        noexit = System.getProperty("sqltool.noexit") != null;
        try {
            while (n3 + 1 < stringArray.length && stringArray[n3 + 1].startsWith("--") && stringArray[++n3].length() != 2) {
                String string13 = stringArray[n3].substring(2).toLowerCase();
                if (string13.equals("help")) {
                    SqlTool.exitMain(0, SYNTAX_MESSAGE);
                    return;
                }
                if (string13.equals("abortonerr")) {
                    if (bl7 != null) {
                        SqlTool.exitMain(0, "Switches '--abortOnErr' and '--continueOnErr' are mutually exclusive");
                        return;
                    }
                    bl7 = Boolean.FALSE;
                    continue;
                }
                if (string13.equals("continueonerr")) {
                    if (bl7 != null) {
                        SqlTool.exitMain(0, "Switches '--abortOnErr' and '--continueOnErr' are mutually exclusive");
                        return;
                    }
                    bl7 = Boolean.TRUE;
                    continue;
                }
                if (string13.equals("list")) {
                    bl2 = true;
                    continue;
                }
                if (string13.equals("rcfile")) {
                    if (++n3 == stringArray.length) {
                        throw bcl;
                    }
                    string = stringArray[n3];
                    continue;
                }
                if (string13.equals("setvar")) {
                    if (++n3 == stringArray.length) {
                        throw bcl;
                    }
                    string5 = stringArray[n3];
                    continue;
                }
                if (string13.equals("sql")) {
                    bl4 = true;
                    if (++n3 == stringArray.length) {
                        throw bcl;
                    }
                    string2 = stringArray[n3];
                    if (string2.charAt(string2.length() - 1) == ';') continue;
                    string2 = string2 + ";";
                    continue;
                }
                if (string13.equals("debug")) {
                    bl = true;
                    continue;
                }
                if (string13.equals("noautofile")) {
                    bl5 = true;
                    continue;
                }
                if (string13.equals("autocommit")) {
                    bl6 = true;
                    continue;
                }
                if (string13.equals("stdinput")) {
                    bl4 = false;
                    bl8 = Boolean.TRUE;
                    continue;
                }
                if (string13.equals("noinput")) {
                    bl4 = true;
                    bl8 = Boolean.FALSE;
                    continue;
                }
                if (string13.equals("driver")) {
                    if (++n3 == stringArray.length) {
                        throw bcl;
                    }
                    string3 = stringArray[n3];
                    continue;
                }
                if (string13.equals("inlinerc")) {
                    if (++n3 == stringArray.length) {
                        throw bcl;
                    }
                    string6 = stringArray[n3];
                    continue;
                }
                throw bcl;
            }
            if (!bl2 && string6 == null) {
                if (++n3 == stringArray.length) {
                    throw bcl;
                }
                string4 = stringArray[n3];
            }
            int n4 = 0;
            if (string2 != null) {
                try {
                    file = File.createTempFile("sqltool-", ".sql");
                    fileArray = new FileWriter(file);
                    fileArray.write("/* " + new Date() + ".  " + (class$org$hsqldb$util$SqlTool == null ? (class$org$hsqldb$util$SqlTool = SqlTool.class$("org.hsqldb.util.SqlTool")) : class$org$hsqldb$util$SqlTool).getName() + " command-line SQL. */\n\n");
                    fileArray.write(string2 + '\n');
                    fileArray.flush();
                    fileArray.close();
                }
                catch (IOException iOException) {
                    SqlTool.exitMain(4, "Failed to write given sql to temp file: " + iOException);
                    return;
                }
            }
            if (bl8 != null) {
                bl4 = bl8 == false;
            }
            boolean bl9 = bl3 = !bl4 && stringArray.length <= n3 + 1;
            if (stringArray.length == n3 + 2 && stringArray[n3 + 1].equals("-")) {
                if (bl8 == null) {
                    bl4 = false;
                }
            } else if (stringArray.length > n3 + 1) {
                fileArray2 = new File[stringArray.length - n3 - 1 + (bl8 == null || bl8 == false ? 0 : 1)];
                if (bl) {
                    System.err.println("scriptFiles has " + fileArray2.length + " elements");
                }
                while (n3 + 1 < stringArray.length) {
                    fileArray2[n4++] = new File(stringArray[++n3]);
                }
                if (bl8 != null && bl8.booleanValue()) {
                    fileArray2[n4++] = null;
                    bl4 = true;
                }
            }
        }
        catch (BadCmdline badCmdline) {
            SqlTool.exitMain(2, SYNTAX_MESSAGE);
            return;
        }
        RCData rCData = null;
        if (string6 != null) {
            hashMap = new HashMap();
            try {
                SqlTool.varParser(string6, hashMap, true);
            }
            catch (SqlToolException sqlToolException) {
                SqlTool.exitMain(24, sqlToolException.getMessage());
            }
            try {
                string7 = (String)hashMap.get("url");
                string8 = (String)hashMap.get("user");
                string10 = (String)hashMap.get("driver");
                string11 = (String)hashMap.get("charset");
                string12 = (String)hashMap.get("truststore");
                string9 = SqlTool.promptForPassword(string8);
                rCData = new RCData(CMDLINE_ID, string7, string8, string9, string10, string11, string12);
            }
            catch (SqlToolException sqlToolException) {
                throw sqlToolException;
            }
            catch (Exception exception) {
                SqlTool.exitMain(1, "Invalid inline RC file specified: " + exception.getMessage());
                return;
            }
        }
        try {
            rCData = new RCData(new File(string == null ? DEFAULT_RCFILE : string), string4);
        }
        catch (Exception exception) {
            SqlTool.exitMain(1, "Failed to retrieve connection info for database '" + string4 + "': " + exception.getMessage());
            return;
        }
        if (bl2) {
            SqlTool.exitMain(0);
            return;
        }
        if (bl) {
            rCData.report();
        }
        try {
            conn = rCData.getConnection(string3, System.getProperty("sqlfile.charset"), System.getProperty("javax.net.ssl.trustStore"));
            conn.setAutoCommit(bl6);
            fileArray = null;
            if (bl3 && (fileArray = conn.getMetaData()) != null) {
                System.out.println("JDBC Connection established to a " + fileArray.getDatabaseProductName() + " v. " + fileArray.getDatabaseProductVersion() + " database as '" + fileArray.getUserName() + "'.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            SqlTool.exitMain(10, "Failed to get a connection to " + rCData.url + " as " + rCData.username + ".  " + exception.getMessage());
            return;
        }
        fileArray = new File[]{};
        File[] fileArray3 = new File[]{null};
        File file2 = null;
        if (!(!bl3 || bl5 || (file2 = new File(System.getProperty("user.home") + "/auto.sql")).isFile() && file2.canRead())) {
            file2 = null;
        }
        if (fileArray2 == null) {
            fileArray2 = bl4 ? fileArray : fileArray3;
        }
        int n5 = fileArray2.length;
        if (file != null) {
            ++n5;
        }
        if (file2 != null) {
            ++n5;
        }
        SqlFile[] sqlFileArray = new SqlFile[n5];
        HashMap hashMap2 = new HashMap();
        if (string5 != null) {
            SqlTool.varParser(string5, hashMap2, false);
        }
        int n6 = -1;
        try {
            n2 = 0;
            if (file2 != null) {
                sqlFileArray[n2++] = new SqlFile(file2, false, hashMap2);
            }
            if (file != null) {
                sqlFileArray[n2++] = new SqlFile(file, false, hashMap2);
            }
            for (n = 0; n < fileArray2.length; ++n) {
                if (n6 < 0 && bl3) {
                    n6 = n2;
                }
                sqlFileArray[n2++] = new SqlFile(fileArray2[n], bl3, hashMap2);
            }
        }
        catch (IOException iOException) {
            try {
                conn.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            SqlTool.exitMain(2, iOException.getMessage());
            return;
        }
        n2 = 0;
        try {
            for (n = 0; n < sqlFileArray.length; ++n) {
                if (n == n6) {
                    System.out.print("SqlTool v. " + revnum + ".                        ");
                }
                sqlFileArray[n].execute(conn, bl7);
            }
        }
        catch (IOException iOException) {
            System.err.println("Failed to execute SQL:  " + iOException.getMessage());
            n2 = 3;
        }
        catch (SqlToolError sqlToolError) {
            n2 = 2;
        }
        catch (SQLException sQLException) {
            n2 = 1;
        }
        finally {
            try {
                conn.close();
            }
            catch (Exception exception) {}
        }
        if (file != null && !file.delete()) {
            System.err.println("Error occurred while trying to remove temp file '" + file + "'");
        }
        SqlTool.exitMain(n2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        revnum = null;
        CMDLINE_ID = "cmdline";
        revnum = "$Revision: 1.55 $".substring("$Revision: ".length(), "$Revision: 1.55 $".length() - 2);
        SYNTAX_MESSAGE = "Usage: java [-Dsqlfile.X=Y...] org.hsqldb.util.SqlTool \\\n    [--optname [optval...]] urlid [file1.sql...]\nwhere arguments are:\n    --help                   Displays this message\n    --list                   List urlids in the rc file\n    --noInput                Do not read stdin (default if sql file given\n                             or --sql switch used).\n    --stdInput               Read stdin IN ADDITION to sql files/--sql input\n    --inlineRc URL=val1,USER=val2[,DRIVER=val3][,CHARSET=val4][,TRUST=val5]\n                             Inline RC file variables\n    --debug                  Print Debug info to stderr\n    --noAutoFile             Do not execute auto.sql from home dir\n    --autoCommit             Auto-commit JDBC DML commands\n    --sql \"SQL; Statements\"  Execute given SQL instead of stdin (before\n                             SQL files if any are specified) where \"SQL\"\n                             consists of SQL command(s).  See the Guide.\n    --rcFile /file/path.rc   Connect Info File [$HOME/sqltool.rc]\n    --abortOnErr             Abort on Error (overrides defaults)\n    --continueOnErr          Continue on Error (overrides defaults)\n    --setVar NAME1=val1[,NAME2=val2...]   PL variables\n    --driver a.b.c.Driver    JDBC driver class [org.hsqldb.jdbcDriver]\n    urlid                    ID of url/userame/password in rcfile\n    file1.sql...             SQL files to be executed [stdin]\n                             (Use '-' for non-interactively stdin).\nSee the SqlTool Manual for the supported sqltool.* System Properties.\nSqlTool v. " + revnum + ".";
        bcl = new BadCmdline();
    }

    public static class SqlToolException
    extends Exception {
        public SqlToolException() {
        }

        public SqlToolException(String string) {
            super(string);
        }
    }

    private static class BadCmdline
    extends Exception {
        private BadCmdline() {
        }
    }
}

