/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.env;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.AccessRule;

public class AccessRuleSet {
    private AccessRule[] accessRules;
    public String messageTemplate;

    public AccessRuleSet(AccessRule[] accessRules) {
        this.accessRules = accessRules;
    }

    public AccessRuleSet(AccessRule[] accessRules, String messageTemplate) {
        this.accessRules = accessRules;
        this.messageTemplate = messageTemplate;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AccessRuleSet)) {
            return false;
        }
        AccessRuleSet otherRuleSet = (AccessRuleSet)object;
        if (!this.messageTemplate.equals(otherRuleSet.messageTemplate)) {
            return false;
        }
        int rulesLength = this.accessRules.length;
        if (rulesLength != otherRuleSet.accessRules.length) {
            return false;
        }
        int i = 0;
        while (i < rulesLength) {
            if (!this.accessRules[i].equals(otherRuleSet.accessRules[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public AccessRule[] getAccessRules() {
        return this.accessRules;
    }

    public AccessRestriction getViolatedRestriction(char[] targetTypeFilePath) {
        int i = 0;
        int length = this.accessRules.length;
        while (i < length) {
            AccessRule accessRule = this.accessRules[i];
            if (CharOperation.pathMatch(accessRule.pattern, targetTypeFilePath, true, '/')) {
                switch (accessRule.problemId) {
                    case 0x1000118: 
                    case 0x1000133: {
                        return new AccessRestriction(accessRule, this.messageTemplate);
                    }
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean wrap) {
        StringBuffer buffer = new StringBuffer(200);
        buffer.append("AccessRuleSet {");
        if (wrap) {
            buffer.append('\n');
        }
        int i = 0;
        int length = this.accessRules.length;
        while (i < length) {
            if (wrap) {
                buffer.append('\t');
            }
            AccessRule accessRule = this.accessRules[i];
            buffer.append(accessRule);
            if (wrap) {
                buffer.append('\n');
            } else if (i < length - 1) {
                buffer.append(", ");
            }
            ++i;
        }
        buffer.append("} [template:\"").append(this.messageTemplate).append("\"]");
        return buffer.toString();
    }
}

