/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.dbm.internal;

import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.dbm.DataBaseService;
import org.ow2.jonas.dbm.internal.DBMConstants;
import org.ow2.jonas.dbm.internal.JOnASDataBaseManagerServiceMBean;
import org.ow2.jonas.dbm.internal.cm.ConnectionManager;
import org.ow2.jonas.dbm.internal.mbean.JDBCDataSource;
import org.ow2.jonas.dbm.internal.mbean.JDBCDriver;
import org.ow2.jonas.dbm.internal.mbean.JDBCResource;
import org.ow2.jonas.jmx.JmxService;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.management.javaee.J2eeObjectName;
import org.ow2.jonas.lib.service.AbsServiceImpl;
import org.ow2.jonas.lib.util.JModule;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.registry.RegistryService;
import org.ow2.jonas.service.ServiceException;
import org.ow2.jonas.tm.TransactionService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JOnASDataBaseManagerService
extends AbsServiceImpl
implements DataBaseService,
JOnASDataBaseManagerServiceMBean,
DBMConstants,
Pojo {
    private InstanceManager __IM;
    private static Logger logger = Log.getLogger((String)"org.ow2.jonas.dbm");
    private boolean __FcmList;
    private List<ConnectionManager> cmList;
    private boolean __FboundDatasources;
    private Map<String, String> boundDatasources;
    private boolean __FdataSourceNames;
    private List<String> dataSourceNames;
    private boolean __FjmxService;
    private JmxService jmxService;
    private boolean __FtxService;
    private TransactionService txService;
    private boolean __Fictx;
    private Context ictx;
    private boolean __FregistryService;
    private RegistryService registryService;
    public static final String JDBC_RESOURCE_NAME = "JDBCResource";
    private boolean __FjdbcResourceMBean;
    private JDBCResource jdbcResourceMBean;
    private boolean __MsetDatasources$java_lang_String;
    private boolean __MdoStart;
    private boolean __MdoStop;
    private boolean __McreateDataSource$java_lang_String$java_util_Properties;
    private boolean __MunbindDataSources;
    private boolean __MgetConnectionManager$java_lang_String;
    private boolean __MgetDSList;
    private boolean __MgetDataSourcePropertiesFiles;
    private boolean __MgetCurrentNumberOfDataSource;
    private boolean __MgetTotalCurrentNumberOfJDBCConnectionOpen;
    private boolean __MisLoadedDataSource$java_lang_String;
    private boolean __MunloadDataSource$java_lang_String;
    private boolean __MgetDataSourcePropertiesFile$java_lang_String;
    private boolean __MloadDataSource$java_lang_String$java_util_Properties$java_lang_Boolean;
    private boolean __MgetDatasourceName$java_lang_String;
    private boolean __MregisterDbmServiceMBean$java_lang_Object$java_lang_String;
    private boolean __MunregisterDbmServiceMBean$java_lang_String;
    private boolean __MregisterJdbcResourceMBean$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MregisterJdbcDataSourceAndDriverMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_dbm_internal_cm_ConnectionManager;
    private boolean __MunregisterJdbcDataSourceAndDriverMBean$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MunregisterAllDataSourceAndDriverMBeans;
    private boolean __MunregisterJdbcResourceMBean$java_lang_String$java_lang_String$java_lang_String;
    private boolean __MsetTransactionService$org_ow2_jonas_tm_TransactionService;
    private boolean __MsetJmxService$org_ow2_jonas_jmx_JmxService;
    private boolean __MsetRegistryService$org_ow2_jonas_registry_RegistryService;
    private boolean __MgetRegistryService;

    List __getcmList() {
        if (!this.__FcmList) {
            return this.cmList;
        }
        return (List)this.__IM.onGet((Object)this, "cmList");
    }

    void __setcmList(List list) {
        if (!this.__FcmList) {
            this.cmList = list;
            return;
        }
        this.__IM.onSet((Object)this, "cmList", (Object)list);
    }

    Map __getboundDatasources() {
        if (!this.__FboundDatasources) {
            return this.boundDatasources;
        }
        return (Map)this.__IM.onGet((Object)this, "boundDatasources");
    }

    void __setboundDatasources(Map map) {
        if (!this.__FboundDatasources) {
            this.boundDatasources = map;
            return;
        }
        this.__IM.onSet((Object)this, "boundDatasources", (Object)map);
    }

    List __getdataSourceNames() {
        if (!this.__FdataSourceNames) {
            return this.dataSourceNames;
        }
        return (List)this.__IM.onGet((Object)this, "dataSourceNames");
    }

    void __setdataSourceNames(List list) {
        if (!this.__FdataSourceNames) {
            this.dataSourceNames = list;
            return;
        }
        this.__IM.onSet((Object)this, "dataSourceNames", (Object)list);
    }

    JmxService __getjmxService() {
        if (!this.__FjmxService) {
            return this.jmxService;
        }
        return (JmxService)this.__IM.onGet((Object)this, "jmxService");
    }

    void __setjmxService(JmxService jmxService) {
        if (!this.__FjmxService) {
            this.jmxService = jmxService;
            return;
        }
        this.__IM.onSet((Object)this, "jmxService", (Object)jmxService);
    }

    TransactionService __gettxService() {
        if (!this.__FtxService) {
            return this.txService;
        }
        return (TransactionService)this.__IM.onGet((Object)this, "txService");
    }

    void __settxService(TransactionService transactionService) {
        if (!this.__FtxService) {
            this.txService = transactionService;
            return;
        }
        this.__IM.onSet((Object)this, "txService", (Object)transactionService);
    }

    Context __getictx() {
        if (!this.__Fictx) {
            return this.ictx;
        }
        return (Context)this.__IM.onGet((Object)this, "ictx");
    }

    void __setictx(Context context) {
        if (!this.__Fictx) {
            this.ictx = context;
            return;
        }
        this.__IM.onSet((Object)this, "ictx", (Object)context);
    }

    RegistryService __getregistryService() {
        if (!this.__FregistryService) {
            return this.registryService;
        }
        return (RegistryService)this.__IM.onGet((Object)this, "registryService");
    }

    void __setregistryService(RegistryService registryService) {
        if (!this.__FregistryService) {
            this.registryService = registryService;
            return;
        }
        this.__IM.onSet((Object)this, "registryService", (Object)registryService);
    }

    JDBCResource __getjdbcResourceMBean() {
        if (!this.__FjdbcResourceMBean) {
            return this.jdbcResourceMBean;
        }
        return (JDBCResource)((Object)this.__IM.onGet((Object)this, "jdbcResourceMBean"));
    }

    void __setjdbcResourceMBean(JDBCResource jDBCResource) {
        if (!this.__FjdbcResourceMBean) {
            this.jdbcResourceMBean = jDBCResource;
            return;
        }
        this.__IM.onSet((Object)this, "jdbcResourceMBean", (Object)jDBCResource);
    }

    public JOnASDataBaseManagerService() {
        this(null);
    }

    private JOnASDataBaseManagerService(InstanceManager _manager) {
        this._setInstanceManager(_manager);
        this.__setcmList(new Vector());
        this.__setboundDatasources(new Hashtable());
        this.__setdataSourceNames(new Vector());
        this.__setjmxService(null);
        this.__settxService(null);
        this.__setictx(null);
        this.__setjdbcResourceMBean(null);
    }

    public void setDatasources(String string) {
        if (!this.__MsetDatasources$java_lang_String) {
            this.__setDatasources(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setDatasources$java_lang_String", new Object[]{string});
            this.__setDatasources(string);
            this.__IM.onExit((Object)this, "setDatasources$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setDatasources$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __setDatasources(String datasources) {
        this.__setdataSourceNames(JOnASDataBaseManagerService.convertToList((String)datasources));
    }

    public void doStart() throws ServiceException {
        if (!this.__MdoStart) {
            this.__doStart();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStart", new Object[0]);
            this.__doStart();
            this.__IM.onExit((Object)this, "doStart", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStart", throwable);
            throw throwable;
        }
    }

    private void __doStart() throws ServiceException {
        logger.log(BasicLevel.DEBUG, (Object)"Starting DataBase service");
        IExecution<InitialContext> ictxGetter = new IExecution<InitialContext>(){

            public InitialContext execute() throws Exception {
                return JOnASDataBaseManagerService.this.getRegistryService().getRegistryContext();
            }
        };
        ExecutionResult ictxResult = RunnableHelper.execute((ClassLoader)this.getClass().getClassLoader(), (IExecution)ictxGetter);
        if (ictxResult.hasException()) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot create initial context when DataBase service initializing");
            throw new ServiceException("Cannot create initial context when DataBase service initializing", (Throwable)ictxResult.getException());
        }
        this.__setictx((Context)ictxResult.getResult());
        this.__getjmxService().loadDescriptors(this.getClass().getPackage().getName(), this.getClass().getClassLoader());
        this.registerDbmServiceMBean(this, this.getDomainName());
        this.__setjdbcResourceMBean(this.registerJdbcResourceMBean(this.getDomainName(), this.getJonasServerName(), JDBC_RESOURCE_NAME));
        String dsName = null;
        for (int i = 0; i < this.__getdataSourceNames().size(); ++i) {
            dsName = (String)this.__getdataSourceNames().get(i);
            try {
                JProp prop = JProp.getInstance((String)dsName);
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("Creating Datasource " + dsName));
                }
                this.createDataSource(dsName, prop.getConfigFileEnv());
                continue;
            }
            catch (Exception e) {
                JProp.removeInstance((String)dsName);
                logger.log(BasicLevel.ERROR, (Object)("JOnAS: Cannot create datasource: '" + dsName + "'"), (Throwable)e);
                logger.log(BasicLevel.ERROR, (Object)("Please check if " + dsName + ".properties is available"));
            }
        }
        logger.log(BasicLevel.INFO, (Object)"DBM Service started");
    }

    public void doStop() throws ServiceException {
        if (!this.__MdoStop) {
            this.__doStop();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "doStop", new Object[0]);
            this.__doStop();
            this.__IM.onExit((Object)this, "doStop", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "doStop", throwable);
            throw throwable;
        }
    }

    private void __doStop() throws ServiceException {
        try {
            this.unbindDataSources();
        }
        catch (NamingException e) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot unbind datasources");
            throw new ServiceException("Cannot unbind datasources ", (Throwable)e);
        }
        if (this.__getjmxService() != null) {
            this.unregisterDbmServiceMBean(this.getDomainName());
            this.unregisterJdbcResourceMBean(this.getDomainName(), this.getJonasServerName(), JDBC_RESOURCE_NAME);
        }
        logger.log(BasicLevel.INFO, (Object)"DBM Service stopped");
    }

    public void createDataSource(String string, Properties properties) throws Exception {
        if (!this.__McreateDataSource$java_lang_String$java_util_Properties) {
            this.__createDataSource(string, properties);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "createDataSource$java_lang_String$java_util_Properties", new Object[]{string, properties});
            this.__createDataSource(string, properties);
            this.__IM.onExit((Object)this, "createDataSource$java_lang_String$java_util_Properties", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createDataSource$java_lang_String$java_util_Properties", throwable);
            throw throwable;
        }
    }

    private void __createDataSource(String datasourceName, Properties dsd) throws Exception {
        String dsName = dsd.getProperty("datasource.name");
        if (dsName == null) {
            logger.log(BasicLevel.ERROR, (Object)"");
            throw new ServiceException("Cannot create datasource as JNDI name not provided");
        }
        dsName = dsName.trim();
        String className = dsd.getProperty("datasource.classname", "no class name").trim();
        String url = dsd.getProperty("datasource.url", "no url").trim();
        String description = dsd.getProperty("datasource.description", "no desc").trim();
        String user = dsd.getProperty("datasource.username", "").trim();
        String password = dsd.getProperty("datasource.password", "").trim();
        String connCheckLevel = dsd.getProperty("jdbc.connchecklevel", "1").trim();
        String connMaxAge = dsd.getProperty("jdbc.connmaxage", "1440").trim();
        String maxOpenTime = dsd.getProperty("jdbc.maxopentime", "1440").trim();
        String minconpool = dsd.getProperty("jdbc.minconpool", "0").trim();
        String maxconpool = dsd.getProperty("jdbc.maxconpool", "-1").trim();
        String maxwaittime = dsd.getProperty("jdbc.maxwaittime", "10").trim();
        String maxwaiters = dsd.getProperty("jdbc.maxwaiters", "1000").trim();
        String samplingperiod = dsd.getProperty("jdbc.samplingperiod", "30").trim();
        String adjustperiod = dsd.getProperty("jdbc.adjustperiod", "30").trim();
        String defaultStatement = dsd.getProperty("jdbc.connteststmt", "SELECT 1").trim();
        String pstmtmax = dsd.getProperty("jdbc.pstmtmax", "12").trim();
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("create JOnAS ConnectionManager corresponding to data source " + datasourceName + " with JNDI name " + dsName));
        }
        ConnectionManager ds = new ConnectionManager(this.__gettxService());
        ds.setDatasourceName(datasourceName);
        ds.setDSName(dsName);
        ds.setUrl(url);
        ds.setClassName(className);
        ds.setUserName(user);
        ds.setPassword(password);
        ds.setTransactionIsolation(dsd.getProperty("datasource.isolationlevel", "").trim());
        ds.setMapperName(dsd.getProperty("datasource.mapper", "rdb").trim());
        ds.setDataSourceDescription(description);
        ds.poolConfigure(connCheckLevel, connMaxAge, maxOpenTime, defaultStatement, pstmtmax, minconpool, maxconpool, maxwaittime, maxwaiters, samplingperiod, adjustperiod);
        this.__getcmList().add(ds);
        this.__getictx().rebind(dsName, (Object)ds);
        this.__getboundDatasources().put(dsName, datasourceName);
        logger.log(BasicLevel.INFO, (Object)("Mapping ConnectionManager " + url + " on " + dsName));
        String jdbcDataSourceName = datasourceName;
        String jdbcDriverName = "aJDBCDriver-" + jdbcDataSourceName;
        String jdbcDriverClassName = className;
        String jdbcDataSourceON = this.registerJdbcDataSourceAndDriverMBean(this.getDomainName(), this.getJonasServerName(), jdbcDataSourceName, jdbcDriverName, jdbcDriverClassName, ds);
        this.__getjdbcResourceMBean().addJdbcDataSource(jdbcDataSourceON);
    }

    public void unbindDataSources() throws NamingException {
        if (!this.__MunbindDataSources) {
            this.__unbindDataSources();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unbindDataSources", new Object[0]);
            this.__unbindDataSources();
            this.__IM.onExit((Object)this, "unbindDataSources", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unbindDataSources", throwable);
            throw throwable;
        }
    }

    private void __unbindDataSources() throws NamingException {
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            if (this.__getcmList().size() > 0) {
                String dsn = null;
                for (ConnectionManager cm : this.__getcmList()) {
                    cm.closeAllConnection();
                    dsn = cm.getDSName();
                    this.__getictx().unbind(dsn);
                    this.__getboundDatasources().remove(dsn);
                }
            }
        }
        catch (NamingException e) {
            logger.log(BasicLevel.ERROR, (Object)"cannot unbind DataSources", (Throwable)e);
            throw e;
        }
        if (this.__getjmxService() != null) {
            this.unregisterAllDataSourceAndDriverMBeans();
        }
    }

    public ConnectionManager getConnectionManager(String string) {
        ConnectionManager connectionManager;
        if (!this.__MgetConnectionManager$java_lang_String) {
            return this.__getConnectionManager(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getConnectionManager$java_lang_String", new Object[]{string});
            connectionManager = this.__getConnectionManager(string);
            this.__IM.onExit((Object)this, "getConnectionManager$java_lang_String", (Object)connectionManager);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getConnectionManager$java_lang_String", throwable);
            throw throwable;
        }
        return connectionManager;
    }

    private ConnectionManager __getConnectionManager(String dsname) {
        if (this.__getcmList().size() > 0) {
            for (ConnectionManager cm : this.__getcmList()) {
                if (!cm.getDSName().equals(dsname)) continue;
                return cm;
            }
        }
        return null;
    }

    public Collection<ConnectionManager> getDSList() {
        Collection<ConnectionManager> collection;
        if (!this.__MgetDSList) {
            return this.__getDSList();
        }
        try {
            this.__IM.onEntry((Object)this, "getDSList", new Object[0]);
            collection = this.__getDSList();
            this.__IM.onExit((Object)this, "getDSList", collection);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDSList", throwable);
            throw throwable;
        }
        return collection;
    }

    private Collection<ConnectionManager> __getDSList() {
        return this.__getcmList();
    }

    @Override
    public List getDataSourcePropertiesFiles() throws Exception {
        List list;
        if (!this.__MgetDataSourcePropertiesFiles) {
            return this.__getDataSourcePropertiesFiles();
        }
        try {
            this.__IM.onEntry((Object)this, "getDataSourcePropertiesFiles", new Object[0]);
            list = this.__getDataSourcePropertiesFiles();
            this.__IM.onExit((Object)this, "getDataSourcePropertiesFiles", (Object)list);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDataSourcePropertiesFiles", throwable);
            throw throwable;
        }
        return list;
    }

    private List __getDataSourcePropertiesFiles() throws Exception {
        return JModule.getDatasourcePropsInDir();
    }

    @Override
    public Integer getCurrentNumberOfDataSource() {
        Integer n;
        if (!this.__MgetCurrentNumberOfDataSource) {
            return this.__getCurrentNumberOfDataSource();
        }
        try {
            this.__IM.onEntry((Object)this, "getCurrentNumberOfDataSource", new Object[0]);
            n = this.__getCurrentNumberOfDataSource();
            this.__IM.onExit((Object)this, "getCurrentNumberOfDataSource", (Object)n);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getCurrentNumberOfDataSource", throwable);
            throw throwable;
        }
        return n;
    }

    private Integer __getCurrentNumberOfDataSource() {
        return new Integer(this.__getcmList().size());
    }

    @Override
    public Integer getTotalCurrentNumberOfJDBCConnectionOpen() {
        Integer n;
        if (!this.__MgetTotalCurrentNumberOfJDBCConnectionOpen) {
            return this.__getTotalCurrentNumberOfJDBCConnectionOpen();
        }
        try {
            this.__IM.onEntry((Object)this, "getTotalCurrentNumberOfJDBCConnectionOpen", new Object[0]);
            n = this.__getTotalCurrentNumberOfJDBCConnectionOpen();
            this.__IM.onExit((Object)this, "getTotalCurrentNumberOfJDBCConnectionOpen", (Object)n);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTotalCurrentNumberOfJDBCConnectionOpen", throwable);
            throw throwable;
        }
        return n;
    }

    private Integer __getTotalCurrentNumberOfJDBCConnectionOpen() {
        int result = 0;
        if (this.__getcmList().size() > 0) {
            for (ConnectionManager cm : this.__getcmList()) {
                result += cm.getPool().getCurrentOpened();
            }
        }
        return new Integer(result);
    }

    @Override
    public boolean isLoadedDataSource(String string) {
        boolean bl;
        if (!this.__MisLoadedDataSource$java_lang_String) {
            return this.__isLoadedDataSource(string);
        }
        try {
            this.__IM.onEntry((Object)this, "isLoadedDataSource$java_lang_String", new Object[]{string});
            bl = this.__isLoadedDataSource(string);
            this.__IM.onExit((Object)this, "isLoadedDataSource$java_lang_String", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isLoadedDataSource$java_lang_String", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __isLoadedDataSource(String dsName) {
        boolean result = false;
        if (this.__getcmList().size() > 0) {
            for (ConnectionManager cm : this.__getcmList()) {
                if (!cm.getDatasourceName().equals(dsName)) continue;
                return true;
            }
        }
        return result;
    }

    @Override
    public void unloadDataSource(String string) {
        if (!this.__MunloadDataSource$java_lang_String) {
            this.__unloadDataSource(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unloadDataSource$java_lang_String", new Object[]{string});
            this.__unloadDataSource(string);
            this.__IM.onExit((Object)this, "unloadDataSource$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unloadDataSource$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __unloadDataSource(String name) {
        logger.log(BasicLevel.DEBUG, (Object)"");
        try {
            Iterator i$;
            if (this.__getcmList().size() > 0 && (i$ = this.__getcmList().iterator()).hasNext()) {
                ConnectionManager cm = (ConnectionManager)i$.next();
                String dsName = cm.getDatasourceName();
                String jndiName = cm.getDSName();
                if (dsName.equals(name)) {
                    cm.closeAllConnection();
                    this.__getictx().unbind(jndiName);
                    this.__getcmList().remove(cm);
                    JProp.removeInstance((String)dsName);
                    String jdbcDataSourceOn = this.unregisterJdbcDataSourceAndDriverMBean(this.getDomainName(), this.getJonasServerName(), dsName);
                    this.__getjdbcResourceMBean().removeJdbcDataSource(jdbcDataSourceOn);
                }
                return;
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)"Cannot unload DataSources", (Throwable)e);
        }
    }

    @Override
    public Properties getDataSourcePropertiesFile(String string) throws Exception {
        Properties properties;
        if (!this.__MgetDataSourcePropertiesFile$java_lang_String) {
            return this.__getDataSourcePropertiesFile(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getDataSourcePropertiesFile$java_lang_String", new Object[]{string});
            properties = this.__getDataSourcePropertiesFile(string);
            this.__IM.onExit((Object)this, "getDataSourcePropertiesFile$java_lang_String", (Object)properties);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDataSourcePropertiesFile$java_lang_String", throwable);
            throw throwable;
        }
        return properties;
    }

    private Properties __getDataSourcePropertiesFile(String dsFile) throws Exception {
        try {
            return JProp.getInstance((String)dsFile).getConfigFileEnv();
        }
        catch (Exception e) {
            if (e instanceof FileNotFoundException) {
                logger.log(BasicLevel.ERROR, (Object)("Please check if '" + dsFile + ".properties' is available in JONAS_BASE/conf/ directory"));
            } else {
                logger.log(BasicLevel.ERROR, (Object)("Error occured when reading file " + dsFile));
            }
            throw e;
        }
    }

    @Override
    public void loadDataSource(String string, Properties properties, Boolean bl) throws ServiceException {
        if (!this.__MloadDataSource$java_lang_String$java_util_Properties$java_lang_Boolean) {
            this.__loadDataSource(string, properties, bl);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "loadDataSource$java_lang_String$java_util_Properties$java_lang_Boolean", new Object[]{string, properties, bl});
            this.__loadDataSource(string, properties, bl);
            this.__IM.onExit((Object)this, "loadDataSource$java_lang_String$java_util_Properties$java_lang_Boolean", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "loadDataSource$java_lang_String$java_util_Properties$java_lang_Boolean", throwable);
            throw throwable;
        }
    }

    private void __loadDataSource(String name, Properties prop, Boolean loadFromFile) throws ServiceException {
        boolean fromFile = loadFromFile;
        if (fromFile) {
            logger.log(BasicLevel.DEBUG, (Object)("Load data source named " + name + " from file"));
        } else {
            logger.log(BasicLevel.DEBUG, (Object)("Load data source named " + name + " from form"));
            if (this.isLoadedDataSource(name)) {
                logger.log(BasicLevel.DEBUG, (Object)("This data source, " + name + " is already loaded ; Unload it !"));
                this.unloadDataSource(name);
            }
            try {
                logger.log(BasicLevel.DEBUG, (Object)"Call getInstance on JProp in order to create the properties file");
                JProp.getInstance((String)name, (Properties)prop);
            }
            catch (Exception e) {
                logger.log(BasicLevel.ERROR, (Object)("Cannot create datasource " + name + " as cannot create properties file"));
                throw new ServiceException("DatabaseService: Cannot create datasource '" + name + "'", (Throwable)e);
            }
        }
        try {
            logger.log(BasicLevel.DEBUG, (Object)"Call method to create a data source");
            this.createDataSource(name, prop);
            logger.log(BasicLevel.DEBUG, (Object)"New data source created");
        }
        catch (Exception e) {
            logger.log(BasicLevel.ERROR, (Object)("Cannot create datasource '" + name + "'."));
            if (fromFile) {
                JProp.removeInstance((String)name);
            } else {
                JProp.deleteInstance((String)name);
            }
            throw new ServiceException("DatabaseService: Cannot create datasource: " + name + "'", (Throwable)e);
        }
    }

    @Override
    public String getDatasourceName(String string) {
        String string2;
        if (!this.__MgetDatasourceName$java_lang_String) {
            return this.__getDatasourceName(string);
        }
        try {
            this.__IM.onEntry((Object)this, "getDatasourceName$java_lang_String", new Object[]{string});
            string2 = this.__getDatasourceName(string);
            this.__IM.onExit((Object)this, "getDatasourceName$java_lang_String", (Object)string2);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getDatasourceName$java_lang_String", throwable);
            throw throwable;
        }
        return string2;
    }

    private String __getDatasourceName(String jndiName) {
        return (String)this.__getboundDatasources().get(jndiName);
    }

    private void registerDbmServiceMBean(Object object, String string) {
        if (!this.__MregisterDbmServiceMBean$java_lang_Object$java_lang_String) {
            this.__registerDbmServiceMBean(object, string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "registerDbmServiceMBean$java_lang_Object$java_lang_String", new Object[]{object, string});
            this.__registerDbmServiceMBean(object, string);
            this.__IM.onExit((Object)this, "registerDbmServiceMBean$java_lang_Object$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "registerDbmServiceMBean$java_lang_Object$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __registerDbmServiceMBean(Object service, String domainName) {
        ObjectName on = JonasObjectName.databaseService((String)domainName);
        this.__getjmxService().registerMBean(service, on);
    }

    private void unregisterDbmServiceMBean(String string) {
        if (!this.__MunregisterDbmServiceMBean$java_lang_String) {
            this.__unregisterDbmServiceMBean(string);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unregisterDbmServiceMBean$java_lang_String", new Object[]{string});
            this.__unregisterDbmServiceMBean(string);
            this.__IM.onExit((Object)this, "unregisterDbmServiceMBean$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unregisterDbmServiceMBean$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __unregisterDbmServiceMBean(String domainName) {
        ObjectName on = JonasObjectName.databaseService((String)domainName);
        this.__getjmxService().unregisterMBean(on);
    }

    private JDBCResource registerJdbcResourceMBean(String string, String string2, String string3) {
        JDBCResource jDBCResource;
        if (!this.__MregisterJdbcResourceMBean$java_lang_String$java_lang_String$java_lang_String) {
            return this.__registerJdbcResourceMBean(string, string2, string3);
        }
        try {
            this.__IM.onEntry((Object)this, "registerJdbcResourceMBean$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3});
            jDBCResource = this.__registerJdbcResourceMBean(string, string2, string3);
            this.__IM.onExit((Object)this, "registerJdbcResourceMBean$java_lang_String$java_lang_String$java_lang_String", (Object)jDBCResource);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "registerJdbcResourceMBean$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return jDBCResource;
    }

    private JDBCResource __registerJdbcResourceMBean(String domainName, String serverName, String resourceName) {
        JDBCResource jdbcResourceMBean = null;
        try {
            String jdbcResourceON = J2eeObjectName.JDBCResourceName((String)domainName, (String)serverName, (String)resourceName);
            jdbcResourceMBean = new JDBCResource(jdbcResourceON);
            this.__getjmxService().registerModelMBean((Object)jdbcResourceMBean, jdbcResourceON);
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)"DataBaseService: Cannot register JDBCResource MBean", (Throwable)e);
        }
        return jdbcResourceMBean;
    }

    private String registerJdbcDataSourceAndDriverMBean(String string, String string2, String string3, String string4, String string5, ConnectionManager connectionManager) {
        String string6;
        if (!this.__MregisterJdbcDataSourceAndDriverMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_dbm_internal_cm_ConnectionManager) {
            return this.__registerJdbcDataSourceAndDriverMBean(string, string2, string3, string4, string5, connectionManager);
        }
        try {
            this.__IM.onEntry((Object)this, "registerJdbcDataSourceAndDriverMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_dbm_internal_cm_ConnectionManager", new Object[]{string, string2, string3, string4, string5, connectionManager});
            string6 = this.__registerJdbcDataSourceAndDriverMBean(string, string2, string3, string4, string5, connectionManager);
            this.__IM.onExit((Object)this, "registerJdbcDataSourceAndDriverMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_dbm_internal_cm_ConnectionManager", (Object)string6);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "registerJdbcDataSourceAndDriverMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_dbm_internal_cm_ConnectionManager", throwable);
            throw throwable;
        }
        return string6;
    }

    private String __registerJdbcDataSourceAndDriverMBean(String domainName, String serverName, String jdbcDataSourceName, String jdbcDriverName, String jdbcDriverClassName, ConnectionManager ds) {
        JDBCDataSource jdbcDataSourceMBean = null;
        String jdbcDataSourceON = null;
        try {
            jdbcDataSourceON = J2eeObjectName.getJDBCDataSourceName((String)domainName, (String)serverName, (String)jdbcDataSourceName);
            jdbcDataSourceMBean = new JDBCDataSource(jdbcDataSourceON, ds);
            this.__getjmxService().registerModelMBean((Object)jdbcDataSourceMBean, jdbcDataSourceON);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"JDBCDataSource MBean created");
            }
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)"DataBaseService: Cannot register JDBCDataSource MBean", (Throwable)e);
        }
        JDBCDriver jdbcDriverMBean = null;
        String jdbcDriverON = null;
        try {
            jdbcDriverON = J2eeObjectName.getJDBCDriverName((String)domainName, (String)serverName, (String)jdbcDriverName);
            jdbcDriverMBean = new JDBCDriver(jdbcDriverON);
            jdbcDriverMBean.setDriverClassName(jdbcDriverClassName);
            this.__getjmxService().registerModelMBean((Object)jdbcDriverMBean, jdbcDriverON);
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)"DataBaseService: Cannot register JDBCDriver MBean", (Throwable)e);
        }
        jdbcDataSourceMBean.setJdbcDriver(jdbcDriverON);
        return jdbcDataSourceON;
    }

    private String unregisterJdbcDataSourceAndDriverMBean(String string, String string2, String string3) {
        String string4;
        if (!this.__MunregisterJdbcDataSourceAndDriverMBean$java_lang_String$java_lang_String$java_lang_String) {
            return this.__unregisterJdbcDataSourceAndDriverMBean(string, string2, string3);
        }
        try {
            this.__IM.onEntry((Object)this, "unregisterJdbcDataSourceAndDriverMBean$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3});
            string4 = this.__unregisterJdbcDataSourceAndDriverMBean(string, string2, string3);
            this.__IM.onExit((Object)this, "unregisterJdbcDataSourceAndDriverMBean$java_lang_String$java_lang_String$java_lang_String", (Object)string4);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unregisterJdbcDataSourceAndDriverMBean$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
        return string4;
    }

    private String __unregisterJdbcDataSourceAndDriverMBean(String domainName, String serverName, String jdbcDataSourceName) {
        String jdbcDataSourceON = J2eeObjectName.getJDBCDataSourceName((String)domainName, (String)serverName, (String)jdbcDataSourceName);
        ObjectName onJDBCDataSource = null;
        String jdbcDriverName = null;
        ObjectName onJDBCDriver = null;
        MBeanServer mbeanServer = this.__getjmxService().getJmxServer();
        try {
            onJDBCDataSource = ObjectName.getInstance(jdbcDataSourceON);
            jdbcDriverName = (String)mbeanServer.getAttribute(onJDBCDataSource, "jdbcDriver");
            onJDBCDriver = ObjectName.getInstance(jdbcDriverName);
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)("DataBaseService: Cannot unregister MBean for datasource " + jdbcDataSourceName), (Throwable)e);
        }
        this.__getjmxService().unregisterModelMBean(onJDBCDataSource);
        this.__getjmxService().unregisterModelMBean(onJDBCDriver);
        return jdbcDataSourceON;
    }

    private void unregisterAllDataSourceAndDriverMBeans() {
        if (!this.__MunregisterAllDataSourceAndDriverMBeans) {
            this.__unregisterAllDataSourceAndDriverMBeans();
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unregisterAllDataSourceAndDriverMBeans", new Object[0]);
            this.__unregisterAllDataSourceAndDriverMBeans();
            this.__IM.onExit((Object)this, "unregisterAllDataSourceAndDriverMBeans", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unregisterAllDataSourceAndDriverMBeans", throwable);
            throw throwable;
        }
    }

    private void __unregisterAllDataSourceAndDriverMBeans() {
        String[] ons = this.__getjdbcResourceMBean().getJdbcDataSources();
        ObjectName onJDBCDataSource = null;
        ObjectName onJDBCDriver = null;
        String dataSourceName = null;
        for (int i = 0; i < ons.length; ++i) {
            try {
                onJDBCDataSource = ObjectName.getInstance(ons[i]);
            }
            catch (MalformedObjectNameException e) {
                logger.log(BasicLevel.INFO, (Object)"DataBaseService: Cannot unegister JDBCDataSource MBean", (Throwable)e);
                continue;
            }
            dataSourceName = onJDBCDataSource.getKeyProperty("name");
            MBeanServer mbeanServer = this.__getjmxService().getJmxServer();
            String jdbcDriverName = null;
            try {
                jdbcDriverName = (String)mbeanServer.getAttribute(onJDBCDataSource, "jdbcDriver");
            }
            catch (Exception e) {
                logger.log(BasicLevel.INFO, (Object)("DataBaseService: Cannot unegister JDBCDriver MBean for datasource " + dataSourceName), (Throwable)e);
                continue;
            }
            try {
                onJDBCDriver = new ObjectName(jdbcDriverName);
            }
            catch (MalformedObjectNameException e) {
                logger.log(BasicLevel.INFO, (Object)("DataBaseService: Cannot unegister JDBCDriver MBean" + dataSourceName), (Throwable)e);
                continue;
            }
            this.__getjmxService().unregisterModelMBean(onJDBCDataSource);
            this.__getjmxService().unregisterModelMBean(onJDBCDriver);
            this.__getjdbcResourceMBean().removeJdbcDataSource(onJDBCDataSource.toString());
        }
    }

    private void unregisterJdbcResourceMBean(String string, String string2, String string3) {
        if (!this.__MunregisterJdbcResourceMBean$java_lang_String$java_lang_String$java_lang_String) {
            this.__unregisterJdbcResourceMBean(string, string2, string3);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "unregisterJdbcResourceMBean$java_lang_String$java_lang_String$java_lang_String", new Object[]{string, string2, string3});
            this.__unregisterJdbcResourceMBean(string, string2, string3);
            this.__IM.onExit((Object)this, "unregisterJdbcResourceMBean$java_lang_String$java_lang_String$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "unregisterJdbcResourceMBean$java_lang_String$java_lang_String$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __unregisterJdbcResourceMBean(String domainName, String serverName, String resourceName) {
        try {
            ObjectName jdbcResourceOn = J2eeObjectName.JDBCResource((String)domainName, (String)serverName, (String)resourceName);
            this.__getjmxService().unregisterModelMBean(jdbcResourceOn);
        }
        catch (Exception e) {
            logger.log(BasicLevel.INFO, (Object)"DataBaseService: Cannot unegister JDBCResource MBean", (Throwable)e);
        }
    }

    public void setTransactionService(TransactionService transactionService) {
        if (!this.__MsetTransactionService$org_ow2_jonas_tm_TransactionService) {
            this.__setTransactionService(transactionService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setTransactionService$org_ow2_jonas_tm_TransactionService", new Object[]{transactionService});
            this.__setTransactionService(transactionService);
            this.__IM.onExit((Object)this, "setTransactionService$org_ow2_jonas_tm_TransactionService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setTransactionService$org_ow2_jonas_tm_TransactionService", throwable);
            throw throwable;
        }
    }

    private void __setTransactionService(TransactionService txService) {
        this.__settxService(txService);
    }

    public void setJmxService(JmxService jmxService) {
        if (!this.__MsetJmxService$org_ow2_jonas_jmx_JmxService) {
            this.__setJmxService(jmxService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", new Object[]{jmxService});
            this.__setJmxService(jmxService);
            this.__IM.onExit((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setJmxService$org_ow2_jonas_jmx_JmxService", throwable);
            throw throwable;
        }
    }

    private void __setJmxService(JmxService jmxService) {
        this.__setjmxService(jmxService);
    }

    public void setRegistryService(RegistryService registryService) {
        if (!this.__MsetRegistryService$org_ow2_jonas_registry_RegistryService) {
            this.__setRegistryService(registryService);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "setRegistryService$org_ow2_jonas_registry_RegistryService", new Object[]{registryService});
            this.__setRegistryService(registryService);
            this.__IM.onExit((Object)this, "setRegistryService$org_ow2_jonas_registry_RegistryService", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "setRegistryService$org_ow2_jonas_registry_RegistryService", throwable);
            throw throwable;
        }
    }

    private void __setRegistryService(RegistryService registry) {
        this.__setregistryService(registry);
    }

    private RegistryService getRegistryService() {
        RegistryService registryService;
        if (!this.__MgetRegistryService) {
            return this.__getRegistryService();
        }
        try {
            this.__IM.onEntry((Object)this, "getRegistryService", new Object[0]);
            registryService = this.__getRegistryService();
            this.__IM.onExit((Object)this, "getRegistryService", (Object)registryService);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getRegistryService", throwable);
            throw throwable;
        }
        return registryService;
    }

    private RegistryService __getRegistryService() {
        return this.__getregistryService();
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            if (set.contains("ictx")) {
                this.__Fictx = true;
            }
            if (set.contains("jdbcResourceMBean")) {
                this.__FjdbcResourceMBean = true;
            }
            if (set.contains("cmList")) {
                this.__FcmList = true;
            }
            if (set.contains("registryService")) {
                this.__FregistryService = true;
            }
            if (set.contains("dataSourceNames")) {
                this.__FdataSourceNames = true;
            }
            if (set.contains("boundDatasources")) {
                this.__FboundDatasources = true;
            }
            if (set.contains("txService")) {
                this.__FtxService = true;
            }
            if (set.contains("jmxService")) {
                this.__FjmxService = true;
            }
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("setDatasources$java_lang_String")) {
                this.__MsetDatasources$java_lang_String = true;
            }
            if (set.contains("doStart")) {
                this.__MdoStart = true;
            }
            if (set.contains("doStop")) {
                this.__MdoStop = true;
            }
            if (set.contains("createDataSource$java_lang_String$java_util_Properties")) {
                this.__McreateDataSource$java_lang_String$java_util_Properties = true;
            }
            if (set.contains("unbindDataSources")) {
                this.__MunbindDataSources = true;
            }
            if (set.contains("getConnectionManager$java_lang_String")) {
                this.__MgetConnectionManager$java_lang_String = true;
            }
            if (set.contains("getDSList")) {
                this.__MgetDSList = true;
            }
            if (set.contains("getDataSourcePropertiesFiles")) {
                this.__MgetDataSourcePropertiesFiles = true;
            }
            if (set.contains("getCurrentNumberOfDataSource")) {
                this.__MgetCurrentNumberOfDataSource = true;
            }
            if (set.contains("getTotalCurrentNumberOfJDBCConnectionOpen")) {
                this.__MgetTotalCurrentNumberOfJDBCConnectionOpen = true;
            }
            if (set.contains("isLoadedDataSource$java_lang_String")) {
                this.__MisLoadedDataSource$java_lang_String = true;
            }
            if (set.contains("unloadDataSource$java_lang_String")) {
                this.__MunloadDataSource$java_lang_String = true;
            }
            if (set.contains("getDataSourcePropertiesFile$java_lang_String")) {
                this.__MgetDataSourcePropertiesFile$java_lang_String = true;
            }
            if (set.contains("loadDataSource$java_lang_String$java_util_Properties$java_lang_Boolean")) {
                this.__MloadDataSource$java_lang_String$java_util_Properties$java_lang_Boolean = true;
            }
            if (set.contains("getDatasourceName$java_lang_String")) {
                this.__MgetDatasourceName$java_lang_String = true;
            }
            if (set.contains("registerDbmServiceMBean$java_lang_Object$java_lang_String")) {
                this.__MregisterDbmServiceMBean$java_lang_Object$java_lang_String = true;
            }
            if (set.contains("unregisterDbmServiceMBean$java_lang_String")) {
                this.__MunregisterDbmServiceMBean$java_lang_String = true;
            }
            if (set.contains("registerJdbcResourceMBean$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MregisterJdbcResourceMBean$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("registerJdbcDataSourceAndDriverMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_dbm_internal_cm_ConnectionManager")) {
                this.__MregisterJdbcDataSourceAndDriverMBean$java_lang_String$java_lang_String$java_lang_String$java_lang_String$java_lang_String$org_ow2_jonas_dbm_internal_cm_ConnectionManager = true;
            }
            if (set.contains("unregisterJdbcDataSourceAndDriverMBean$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MunregisterJdbcDataSourceAndDriverMBean$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("unregisterAllDataSourceAndDriverMBeans")) {
                this.__MunregisterAllDataSourceAndDriverMBeans = true;
            }
            if (set.contains("unregisterJdbcResourceMBean$java_lang_String$java_lang_String$java_lang_String")) {
                this.__MunregisterJdbcResourceMBean$java_lang_String$java_lang_String$java_lang_String = true;
            }
            if (set.contains("setTransactionService$org_ow2_jonas_tm_TransactionService")) {
                this.__MsetTransactionService$org_ow2_jonas_tm_TransactionService = true;
            }
            if (set.contains("setJmxService$org_ow2_jonas_jmx_JmxService")) {
                this.__MsetJmxService$org_ow2_jonas_jmx_JmxService = true;
            }
            if (set.contains("setRegistryService$org_ow2_jonas_registry_RegistryService")) {
                this.__MsetRegistryService$org_ow2_jonas_registry_RegistryService = true;
            }
            if (set.contains("getRegistryService")) {
                this.__MgetRegistryService = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

