/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.carol.util.naming;

import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalEnumeration<T extends NameClassPair>
implements NamingEnumeration<T> {
    private Context localContext;
    private final String[] names;
    private int nextName;

    public LocalEnumeration(Context ctx, String[] names) {
        this.localContext = ctx;
        this.names = names;
        this.nextName = 0;
    }

    @Override
    public boolean hasMore() {
        return this.nextName < this.names.length;
    }

    @Override
    public T next() throws NamingException {
        if (!this.hasMore()) {
            throw new NoSuchElementException();
        }
        String name = this.names[this.nextName++];
        Name cname = new CompositeName().add(name);
        Object obj = this.localContext.lookup(cname);
        return (T)new Binding(cname.toString(), obj);
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMore();
    }

    @Override
    public T nextElement() {
        try {
            return (T)this.next();
        }
        catch (NamingException e) {
            throw new NoSuchElementException(e.toString());
        }
    }

    @Override
    public void close() {
    }
}

