/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import java.util.Properties;
import java.util.StringTokenizer;
import org.jacorb.notification.AbstractChannelFactory;

public class ConsoleMain {
    public static void help() {
        System.out.println("valid arguments: [-printIOR] [-printCorbaloc] [-writeIOR <filename>] [-registerName <nameId>[.<nameKind>]] [-port <oaPort>] [-channels <channels>] [-help]");
    }

    public static void addCOSNamingName(Properties properties, String string) {
        int n = string.indexOf(".");
        if (string.lastIndexOf(".") != n) {
            throw new IllegalArgumentException(string + ": argument to -registerName should be " + "<nameId> or <nameId>.<nameKind>");
        }
        if (n != -1) {
            properties.put("jacorb.notification.register_name.id", string.substring(0, n));
            properties.put("jacorb.notification.register_name.kind", string.substring(n + 1));
        } else {
            properties.put("jacorb.notification.register_name.id", string);
        }
    }

    public static AbstractChannelFactory newFactory(String[] stringArray) throws Exception {
        Properties properties = ConsoleMain.parseProperties(stringArray);
        return AbstractChannelFactory.newFactory(properties);
    }

    public static Properties parseProperties(String[] stringArray) {
        if (stringArray == null) {
            return new Properties();
        }
        CmdLineParser cmdLineParser = new CmdLineParser(stringArray);
        return cmdLineParser.getProps();
    }

    public static String[] splitArgs(String string) {
        if (string == null) {
            return new String[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    public static final void main(String[] stringArray) throws Exception {
        try {
            ConsoleMain.newFactory(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println(illegalArgumentException.getMessage());
            ConsoleMain.help();
        }
    }

    private static class CmdLineParser {
        private Properties props = new Properties();

        public Properties getProps() {
            return this.props;
        }

        public CmdLineParser(String[] stringArray) {
            this.perform(stringArray);
        }

        private void perform(String[] stringArray) throws IllegalArgumentException {
            try {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equals("-printIOR")) {
                        this.props.put("jacorb.notification.print_ior", "on");
                        continue;
                    }
                    if (stringArray[i].equals("-printCorbaloc")) {
                        this.props.put("jacorb.notification.print_corbaloc", "on");
                        continue;
                    }
                    if (stringArray[i].equals("-help")) {
                        throw new IllegalArgumentException("usage");
                    }
                    if (stringArray[i].equals("-port")) {
                        this.props.put("OAPort", stringArray[++i]);
                        continue;
                    }
                    if (stringArray[i].equals("-channels")) {
                        this.props.put("jacorb.notification.start_channels", stringArray[++i]);
                        continue;
                    }
                    if (stringArray[i].equals("-writeIOR")) {
                        this.props.put("jacorb.notification.ior_file", stringArray[++i]);
                        continue;
                    }
                    if (stringArray[i].equals("-registerName")) {
                        String string = stringArray[++i];
                        ConsoleMain.addCOSNamingName(this.props, string);
                        continue;
                    }
                    if (stringArray[i].equals("-typed")) {
                        this.props.put("jacorb.notification.enable_typed_channel", "on");
                        continue;
                    }
                    throw new IllegalArgumentException("unknown Argument: " + stringArray[i]);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IllegalArgumentException("illegal number of arguments");
            }
        }
    }
}

