/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.lib;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import org.objectweb.jorm.api.JormConfigurator;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.api.PMappingStructuresManager;
import org.objectweb.jorm.metainfo.api.Manager;
import org.objectweb.jorm.metainfo.api.MappingFactory;
import org.objectweb.jorm.mi2xml.api.MappingDomtreeBuilder;
import org.objectweb.jorm.mi2xml.api.Writer;
import org.objectweb.jorm.util.api.Loggable;
import org.objectweb.jorm.util.io.api.PathExplorer;
import org.objectweb.jorm.xml2mi.api.MappingParser;
import org.objectweb.jorm.xml2mi.api.Parser;
import org.objectweb.util.monolog.Monolog;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;
import org.objectweb.util.monolog.api.MonologFactory;

public class JormConfiguratorImpl
implements JormConfigurator {
    protected Properties properties = null;
    protected Properties logProperties = null;
    protected String pathToJormcOpts = null;
    protected HashMap mappers = new HashMap();
    protected LoggerFactory loggerFactory = null;
    protected Logger logger = null;
    protected ClassLoader loader = null;

    public void configure(String propertyfile) throws PException {
        if (this.properties != null) {
            throw new PException("JORM already configured.");
        }
        try {
            File pf = new File(propertyfile);
            this.properties = new Properties();
            this.properties.load(new FileInputStream(pf));
            this.configure(this.properties);
            this.pathToJormcOpts = pf.getParent();
        }
        catch (IOException e) {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(propertyfile);
            if (is == null) {
                throw new PException(e, "Problem while configuring the JORM: unable to locate [" + propertyfile + "]");
            }
            try {
                this.properties = new Properties();
                this.properties.load(is);
                this.configure(this.properties);
            }
            catch (Exception e2) {
                this.properties = null;
                throw new PException(e2, "Problem while configuring the JORM: unable to locate [" + propertyfile + "]");
            }
        }
    }

    public void configure() throws PException {
        this.configure("jorm.properties");
    }

    public void configure(Properties p) {
        this.properties = p;
        StringTokenizer st = new StringTokenizer(p.getProperty("jorm.mapper.list").trim(), ",");
        while (st.hasMoreTokens()) {
            String mappername = st.nextToken();
            String sms = this.properties.getProperty("jorm.mapper.submappers." + mappername);
            if (sms == null) continue;
            ArrayList<String> sml = new ArrayList<String>();
            this.mappers.put(mappername, sml);
            StringTokenizer st2 = new StringTokenizer(sms.trim(), ",", false);
            while (st2.hasMoreTokens()) {
                sml.add(st2.nextToken());
            }
        }
        String useCtxLoader = this.properties.getProperty("use.context.classloader", "false").trim();
        this.loader = "false".equals(useCtxLoader) ? this.getClass().getClassLoader() : Thread.currentThread().getContextClassLoader();
    }

    public void configureLog(String propertyfile) throws PException {
        if (this.loggerFactory == null) {
            this.loggerFactory = Monolog.getMonologFactory();
            if (this.loggerFactory == Monolog.getDefaultMonologFactory()) {
                this.loggerFactory = Monolog.getMonologFactory((String)propertyfile);
            }
        } else {
            Properties p = new Properties();
            try {
                File pf = new File(propertyfile);
                p.load(new FileInputStream(pf));
            }
            catch (IOException e) {
                try {
                    p.load(this.loader.getResourceAsStream(propertyfile));
                }
                catch (Exception e2) {
                    throw new PException(e, "Problem while configuring the JORM: unable to locate [" + propertyfile + "]");
                }
            }
            Monolog.loadMonologConfiguration((Properties)p, (MonologFactory)((MonologFactory)this.loggerFactory));
        }
        this.logger = this.loggerFactory.getLogger("org.objectweb.jorm.lib.JormConfiguratorImpl");
    }

    public void configureMIManager(Manager miman) throws PException {
        ((Loggable)((Object)miman)).setLoggerFactory(this.loggerFactory);
        ((Loggable)((Object)miman)).setLogger(this.loggerFactory.getLogger("org.objectweb.jorm.metainfo"));
        miman.init();
        Iterator it = this.knownMappers();
        while (it.hasNext()) {
            String mn = (String)it.next();
            this.logger.log(BasicLevel.DEBUG, (Object)("Register specific meta-information management for mapper [" + mn + "]"));
            miman.addMappingFactory(mn, this.getMIFactory(mn));
        }
    }

    public void configureParser(Parser parser, ArrayList dtdlocs, PathExplorer pe, Manager miman) throws PException {
        ((Loggable)((Object)parser)).setLoggerFactory(this.loggerFactory);
        ((Loggable)((Object)parser)).setLogger(this.loggerFactory.getLogger("org.objectweb.jorm.xml2mi"));
        parser.setMetaInfoManager(miman);
        this.logger.log(BasicLevel.DEBUG, (Object)"Assign the path explorer to parser");
        parser.setPathExplorer(pe);
        parser.init(true, dtdlocs);
        Iterator it = this.knownMappers();
        while (it.hasNext()) {
            String mn = (String)it.next();
            this.logger.log(BasicLevel.DEBUG, (Object)("Register specific parser for mapper [" + mn + "]"));
            MappingParser mp = this.getMappingParser(mn);
            ((Loggable)((Object)mp)).setLoggerFactory(this.loggerFactory);
            ((Loggable)((Object)mp)).setLogger(this.loggerFactory.getLogger("org.objectweb.jorm.xml2mi." + mn));
            parser.addMappingParser(mn, mp);
        }
    }

    public Iterator knownMappers() throws PException {
        if (this.properties == null) {
            throw new PException("JORM has not been configured.");
        }
        return this.mappers.keySet().iterator();
    }

    public void setLoggerFactory(LoggerFactory lf) {
        this.loggerFactory = lf;
        this.logger = lf.getLogger("org.objectweb.jorm.config");
    }

    public LoggerFactory getLoggerFactory() throws PException {
        if (this.loggerFactory == null) {
            throw new PException("JORM has not been configured.");
        }
        return this.loggerFactory;
    }

    public Manager getMIManager() throws PException {
        if (this.properties == null) {
            throw new PException("JORM has not been configured.");
        }
        String cn = this.properties.getProperty("jorm.mimanager");
        if (cn == null) {
            throw new PException("Impossible to load a meta info manager: not configured:" + this.properties);
        }
        try {
            Manager m = (Manager)this.loader.loadClass(cn).newInstance();
            if (this.loggerFactory != null && m instanceof Loggable) {
                ((Loggable)((Object)m)).setLoggerFactory(this.loggerFactory);
            }
            return m;
        }
        catch (InstantiationException e) {
            throw new PException(e, "Problem while instantiating " + cn);
        }
        catch (IllegalAccessException e) {
            throw new PException(e, "Problem while trying to access " + cn);
        }
        catch (ClassNotFoundException e) {
            throw new PException(e, "Problem while loading class " + cn);
        }
    }

    public Parser getParser() throws PException {
        if (this.properties == null) {
            throw new PException("JORM has not been configured.");
        }
        String cn = this.properties.getProperty("jorm.parser");
        if (cn == null) {
            throw new PException("Impossible to load a parser: not configured:" + this.properties);
        }
        try {
            return (Parser)this.loader.loadClass(cn).newInstance();
        }
        catch (InstantiationException e) {
            throw new PException(e, "Problem while instantiating " + cn);
        }
        catch (IllegalAccessException e) {
            throw new PException(e, "Problem while trying to access " + cn);
        }
        catch (ClassNotFoundException e) {
            throw new PException(e, "Problem while loading class " + cn);
        }
    }

    public MappingFactory getMIFactory(String mappername) throws PException {
        if (this.properties == null) {
            throw new PException("JORM has not been configured.");
        }
        String cn = this.properties.getProperty("jorm.mapper.mifactory." + mappername);
        if (cn == null) {
            throw new PException("Impossible to load a meta info factory: not configured:jorm.mapper.mifactory." + mappername);
        }
        try {
            MappingFactory mf = (MappingFactory)this.loader.loadClass(cn).newInstance();
            return mf;
        }
        catch (InstantiationException e) {
            throw new PException(e, "Problem while instantiating " + cn);
        }
        catch (IllegalAccessException e) {
            throw new PException(e, "Problem while trying to access " + cn);
        }
        catch (ClassNotFoundException e) {
            throw new PException(e, "Problem while loading class " + cn);
        }
    }

    public PMappingStructuresManager getSchMgr(String mappername) throws PException {
        if (this.properties == null) {
            throw new PException("JORM has not been configured.");
        }
        String cn = this.properties.getProperty("jorm.mapper.schmgr." + mappername);
        if (cn == null) {
            throw new PException("Impossible to load a schema manager: not configured:" + this.properties);
        }
        try {
            PMappingStructuresManager mf = (PMappingStructuresManager)this.loader.loadClass(cn).newInstance();
            return mf;
        }
        catch (InstantiationException e) {
            throw new PException(e, "Problem while instantiating " + cn);
        }
        catch (IllegalAccessException e) {
            throw new PException(e, "Problem while trying to access " + cn);
        }
        catch (ClassNotFoundException e) {
            throw new PException(e, "Problem while loading class " + cn);
        }
    }

    public Class getGcmClass(String mappername) throws PException {
        if (this.properties == null) {
            throw new PException("JORM has not been configured.");
        }
        String cn = this.properties.getProperty("jorm.mapper.gcmapping." + mappername);
        if (cn == null) {
            throw new PException("Impossible to load a generic class mapping: not configured:" + this.properties);
        }
        try {
            Class<?> res = this.loader.loadClass(cn);
            res.newInstance();
            return res;
        }
        catch (InstantiationException e) {
            throw new PException(e, "Problem while trying to instantiate " + cn);
        }
        catch (IllegalAccessException e) {
            throw new PException(e, "Problem while trying to access " + cn);
        }
        catch (ClassNotFoundException e) {
            throw new PException(e, "Problem while loading class " + cn);
        }
    }

    public MappingParser getMappingParser(String mappername) throws PException {
        if (this.properties == null) {
            throw new PException("JORM has not been configured.");
        }
        String cn = this.properties.getProperty("jorm.mapper.parser." + mappername);
        try {
            MappingParser p = (MappingParser)this.loader.loadClass(cn).newInstance();
            return p;
        }
        catch (InstantiationException e) {
            throw new PException(e, "Problem while instantiating " + cn);
        }
        catch (IllegalAccessException e) {
            throw new PException(e, "Problem while trying to access " + cn);
        }
        catch (ClassNotFoundException e) {
            throw new PException(e, "Problem while loading class " + cn);
        }
    }

    public Writer getWriter() throws PException {
        if (this.properties == null) {
            throw new PException("JORM has not been configured.");
        }
        String cn = this.properties.getProperty("jorm.writer");
        try {
            return (Writer)this.loader.loadClass(cn).newInstance();
        }
        catch (InstantiationException e) {
            throw new PException(e, "Problem while instantiating " + cn);
        }
        catch (IllegalAccessException e) {
            throw new PException(e, "Problem while trying to access " + cn);
        }
        catch (ClassNotFoundException e) {
            throw new PException(e, "Problem while loading class " + cn);
        }
    }

    public MappingDomtreeBuilder getMappingDomtreeBuilder(String mappername) throws PException {
        if (this.properties == null) {
            throw new PException("JORM has not been configured.");
        }
        String cn = this.properties.getProperty("jorm.mapper.writer." + mappername);
        try {
            MappingDomtreeBuilder mdg = (MappingDomtreeBuilder)this.loader.loadClass(cn).newInstance();
            return mdg;
        }
        catch (InstantiationException e) {
            throw new PException(e, "Problem while instantiating " + cn);
        }
        catch (IllegalAccessException e) {
            throw new PException(e, "Problem while trying to access " + cn);
        }
        catch (ClassNotFoundException e) {
            throw new PException(e, "Problem while loading class " + cn);
        }
    }

    public Collection getSubMappers(String mappername) throws PException {
        if (this.properties == null) {
            throw new PException("JORM has not been configured.");
        }
        return (Collection)this.mappers.get(mappername);
    }

    public void removeMapper(String mn) {
        this.mappers.remove(mn);
    }

    public void removeAllMappers() {
        this.mappers.clear();
    }

    public void removeSubMapper(String mn, String smn) {
        ArrayList sms = (ArrayList)this.mappers.get(mn);
        if (sms == null) {
            return;
        }
        int pos = sms.indexOf(smn);
        if (pos == -1) {
            return;
        }
        sms.remove(pos);
    }

    public void addSubMapper(String mn, String smn) {
        int pos;
        ArrayList<String> sms = (ArrayList<String>)this.mappers.get(mn);
        if (sms == null) {
            sms = new ArrayList<String>();
            this.mappers.put(mn, sms);
        }
        if ((pos = sms.indexOf(smn)) == -1) {
            sms.add(smn);
        }
    }
}

