/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.type.lib;

import org.objectweb.jorm.type.api.PType;
import org.objectweb.jorm.type.api.PTypeSpace;

public class TypeHelper {
    public static final TypeHelper instance = new TypeHelper();
    public static final String CODER_ITF = "PNameCoder";

    public final String getGenPaMethodPart(PType pt) {
        switch (pt.getTypeCode()) {
            case 19: {
                return "ByteArray";
            }
            case 23: {
                return "Ref";
            }
        }
        return pt.getCodingName();
    }

    public final String getPNameCodingMethodPart(PType pt) {
        if (pt.getTypeCode() == 19) {
            return "";
        }
        return pt.getCodingName();
    }

    public final String getValueAsObjectForGen(String strValue, PType valueType) {
        if (this.isObjectType(valueType)) {
            return strValue;
        }
        return "new " + this.toJavaLangPrimitive(valueType).getJavaName() + "(" + strValue + ")";
    }

    public final String getDefaultNullValueAsString(PType type) {
        switch (type.getTypeCode()) {
            case 0: {
                return "false";
            }
            case 2: {
                return "(byte) -1";
            }
            case 1: {
                return "(char) 0";
            }
            case 3: {
                return "(short) -1";
            }
            case 4: {
                return "(int) -1";
            }
            case 5: {
                return "(long) -1";
            }
            case 6: {
                return "(float) -1";
            }
            case 7: {
                return "(double) -1";
            }
        }
        return "null";
    }

    public final PType toJavaLangPrimitive(PType pt) {
        switch (pt.getTypeCode()) {
            case 0: {
                return PTypeSpace.OBJBOOLEAN;
            }
            case 1: {
                return PTypeSpace.OBJCHAR;
            }
            case 2: {
                return PTypeSpace.OBJBYTE;
            }
            case 3: {
                return PTypeSpace.OBJSHORT;
            }
            case 4: {
                return PTypeSpace.OBJINT;
            }
            case 5: {
                return PTypeSpace.OBJLONG;
            }
            case 6: {
                return PTypeSpace.OBJFLOAT;
            }
            case 7: {
                return PTypeSpace.OBJDOUBLE;
            }
        }
        return pt;
    }

    public final PType toPrimitive(PType pt) {
        switch (pt.getTypeCode()) {
            case 8: {
                return PTypeSpace.BOOLEAN;
            }
            case 9: {
                return PTypeSpace.CHAR;
            }
            case 10: {
                return PTypeSpace.BYTE;
            }
            case 11: {
                return PTypeSpace.SHORT;
            }
            case 12: {
                return PTypeSpace.INT;
            }
            case 13: {
                return PTypeSpace.LONG;
            }
            case 14: {
                return PTypeSpace.FLOAT;
            }
            case 15: {
                return PTypeSpace.DOUBLE;
            }
        }
        return pt;
    }

    public final boolean isObjectType(PType pt) {
        short typeCode = (short)pt.getTypeCode();
        switch (typeCode) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return false;
            }
        }
        return true;
    }

    public final String getCodingTypeAsString(int typecode) {
        switch (typecode) {
            case 1: {
                return "PNameCoder.CTCHAR";
            }
            case 9: {
                return "PNameCoder.CTOCHAR";
            }
            case 2: {
                return "PNameCoder.CTBYTE";
            }
            case 10: {
                return "PNameCoder.CTOBYTE";
            }
            case 3: {
                return "PNameCoder.CTSHORT";
            }
            case 11: {
                return "PNameCoder.CTOSHORT";
            }
            case 4: {
                return "PNameCoder.CTINT";
            }
            case 12: {
                return "PNameCoder.CTOINT";
            }
            case 5: {
                return "PNameCoder.CTLONG";
            }
            case 13: {
                return "PNameCoder.CTOLONG";
            }
            case 16: {
                return "PNameCoder.CTSTRING";
            }
            case 19: {
                return "PNameCoder.CTBYTEARRAY";
            }
            case 18: {
                return "PNameCoder.CTCHARARRAY";
            }
            case 17: {
                return "PNameCoder.CTDATE";
            }
            case 22: {
                return "PNameCoder.CTBIGDECIMAL";
            }
            case 21: {
                return "PNameCoder.CTBIGINTEGER";
            }
        }
        return null;
    }

    public final String getTupleGetterAsString(PType type) {
        switch (type.getTypeCode()) {
            case 0: {
                return "getBoolean";
            }
            case 2: {
                return "getByte";
            }
            case 1: {
                return "getChar";
            }
            case 17: {
                return "getDate";
            }
            case 18: {
                return "getCharArray";
            }
            case 19: {
                return "getByteArray";
            }
            case 3: {
                return "getShort";
            }
            case 4: {
                return "getInt";
            }
            case 5: {
                return "getLong";
            }
            case 6: {
                return "getFloat";
            }
            case 7: {
                return "getDouble";
            }
            case 16: {
                return "getString";
            }
            case 22: {
                return "getBigDecimal";
            }
            case 21: {
                return "getBigInteger";
            }
        }
        return "getObject";
    }
}

