/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.enhancer.interceptors;

import java.lang.constant.Constable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.ow2.easybeans.asm.Type;
import org.ow2.easybeans.deployment.metadata.ejbjar.EasyBeansEjbJarMethodMetadata;
import org.ow2.util.scan.api.metadata.structures.JMethod;

public final class MethodHelper {
    private MethodHelper() {
    }

    public static String getSignature(EasyBeansEjbJarMethodMetadata methodMetadata) {
        return methodMetadata.getJMethod().getName() + methodMetadata.getJMethod().getDescriptor().hashCode();
    }

    public static Method getMethod(String classname, JMethod jMethod, ClassLoader classLoader) {
        Class<?> clazz;
        try {
            clazz = classLoader.loadClass(classname.replace("/", "."));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Unable to load the class '" + classname + "'.", e);
        }
        String methodName = jMethod.getName();
        Type[] argumentTypes = Type.getArgumentTypes(jMethod.getDescriptor());
        Class[] parameterTypes = null;
        if (argumentTypes != null) {
            ArrayList<Class<Integer>> parameters = new ArrayList<Class<Integer>>();
            for (Type type : argumentTypes) {
                try {
                    String parameterClassName = type.getClassName().replace("/", ".");
                    Class<Constable> parameterClass = null;
                    parameterClass = "int".equals(parameterClassName) ? Integer.TYPE : ("byte".equals(parameterClassName) ? Byte.TYPE : ("char".equals(parameterClassName) ? Character.TYPE : ("long".equals(parameterClassName) ? Long.TYPE : ("short".equals(parameterClassName) ? Short.TYPE : ("float".equals(parameterClassName) ? Float.TYPE : ("double".equals(parameterClassName) ? Double.TYPE : ("boolean".equals(parameterClassName) ? Boolean.TYPE : (9 == type.getSort() ? Class.forName(type.getDescriptor().replace('/', '.'), true, classLoader) : classLoader.loadClass(parameterClassName)))))))));
                    parameters.add(parameterClass);
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("Unable to load the class '" + type.getClassName() + "'.", e);
                }
            }
            parameterTypes = parameters.toArray(new Class[parameters.size()]);
        }
        try {
            return clazz.getMethod(methodName, parameterTypes);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Unable to get the method '" + methodName + "'.", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Unable to get the method '" + methodName + "'.", e);
        }
    }
}

