/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.test;

import aQute.bnd.build.Container;
import aQute.bnd.build.Project;
import aQute.lib.osgi.Processor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectLauncher
extends Processor {
    final Project project;
    static File runtime;
    String report;

    public ProjectLauncher(Project project) {
        super(project);
        this.project = project;
    }

    public String getProgramArguments(boolean underTest) throws Exception {
        ArrayList<String> programArguments = new ArrayList<String>();
        this.doStorage(programArguments);
        this.doRunpath(programArguments);
        this.doTarget(programArguments, underTest);
        this.doRunbundles(programArguments);
        this.getInfo(this.project);
        return Processor.join(programArguments, " ");
    }

    public String[] getClasspath() {
        try {
            ArrayList<String> classpath = new ArrayList<String>();
            classpath.add(ProjectLauncher.getRuntime().getAbsolutePath());
            for (Container c : this.project.getRunpath()) {
                if (c.getType() != Container.TYPE.ERROR) {
                    if (c.getFile().getName().startsWith("ee.")) continue;
                    classpath.add(c.getFile().getAbsolutePath());
                    continue;
                }
                this.error("Invalid entry on the -runpath: " + c);
            }
            return classpath.toArray(new String[classpath.size()]);
        }
        catch (Exception e) {
            this.error("Calculating class path", e);
            return null;
        }
    }

    public static File getRuntime() {
        if (runtime == null) {
            try {
                URL url = ProjectLauncher.class.getResource("aQute.runtime.jar");
                if (url == null) {
                    throw new IllegalStateException("Can not find my runtime.jar");
                }
                runtime = File.createTempFile("aQute.runtime", ".jar");
                FileOutputStream out = new FileOutputStream(runtime);
                InputStream in = url.openStream();
                ProjectLauncher.copy(in, out);
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return runtime;
    }

    private void doRunbundles(List<String> programArguments) throws Exception {
        Collection<Container> testbundles = this.project.getRunbundles();
        for (Container c : testbundles) {
            if (c.getError() != null) {
                this.error("Invalid bundle on -runbundles " + c.getError());
                continue;
            }
            if (c.getVersion() != null && c.getVersion().equals("project")) {
                File[] outputs;
                Project sub = c.getProject();
                sub.clear();
                File[] fileArray = outputs = sub.build(false);
                int n = outputs.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    programArguments.add("-bundle");
                    programArguments.add(f.getAbsolutePath());
                    ++n2;
                }
                this.getInfo(sub);
                continue;
            }
            programArguments.add("-bundle");
            programArguments.add(c.getFile().getAbsolutePath());
        }
    }

    private void doTarget(List<String> programArguments, boolean undertest) throws Exception {
        File[] files;
        File[] fileArray = files = this.project.build(undertest);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            programArguments.add("-target");
            programArguments.add(f.getAbsolutePath());
            ++n2;
        }
    }

    private void doRunpath(List<String> programArguments) throws Exception {
        Collection<Container> testpath = this.project.getRunpath();
        Container found = null;
        for (Container c : testpath) {
            String[] parts;
            String exports;
            if (c.getAttributes().containsKey("framework")) {
                if (found != null) {
                    this.warning("Specifying multiple framework classes on the -runpath\nPrevious found: " + found.getProject() + " " + found.getAttributes() + "\n" + "Now found     : " + c.getProject() + " " + c.getAttributes());
                }
                programArguments.add("-framework");
                programArguments.add(c.getAttributes().get("framework"));
                found = c;
            }
            if ((exports = c.getAttributes().get("export")) == null) continue;
            String[] stringArray = parts = exports.split("\\s*,\\s*");
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String p = stringArray[n2];
                programArguments.add("-export");
                programArguments.add(p);
                ++n2;
            }
        }
    }

    private void doStorage(List<String> programArguments) throws Exception {
        File tmp = new File(this.project.getTarget(), "fwtmp");
        tmp.mkdirs();
        tmp.deleteOnExit();
        programArguments.add("-storage");
        programArguments.add(tmp.getAbsolutePath());
    }

    private static void copy(InputStream in, FileOutputStream out) throws IOException {
        byte[] buf = new byte[8192];
        int size = in.read(buf);
        while (size > 0) {
            out.write(buf, 0, size);
            size = in.read(buf);
        }
        in.close();
    }

    public Process launch(File target) throws Exception {
        List<String> arguments = this.newList();
        arguments.add(this.getProperty("java", "java"));
        this.doClasspath(arguments);
        arguments.add("aQute.junit.runtime.Target");
        this.doRunpath(arguments);
        arguments.add("-target");
        arguments.add(target.getAbsolutePath());
        arguments.add("-report");
        arguments.add(this.getTestreport());
        String verbose = this.getProperty("-verbose");
        if (ProjectLauncher.isTrue(verbose)) {
            arguments.add("-verbose");
        }
        this.doRunbundles(arguments);
        this.doStorage(arguments);
        String[] cmdarray = arguments.toArray(new String[arguments.size()]);
        return Runtime.getRuntime().exec(cmdarray, null, this.project.getBase());
    }

    private void doClasspath(List<String> arguments) {
        Collection cp = Arrays.asList(this.getClasspath());
        if (!cp.isEmpty()) {
            arguments.add("-classpath");
            arguments.add(ProjectLauncher.join(cp, File.pathSeparator));
        }
    }

    public int run(File f) throws Exception {
        final Process process = this.launch(f);
        Thread killer = new Thread(){

            public void run() {
                process.destroy();
            }
        };
        Runtime.getRuntime().addShutdownHook(killer);
        Streamer sin = new Streamer(process.getInputStream(), System.out);
        Streamer serr = new Streamer(process.getErrorStream(), System.out);
        try {
            sin.start();
            serr.start();
            int n = process.waitFor();
            return n;
        }
        finally {
            Runtime.getRuntime().removeShutdownHook(killer);
            sin.join();
            serr.join();
        }
    }

    public String getTestreport() {
        if (this.report != null) {
            return this.report;
        }
        this.report = this.getProperty("-testreport", "${target}/test-report.xml");
        return this.report;
    }

    static class Streamer
    extends Thread {
        final InputStream in;
        final OutputStream out;

        Streamer(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        public void run() {
            try {
                int c;
                while ((c = this.in.read()) > 0) {
                    this.out.write(c);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

