/*
 * Decompiled with CFR 0.152.
 */
package aQute.lib.osgi;

import aQute.bnd.make.Make;
import aQute.lib.osgi.Analyzer;
import aQute.lib.osgi.Clazz;
import aQute.lib.osgi.EmbeddedResource;
import aQute.lib.osgi.FileResource;
import aQute.lib.osgi.Instruction;
import aQute.lib.osgi.Jar;
import aQute.lib.osgi.JarResource;
import aQute.lib.osgi.Macro;
import aQute.lib.osgi.PreprocessResource;
import aQute.lib.osgi.Processor;
import aQute.lib.osgi.Resource;
import aQute.lib.osgi.Verifier;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Builder
extends Analyzer {
    private static final int SPLIT_MERGE_LAST = 1;
    private static final int SPLIT_MERGE_FIRST = 2;
    private static final int SPLIT_ERROR = 3;
    private static final int SPLIT_FIRST = 4;
    private static final int SPLIT_DEFAULT = 0;
    public static final String MAKE = "-make";
    List<File> sourcePath = new ArrayList<File>();
    Pattern NAME_URL = Pattern.compile("(.*)(http://.*)");
    Make make = new Make(this);
    boolean firstUse = true;
    static String _classesHelp = "${classes;'implementing'|'extending'|'importing'|'named'|'version'|'any';<pattern>}, Return a list of class fully qualified class names that extend/implement/import any of the contained classes matching the pattern\n";

    public Builder(Processor parent) {
        super(parent);
    }

    public Builder() {
    }

    public Jar build() throws Exception {
        if (this.getProperty("-nope") != null) {
            return null;
        }
        String sub = this.getProperty("-sub");
        if (sub != null && sub.trim().length() > 0) {
            this.error("Specified -sub but calls build() instead of builds() (might be a programmer error)");
        }
        if (this.getProperty("-conduit") != null) {
            this.error("Specified -conduit but calls build() instead of builds() (might be a programmer error");
        }
        this.dot = new Jar("dot");
        this.addClose(this.dot);
        try {
            long modified = Long.parseLong(this.getProperty("base.modified"));
            this.dot.updateModified(modified, "Base modified");
        }
        catch (Exception modified) {
            // empty catch block
        }
        this.doExpand(this.dot);
        this.doIncludeResources(this.dot);
        this.doConditional(this.dot);
        Manifest manifest = this.calcManifest();
        String mf = this.getProperty("-manifest");
        if (mf != null) {
            File mff = this.getFile(mf);
            if (mff.isFile()) {
                try {
                    FileInputStream in = new FileInputStream(mff);
                    manifest = new Manifest(in);
                    ((InputStream)in).close();
                }
                catch (Exception e) {
                    this.error("-manifest while reading manifest file", e);
                }
            } else {
                this.error("-manifest, no such file " + mf);
            }
        }
        this.dot.setManifest(manifest);
        this.addSources(this.dot);
        if (this.getProperty("-pom") != null) {
            this.doPom(this.dot);
        }
        this.doVerify(this.dot);
        if (this.dot.getResources().isEmpty()) {
            this.error("The JAR is empty");
        }
        this.dot.updateModified(this.lastModified(), "Last Modified Processor");
        this.dot.setName(this.getBsn());
        return this.dot;
    }

    public boolean hasSources() {
        return Builder.isTrue(this.getProperty("-sources"));
    }

    @Override
    protected String getImportPackages() {
        String ip = super.getImportPackages();
        if (ip != null) {
            return ip;
        }
        return "*";
    }

    private void doConditional(Jar dot) throws IOException {
        int size;
        Map<String, Map<String, String>> conditionals = this.getHeader("Conditional-Package");
        do {
            size = dot.getDirectories().size();
            this.analyze();
            this.analyzed = false;
            Map<String, Map<String, String>> imports = this.getImports();
            Map<String, Map<String, String>> filtered = Builder.merge("Conditional-Package", conditionals, imports, new HashSet<String>());
            for (Map.Entry<String, Map<String, String>> entry : this.getImports().entrySet()) {
                String type = entry.getValue().get("import:");
                if (type == null || !type.equals("private")) continue;
                filtered.put(entry.getKey(), entry.getValue());
            }
            filtered.keySet().removeAll(dot.getPackages());
            this.doExpand(dot, "Conditional-Package Private imports", this.replaceWithPattern(filtered), false);
        } while (dot.getDirectories().size() > size);
        this.analyzed = true;
    }

    @Override
    public void analyze() throws IOException {
        super.analyze();
        this.cleanupVersion(this.imports);
        this.cleanupVersion(this.exports);
        String version = this.getProperty("Bundle-Version");
        if (version != null) {
            this.setProperty("Bundle-Version", Builder.cleanupVersion(version));
        }
    }

    public void cleanupVersion(Map<String, Map<String, String>> mapOfMap) {
        for (Map.Entry<String, Map<String, String>> entry : mapOfMap.entrySet()) {
            Map<String, String> attributes = entry.getValue();
            if (!attributes.containsKey("version")) continue;
            attributes.put("version", Builder.cleanupVersion(attributes.get("version")));
        }
    }

    private void addSources(Jar dot) {
        if (!this.hasSources()) {
            return;
        }
        HashSet<String> packages = new HashSet<String>();
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.getProperties().store(out, "Generated by BND, at " + new Date());
            dot.putResource("OSGI-OPT/bnd.bnd", new EmbeddedResource(out.toByteArray(), 0L));
            out.close();
        }
        catch (Exception e) {
            this.error("Can not embed bnd file in JAR: " + e);
        }
        for (String path : this.classspace.keySet()) {
            String pack = this.getPackage(path = String.valueOf(path.substring(0, path.length() - ".class".length())) + ".java").replace('.', '/');
            if (pack.length() > 1) {
                pack = String.valueOf(pack) + "/";
            }
            for (File root : this.getSourcePath()) {
                File f = Builder.getFile(root, path);
                if (!f.exists()) continue;
                if (!packages.contains(pack)) {
                    packages.add(pack);
                    File bdir = Builder.getFile(root, pack);
                    String[] fixed = new String[]{"packageinfo", "package.html", "module-info.java", "package-info.java"};
                    int j = 0;
                    while (j < fixed.length) {
                        File ff = Builder.getFile(bdir, fixed[j]);
                        if (ff.isFile()) {
                            dot.putResource("OSGI-OPT/src/" + pack + fixed[j], new FileResource(ff));
                        }
                        ++j;
                    }
                }
                dot.putResource("OSGI-OPT/src/" + path, new FileResource(f));
            }
            if (!this.getSourcePath().isEmpty()) continue;
            this.warning("Including sources but -sourcepath does not contain any source directories ");
        }
    }

    public Collection<File> getSourcePath() {
        if (this.firstUse) {
            this.firstUse = false;
            String sp = this.getProperty("-sourcepath");
            if (sp != null) {
                Map<String, Map<String, String>> map = this.parseHeader(sp);
                for (String file : map.keySet()) {
                    if (file.endsWith("~")) continue;
                    File f = this.getFile(file);
                    if (!f.isDirectory()) {
                        this.error("Adding a sourcepath that is not a directory: " + f);
                        continue;
                    }
                    this.sourcePath.add(f);
                }
            }
        }
        return this.sourcePath;
    }

    private void doVerify(Jar dot) throws Exception {
        Verifier verifier = new Verifier(dot, this.getProperties());
        verifier.setPedantic(this.isPedantic());
        verifier.setClassSpace(this.classspace, this.contained, this.referred, this.uses);
        verifier.verify();
        this.getInfo(verifier);
    }

    private void doExpand(Jar jar) throws IOException {
        if (this.getClasspath().size() == 0 && (this.getProperty("Export-Package") != null || this.getProperty("Private-Package") != null)) {
            this.warning("Classpath is empty. Private-Package and Export-Package can only expand from the classpath when there is one");
        }
        Map<Instruction, Map<String, String>> prive = this.replaceWithPattern(this.getHeader("Private-Package"));
        Map<Instruction, Map<String, String>> export = this.replaceWithPattern(this.getHeader("Export-Package"));
        if (prive.isEmpty() && export.isEmpty() && !this.isResourceOnly()) {
            this.warning("Neither Export-Package nor Private-Package is set, therefore no packages will be included");
        }
        this.doExpand(jar, "Export-Package", export, true);
        this.doExpand(jar, "Private-Package", prive, true);
        if (Builder.isTrue(this.getProperty("-undertest"))) {
            Map<Instruction, Map<String, String>> extra = this.replaceWithPattern(this.parseHeader(this.getProperty("-testpackages", "test")));
            this.doExpand(jar, "-testpackages", extra, false);
        }
    }

    private void doExpand(Jar jar, String name, Map<Instruction, Map<String, String>> instructions, boolean mandatory) {
        Set<Instruction> superfluous = this.removeMarkedDuplicates((Collection<Instruction>)instructions.keySet());
        for (Jar now : this.getClasspath()) {
            this.doExpand(jar, instructions, now, superfluous);
        }
        if (mandatory && superfluous.size() > 0) {
            StringBuffer sb = new StringBuffer();
            String del = "Instructions for " + name + " that are never used: ";
            for (Instruction p : superfluous) {
                sb.append(del);
                sb.append(p.getPattern());
                del = ", ";
            }
            this.warning(sb.toString());
        }
    }

    private void doExpand(Jar jar, Map<Instruction, Map<String, String>> included, Jar classpathEntry, Set<Instruction> superfluous) {
        block6: for (Map.Entry<String, Map<String, Resource>> directory : classpathEntry.getDirectories().entrySet()) {
            String pack;
            Instruction instr;
            String path = directory.getKey();
            if (doNotCopy.matcher(this.getName(path)).matches() || directory.getValue() == null || (instr = this.matches(included, pack = path.replace('/', '.'), superfluous)) == null || instr.isNegated()) continue;
            Map<String, Resource> contents = directory.getValue();
            boolean overwriteResource = true;
            if (jar.hasDirectory(path)) {
                Map<String, String> directives = included.get(instr);
                switch (this.getSplitStrategy(directives.get("-split-package:"))) {
                    case 1: {
                        overwriteResource = true;
                        break;
                    }
                    case 2: {
                        overwriteResource = false;
                        break;
                    }
                    case 3: {
                        this.error(this.diagnostic(pack, this.getClasspath(), classpathEntry.source));
                        continue block6;
                    }
                    case 4: {
                        continue block6;
                    }
                    default: {
                        this.warning(this.diagnostic(pack, this.getClasspath(), classpathEntry.source));
                        overwriteResource = false;
                    }
                }
            }
            jar.addDirectory(contents, overwriteResource);
            String key = String.valueOf(path) + "/bnd.info";
            Resource r = jar.getResource(key);
            if (r != null) {
                jar.putResource(key, new PreprocessResource(this, r));
            }
            if (!this.hasSources()) continue;
            String srcPath = "OSGI-INF/src/" + path;
            Map<String, Resource> srcContents = classpathEntry.getDirectories().get(srcPath);
            if (srcContents == null) continue;
            jar.addDirectory(srcContents, overwriteResource);
        }
    }

    private String diagnostic(String pack, List<Jar> classpath, File source) {
        pack = pack.replace('.', '/');
        ArrayList<Jar> culprits = new ArrayList<Jar>();
        for (Jar culprit : classpath) {
            if (!culprit.getDirectories().containsKey(pack)) continue;
            culprits.add(culprit);
        }
        return "Split package " + pack + "\nUse directive -split-package:=(merge-first|merge-last|error|first) on Export/Private Package instruction to get rid of this warning\n" + "Package found in   " + culprits + "\n" + "Reference from     " + source + "\n" + "Classpath          " + classpath;
    }

    private int getSplitStrategy(String type) {
        if (type == null) {
            return 0;
        }
        if (type.equals("merge-last")) {
            return 1;
        }
        if (type.equals("merge-first")) {
            return 2;
        }
        if (type.equals("error")) {
            return 3;
        }
        if (type.equals("first")) {
            return 4;
        }
        this.error("Invalid strategy for split-package: " + type);
        return 0;
    }

    private Map<Instruction, Map<String, String>> replaceWithPattern(Map<String, Map<String, String>> header) {
        Map<Instruction, Map<String, String>> map = Builder.newMap();
        for (Map.Entry<String, Map<String, String>> entry : header.entrySet()) {
            String pattern = entry.getKey();
            Instruction instr = Instruction.getPattern(pattern);
            map.put(instr, entry.getValue());
        }
        return map;
    }

    private Instruction matches(Map<Instruction, Map<String, String>> instructions, String pack, Set<Instruction> superfluousPatterns) {
        for (Instruction pattern : instructions.keySet()) {
            if (!pattern.matches(pack)) continue;
            superfluousPatterns.remove(pattern);
            return pattern;
        }
        return null;
    }

    private Map<String, Map<String, String>> getHeader(String string) {
        if (string == null) {
            return Collections.emptyMap();
        }
        return this.parseHeader(this.getProperty(string));
    }

    private void doIncludeResources(Jar jar) throws Exception {
        String includes = this.getProperty("Bundle-Includes");
        if (includes == null) {
            includes = this.getProperty("Include-Resource");
        } else {
            this.warning("Please use Include-Resource instead of Bundle-Includes");
        }
        if (includes == null) {
            return;
        }
        Map<String, Map<String, String>> clauses = this.parseHeader(includes);
        for (Map.Entry<String, Map<String, String>> entry : clauses.entrySet()) {
            this.doIncludeResource(jar, entry.getKey(), entry.getValue());
        }
    }

    private void doIncludeResource(Jar jar, String name, Map<String, String> extra) throws ZipException, IOException, Exception {
        boolean preprocess = false;
        if (name.startsWith("{") && name.endsWith("}")) {
            preprocess = true;
            name = name.substring(1, name.length() - 1).trim();
        }
        if (name.startsWith("@")) {
            this.extractFromJar(jar, name.substring(1));
        } else if (extra.containsKey("literal")) {
            String literal = extra.get("literal");
            EmbeddedResource r = new EmbeddedResource(literal.getBytes("UTF-8"), 0L);
            String x = extra.get("extra");
            if (x != null) {
                r.setExtra(x);
            }
            jar.putResource(name, r);
        } else {
            String destinationPath;
            File sourceFile;
            String source;
            String[] parts = name.split("\\s*=\\s*");
            if (parts.length == 1) {
                source = parts[0];
                sourceFile = this.getFile(source);
                destinationPath = sourceFile.isDirectory() ? "" : sourceFile.getName();
            } else {
                source = parts[1];
                sourceFile = this.getFile(source);
                destinationPath = parts[0];
            }
            if (destinationPath.endsWith("/")) {
                destinationPath = destinationPath.substring(0, destinationPath.length() - 1);
            }
            if (!sourceFile.exists()) {
                this.noSuchFile(jar, name, extra, source, destinationPath);
            } else {
                this.copy(jar, destinationPath, sourceFile, preprocess, extra);
            }
        }
    }

    private void noSuchFile(Jar jar, String clause, Map<String, String> extra, String source, String destinationPath) throws Exception {
        Jar src = this.getJarFromName(source, "Include-Resource " + source);
        if (src != null) {
            JarResource jarResource = new JarResource(src);
            jar.putResource(destinationPath, jarResource);
        } else {
            Resource lastChance = this.make.process(source);
            if (lastChance != null) {
                jar.putResource(destinationPath, lastChance);
            } else {
                this.error("Input file does not exist: " + source);
            }
        }
    }

    private void extractFromJar(Jar jar, String name) throws ZipException, IOException {
        Jar sub;
        int n = name.lastIndexOf("!/");
        Pattern filter = null;
        if (n > 0) {
            String fstring = name.substring(n + 2);
            name = name.substring(0, n);
            filter = this.wildcard(fstring);
        }
        if ((sub = this.getJarFromName(name, "extract from jar")) == null) {
            this.error("Can not find JAR file " + name);
        } else {
            jar.addAll(sub, filter);
        }
    }

    private Pattern wildcard(String spec) {
        StringBuffer sb = new StringBuffer();
        int j = 0;
        while (j < spec.length()) {
            char c = spec.charAt(j);
            switch (c) {
                case '.': {
                    sb.append("\\.");
                    break;
                }
                case '*': {
                    if (j < spec.length() - 1 && spec.charAt(j + 1) == '*') {
                        sb.append(".*");
                        ++j;
                        break;
                    }
                    sb.append("[^/]*");
                    break;
                }
                default: {
                    sb.append(c);
                }
            }
            ++j;
        }
        String s = sb.toString();
        try {
            return Pattern.compile(s);
        }
        catch (Exception e) {
            this.error("Invalid regular expression on wildcarding: " + spec + " used *");
            return null;
        }
    }

    private void copy(Jar jar, String path, File from, boolean preprocess, Map<String, String> extra) throws Exception {
        if (doNotCopy.matcher(from.getName()).matches()) {
            return;
        }
        if (from.isDirectory()) {
            String next = path;
            if (next.length() != 0) {
                next = String.valueOf(next) + '/';
            }
            File[] files = from.listFiles();
            int i = 0;
            while (i < files.length) {
                this.copy(jar, String.valueOf(next) + files[i].getName(), files[i], preprocess, extra);
                ++i;
            }
        } else if (from.exists()) {
            Resource resource = new FileResource(from);
            if (preprocess) {
                resource = new PreprocessResource(this, resource);
            }
            jar.putResource(path, resource);
        } else {
            this.error("Input file does not exist: " + from);
        }
    }

    private String getName(String where) {
        int n = where.lastIndexOf(47);
        if (n < 0) {
            return where;
        }
        return where.substring(n + 1);
    }

    public void setSourcepath(File[] files) {
        int i = 0;
        while (i < files.length) {
            this.addSourcepath(files[i]);
            ++i;
        }
    }

    public void addSourcepath(File cp) {
        if (!cp.exists()) {
            this.warning("File on sourcepath that does not exist: " + cp);
        }
        this.sourcePath.add(cp);
    }

    public void doPom(Jar dot) throws FileNotFoundException, IOException {
        Manifest manifest = dot.getManifest();
        String name = manifest.getMainAttributes().getValue("Bundle-Name");
        String description = manifest.getMainAttributes().getValue("Bundle-Description");
        String docUrl = manifest.getMainAttributes().getValue("Bundle-DocURL");
        String version = manifest.getMainAttributes().getValue("Bundle-Version");
        String bundleVendor = manifest.getMainAttributes().getValue("Bundle-Vendor");
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(s);
        String bsn = manifest.getMainAttributes().getValue("Bundle-SymbolicName");
        String licenses = manifest.getMainAttributes().getValue("Bundle-License");
        if (bsn == null) {
            this.error("Can not create POM unless Bundle-SymbolicName is set");
            return;
        }
        int n = (bsn = bsn.trim()).lastIndexOf(46);
        if (n <= 0) {
            this.error("Can not create POM unless Bundle-SymbolicName contains a .");
            ps.close();
            s.close();
            return;
        }
        String groupId = bsn.substring(0, n);
        String artifactId = bsn.substring(n + 1);
        ps.println("<project xmlns='http://maven.apache.org/POM/4.0.0' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xsi:schemaLocation='http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd'>");
        ps.println("  <modelVersion>4.0.0</modelVersion>");
        ps.println("  <groupId>" + groupId + "</groupId>");
        n = artifactId.indexOf(59);
        if (n > 0) {
            artifactId = artifactId.substring(0, n).trim();
        }
        ps.println("  <artifactId>" + artifactId + "</artifactId>");
        ps.println("  <version>" + version + "</version>");
        if (description != null) {
            ps.println("  <description>");
            ps.print("    ");
            ps.println(description);
            ps.println("  </description>");
        }
        if (name != null) {
            ps.print("  <name>");
            ps.print(name);
            ps.println("</name>");
        }
        if (docUrl != null) {
            ps.print("  <url>");
            ps.print(docUrl);
            ps.println("</url>");
        }
        if (bundleVendor != null) {
            Matcher m = this.NAME_URL.matcher(bundleVendor);
            String namePart = bundleVendor;
            String urlPart = null;
            if (m.matches()) {
                namePart = m.group(1);
                urlPart = m.group(2);
            }
            ps.println("  <organization>");
            ps.print("    <name>");
            ps.print(namePart.trim());
            ps.println("</name>");
            if (urlPart != null) {
                ps.print("    <url>");
                ps.print(urlPart.trim());
                ps.println("</url>");
            }
            ps.println("  </organization>");
        }
        if (licenses != null) {
            ps.println("  <licenses>");
            Map<String, Map<String, String>> map = this.parseHeader(licenses);
            for (Map.Entry<String, Map<String, String>> entry : map.entrySet()) {
                ps.println("    <license>");
                Map<String, String> values = entry.getValue();
                this.print(ps, values, "name", "name", values.get("url"));
                this.print(ps, values, "url", "url", null);
                this.print(ps, values, "distribution", "distribution", "repo");
                ps.println("    </license>");
            }
            ps.println("  </licenses>");
        }
        ps.println("</project>");
        ps.close();
        s.close();
        dot.putResource("pom.xml", new EmbeddedResource(s.toByteArray(), 0L));
    }

    private void print(PrintStream ps, Map<String, String> values, String string, String tag, String object) {
        String value = values.get(string);
        if (value == null) {
            value = object;
        }
        if (value == null) {
            return;
        }
        ps.println("    <" + tag + ">" + value.trim() + "</" + tag + ">");
    }

    @Override
    public void close() {
        super.close();
    }

    public Jar[] builds() throws Exception {
        this.begin();
        String conduit = this.getProperty("-conduit");
        if (conduit != null) {
            Map<String, Map<String, String>> map = this.parseHeader(conduit);
            Jar[] result = new Jar[map.size()];
            int n = 0;
            for (String file : map.keySet()) {
                Jar c = new Jar(this.getFile(file));
                this.addClose(c);
                Map<String, String> sub = map.get(file);
                String name = sub.get("name");
                if (name != null) {
                    c.setName(name);
                }
                result[n++] = c;
            }
            return result;
        }
        String sub = this.getProperty("-sub");
        if (sub == null) {
            Jar jar = this.build();
            if (jar == null) {
                return new Jar[0];
            }
            return new Jar[]{jar};
        }
        ArrayList<Jar> result = new ArrayList<Jar>();
        Set<Instruction> subs = this.replaceWithPattern(this.parseHeader(sub)).keySet();
        ArrayList members = new ArrayList(Arrays.asList(this.getBase().listFiles()));
        Jar[] cp = this.getClasspath().toArray(new Jar[0]);
        this.getProperties().remove("-sub");
        block3: while (members.size() > 0) {
            File file = (File)members.remove(0);
            if (file.equals(this.getPropertiesFile())) continue;
            for (Instruction instruction : subs) {
                if (!instruction.matches(file.getName())) continue;
                if (instruction.isNegated()) continue block3;
                Builder builder = null;
                try {
                    builder = this.getSubBuilder();
                    this.addClose(builder);
                    builder.setProperties(file);
                    builder.setClasspath(cp);
                    builder.setProperty("-sub", "");
                    Jar jar = builder.build();
                    jar.setName(builder.getBsn());
                    result.add(jar);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.error("Sub Building " + file, e);
                }
                if (builder == null) continue block3;
                this.getInfo(builder, String.valueOf(file.getName()) + ": ");
                continue block3;
            }
        }
        this.setProperty("-sub", sub);
        return result.toArray(new Jar[result.size()]);
    }

    protected Builder getSubBuilder() throws Exception {
        return new Builder(this);
    }

    public String _maven_version(String[] args) {
        if (args.length > 2) {
            this.error("${maven_version} macro receives too many arguments " + Arrays.toString(args));
        } else if (args.length < 2) {
            this.error("${maven_version} macro has no arguments, use ${maven_version;1.2.3-SNAPSHOT}");
        } else {
            return Builder.cleanupVersion(args[1]);
        }
        return null;
    }

    public String _classes(String[] args) {
        HashSet matched = new HashSet(this.classspace.values());
        int i = 1;
        while (i < args.length) {
            if (args.length < i + 1) {
                throw new IllegalArgumentException("${classes} macro must have odd number of arguments. " + _classesHelp);
            }
            String typeName = args[i];
            Clazz.QUERY type = null;
            if (typeName.equals("implementing") || typeName.equals("implements")) {
                type = Clazz.QUERY.IMPLEMENTS;
            } else if (typeName.equals("extending") || typeName.equals("extends")) {
                type = Clazz.QUERY.EXTENDS;
            } else if (typeName.equals("importing") || typeName.equals("imports")) {
                type = Clazz.QUERY.IMPORTS;
            } else if (typeName.equals("all")) {
                type = Clazz.QUERY.ANY;
            } else if (typeName.equals("version")) {
                type = Clazz.QUERY.VERSION;
            } else if (typeName.equals("named")) {
                type = Clazz.QUERY.NAMED;
            }
            if (type == null) {
                throw new IllegalArgumentException("${classes} has invalid type: " + typeName + ". " + _classesHelp);
            }
            String pattern = args[i + 1].replace('.', '/');
            Instruction instr = Instruction.getPattern(pattern);
            Iterator c = matched.iterator();
            while (c.hasNext()) {
                Clazz clazz = (Clazz)c.next();
                if (clazz.is(type, instr, this.classspace)) continue;
                c.remove();
            }
            i += 2;
        }
        if (matched.isEmpty()) {
            return "";
        }
        return Builder.join(matched);
    }

    public String _exporters(String[] args) throws Exception {
        Macro.verifyCommand(args, "${exporters;<packagename>}, returns the list of jars that export the given package", null, 2, 2);
        StringBuilder sb = new StringBuilder();
        String del = "";
        String pack = args[1].replace('.', '/');
        for (Jar jar : this.classpath) {
            if (!jar.getDirectories().containsKey(pack)) continue;
            sb.append(del);
            sb.append(jar.getName());
        }
        return sb.toString();
    }
}

