/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.generators;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaExceptionClass;
import org.apache.cxf.tools.common.model.JavaField;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.generators.AbstractJAXWSGenerator;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.ProcessorUtil;

public class FaultGenerator
extends AbstractJAXWSGenerator {
    private static final String FAULT_TEMPLATE = "org/apache/cxf/tools/wsdlto/frontend/jaxws/template/fault.vm";

    public FaultGenerator() {
        this.name = "fault.generator";
    }

    public boolean passthrough() {
        if (this.env.optionSet("genFault") || this.env.optionSet("all")) {
            return false;
        }
        return this.env.optionSet("genAnt") || this.env.optionSet("genTypes") || this.env.optionSet("genClient") || this.env.optionSet("genImpl") || this.env.optionSet("genSEI") || this.env.optionSet("genServer") || this.env.optionSet("genService");
    }

    public void generate(ToolContext penv) throws ToolException {
        this.env = penv;
        JavaModel javaModel = this.env.get(JavaModel.class);
        if (this.passthrough()) {
            return;
        }
        Map<String, JavaExceptionClass> exceptionClasses = javaModel.getExceptionClasses();
        for (String expClassName : exceptionClasses.keySet()) {
            JavaExceptionClass expClz = exceptionClasses.get(expClassName);
            this.clearAttributes();
            this.setAttributes("suid", this.getSUID());
            this.setAttributes("expClass", expClz);
            for (JavaField jf : expClz.getFields()) {
                this.setAttributes("paraName", ProcessorUtil.mangleNameToVariableName(jf.getName()));
            }
            this.setCommonAttributes();
            this.doWrite(FAULT_TEMPLATE, this.parseOutputName(expClz.getPackageName(), expClz.getName()));
        }
    }

    private String getSUID() {
        return new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
    }

    public void register(ClassCollector collector, String packageName, String fileName) {
        collector.addExceptionClassName(packageName, fileName, packageName + "." + fileName);
    }
}

