/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.response.DispositionReport;
import org.apache.juddi.error.AuthTokenRequiredException;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RegistryExceptionHandler
extends AbstractHandler {
    public static final String TAG_NAME = "fault";
    private HandlerMaker maker = null;

    protected RegistryExceptionHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        Vector nodeList = null;
        AbstractHandler handler = null;
        String fCode = null;
        nodeList = XMLUtils.getChildElementsByTagName(element, "faultcode");
        if (nodeList.size() > 0) {
            fCode = XMLUtils.getText((Element)nodeList.elementAt(0));
        }
        String fString = null;
        nodeList = XMLUtils.getChildElementsByTagName(element, "faultstring");
        if (nodeList.size() > 0) {
            fString = XMLUtils.getText((Element)nodeList.elementAt(0));
        }
        String fActor = null;
        nodeList = XMLUtils.getChildElementsByTagName(element, "faultactor");
        if (nodeList.size() > 0) {
            fActor = XMLUtils.getText((Element)nodeList.elementAt(0));
        }
        DispositionReport dispRpt = null;
        nodeList = XMLUtils.getChildElementsByTagName(element, "detail");
        if (nodeList.size() > 0 && (nodeList = XMLUtils.getChildElementsByTagName((Element)nodeList.elementAt(0), "dispositionReport")).size() > 0) {
            handler = this.maker.lookup("dispositionReport");
            dispRpt = (DispositionReport)handler.unmarshal((Element)nodeList.elementAt(0));
        }
        RegistryException obj = new RegistryException(fCode, fString, fActor, dispRpt);
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        DispositionReport dispRpt;
        String fString;
        RegistryException regEx = (RegistryException)object;
        Document document = parent.getOwnerDocument();
        String generic = this.getGeneric(null);
        String namespace = this.getUDDINamespace(generic);
        Element fault = document.createElementNS(namespace, TAG_NAME);
        String fCode = regEx.getFaultCode();
        if (fCode != null) {
            Element fCodeElement = document.createElement("faultcode");
            fCodeElement.appendChild(document.createTextNode(fCode));
            fault.appendChild(fCodeElement);
        }
        if ((fString = regEx.getFaultString()) == null) {
            fString = "";
        }
        Element fStringElement = document.createElement("faultstring");
        fStringElement.appendChild(document.createTextNode(fString));
        fault.appendChild(fStringElement);
        String fActor = regEx.getFaultActor();
        if (fActor != null) {
            Element fActorElement = document.createElement("faultactor");
            fActorElement.appendChild(document.createTextNode(fActor));
            fault.appendChild(fActorElement);
        }
        if ((dispRpt = regEx.getDispositionReport()) != null) {
            Element fDetailElement = document.createElement("detail");
            AbstractHandler handler = this.maker.lookup("dispositionReport");
            handler.marshal(dispRpt, fDetailElement);
            fault.appendChild(fDetailElement);
        }
        parent.appendChild(fault);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        AuthTokenRequiredException regex = new AuthTokenRequiredException("Test Exception");
        System.out.println();
        RegistryObject regObject = regex;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
    }
}

