/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.registry.infomodel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.UnsupportedCapabilityException;
import javax.xml.registry.infomodel.ClassificationScheme;
import javax.xml.registry.infomodel.Concept;
import org.apache.ws.scout.registry.infomodel.ConceptImpl;
import org.apache.ws.scout.registry.infomodel.RegistryEntryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassificationSchemeImpl
extends RegistryEntryImpl
implements ClassificationScheme {
    private Collection<Concept> childConcepts = new ArrayList<Concept>();
    private boolean external = false;

    public ClassificationSchemeImpl(LifeCycleManager lifeCycleManager) {
        super(lifeCycleManager);
    }

    @Override
    public void addChildConcept(Concept concept) throws JAXRException {
        this.childConcepts.add(concept);
    }

    public void addChildConcepts(Collection<Concept> collection) throws JAXRException {
        this.childConcepts.addAll(collection);
    }

    @Override
    public int getChildConceptCount() throws JAXRException {
        return this.childConcepts.size();
    }

    @Override
    public Collection getChildrenConcepts() throws JAXRException {
        return this.childConcepts;
    }

    @Override
    public Collection getDescendantConcepts() throws JAXRException {
        ArrayList<Concept> coll = new ArrayList<Concept>();
        Iterator<Concept> iter = this.childConcepts.iterator();
        while (iter != null && iter.hasNext()) {
            ConceptImpl c = (ConceptImpl)iter.next();
            coll.add(c);
            coll.addAll(c.getDescendantConcepts());
        }
        return coll;
    }

    @Override
    public int getValueType() throws JAXRException {
        throw new UnsupportedCapabilityException();
    }

    protected void setExternal(boolean b) {
        this.external = b;
    }

    @Override
    public boolean isExternal() throws JAXRException {
        return this.external;
    }

    @Override
    public void removeChildConcept(Concept concept) throws JAXRException {
        this.childConcepts.remove(concept);
    }

    @Override
    public void removeChildConcepts(Collection collection) throws JAXRException {
        this.childConcepts.removeAll(collection);
    }

    @Override
    public void setValueType(int param) throws JAXRException {
        throw new UnsupportedCapabilityException();
    }
}

