/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.expressions;

import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.expressions.ExpressionSQLPrinter;
import org.eclipse.persistence.internal.expressions.ForUpdateClause;
import org.eclipse.persistence.internal.expressions.ObjectExpression;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;

public class ForUpdateOfClause
extends ForUpdateClause {
    protected Vector lockedExpressions;

    public void addLockedExpression(ObjectExpression expression) {
        this.getLockedExpressions().addElement(expression);
    }

    public Vector getLockedExpressions() {
        if (this.lockedExpressions == null) {
            this.lockedExpressions = NonSynchronizedVector.newInstance();
        }
        return this.lockedExpressions;
    }

    public boolean isForUpdateOfClause() {
        return true;
    }

    public boolean isReferenceClassLocked() {
        if (this.lockedExpressions == null) {
            return false;
        }
        for (int i = 0; i < this.lockedExpressions.size(); ++i) {
            if (!((Expression)this.lockedExpressions.elementAt(i)).isExpressionBuilder()) continue;
            return true;
        }
        return false;
    }

    public void setLockedExpressions(Vector lockedExpressions) {
        this.lockedExpressions = lockedExpressions;
    }

    public void setLockMode(short lockMode) {
        this.lockMode = lockMode;
    }

    public void printSQL(ExpressionSQLPrinter printer, SQLSelectStatement statement) {
        if (printer.getSession().getPlatform().shouldPrintLockingClauseAfterWhereClause()) {
            ExpressionBuilder clonedBuilder = statement.getBuilder();
            printer.printString(printer.getSession().getPlatform().getSelectForUpdateOfString());
            printer.setIsFirstElementPrinted(false);
            Enumeration enumtr = this.getLockedExpressions().elements();
            while (enumtr.hasMoreElements()) {
                ObjectExpression next = (ObjectExpression)enumtr.nextElement();
                next = (ObjectExpression)next.rebuildOn(clonedBuilder);
                next.writeForUpdateOfFields(printer, statement);
            }
            if (this.lockMode == 2) {
                printer.printString(printer.getSession().getPlatform().getNoWaitString());
            }
        } else {
            super.printSQL(printer, statement);
        }
    }

    public Collection getAliasesOfTablesToBeLocked(SQLSelectStatement statement) {
        int expected = statement.getTableAliases().size();
        HashSet<DatabaseTable> aliases = new HashSet<DatabaseTable>(expected);
        ExpressionBuilder clonedBuilder = statement.getBuilder();
        Enumeration enumtr = this.getLockedExpressions().elements();
        while (enumtr.hasMoreElements() && aliases.size() < expected) {
            ObjectExpression next = (ObjectExpression)enumtr.nextElement();
            next = (ObjectExpression)next.rebuildOn(clonedBuilder);
            DatabaseTable[] expAliases = next.getTableAliases().keys();
            for (int i = 0; i < expAliases.length; ++i) {
                aliases.add(expAliases[i]);
            }
        }
        return aliases;
    }
}

