/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.identitymaps;

import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConcurrencyManager;
import org.eclipse.persistence.internal.helper.DeferredLockManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.InvalidObject;
import org.eclipse.persistence.internal.helper.WriteLockManager;
import org.eclipse.persistence.internal.identitymaps.CacheIdentityMap;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.identitymaps.IdentityMap;
import org.eclipse.persistence.internal.identitymaps.UnitOfWorkIdentityMap;
import org.eclipse.persistence.internal.identitymaps.WeakUnitOfWorkIdentityMap;
import org.eclipse.persistence.internal.localization.LoggingLocalization;
import org.eclipse.persistence.internal.localization.TraceLocalization;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedGetConstructorFor;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadQuery;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.factories.ReferenceMode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityMapManager
implements Serializable,
Cloneable {
    protected ConcurrentMap<Class, IdentityMap> identityMaps;
    protected Map queryResults;
    protected AbstractSession session;
    protected transient ConcurrencyManager cacheMutex;
    protected IdentityMap lastAccessedIdentityMap = null;
    protected transient WriteLockManager writeLockManager;
    protected Boolean isCacheAccessPreCheckRequired;

    public IdentityMapManager(AbstractSession session) {
        this.session = session;
        this.cacheMutex = new ConcurrencyManager();
        this.identityMaps = new ConcurrentHashMap<Class, IdentityMap>();
        if (!session.isUnitOfWork()) {
            this.queryResults = new ConcurrentHashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireDeferredLock(Vector primaryKey, Class domainClass, ClassDescriptor descriptor) {
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = this.getIdentityMap(descriptor).acquireDeferredLock(primaryKey);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            cacheKey = this.getIdentityMap(descriptor).acquireDeferredLock(primaryKey);
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireLock(Vector primaryKey, Class domainClass, boolean forMerge, ClassDescriptor descriptor) {
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = this.getIdentityMap(descriptor).acquireLock(primaryKey, forMerge);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            cacheKey = this.getIdentityMap(descriptor).acquireLock(primaryKey, forMerge);
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireLockNoWait(Vector primaryKey, Class domainClass, boolean forMerge, ClassDescriptor descriptor) {
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = this.getIdentityMap(descriptor).acquireLockNoWait(primaryKey, forMerge);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            cacheKey = this.getIdentityMap(descriptor).acquireLockNoWait(primaryKey, forMerge);
        }
        return cacheKey;
    }

    protected boolean isCacheAccessPreCheckRequired() {
        if (this.isCacheAccessPreCheckRequired == null) {
            this.isCacheAccessPreCheckRequired = this.getSession().getProfiler() != null || this.getSession().getDatasourceLogin().shouldSynchronizedReadOnWrite() ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.isCacheAccessPreCheckRequired;
    }

    public void clearCacheAccessPreCheck() {
        this.isCacheAccessPreCheckRequired = null;
    }

    public void acquireReadLock() {
        this.getSession().startOperationProfile("cache");
        if (this.getSession().getDatasourceLogin().shouldSynchronizedReadOnWrite()) {
            this.getCacheMutex().acquireReadLock();
        }
        this.getSession().endOperationProfile("cache");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireReadLockOnCacheKey(Vector primaryKey, Class domainClass, ClassDescriptor descriptor) {
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = this.getIdentityMap(descriptor).acquireReadLockOnCacheKey(primaryKey);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            cacheKey = this.getIdentityMap(descriptor).acquireReadLockOnCacheKey(primaryKey);
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey acquireReadLockOnCacheKeyNoWait(Vector primaryKey, Class domainClass, ClassDescriptor descriptor) {
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = this.getIdentityMap(descriptor).acquireReadLockOnCacheKeyNoWait(primaryKey);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            cacheKey = this.getIdentityMap(descriptor).acquireReadLockOnCacheKeyNoWait(primaryKey);
        }
        return cacheKey;
    }

    public boolean acquireWriteLock() {
        if (this.getSession().getDatasourceLogin().shouldSynchronizedReadOnWrite() || this.getSession().getDatasourceLogin().shouldSynchronizeWrites()) {
            this.getCacheMutex().acquire();
            return true;
        }
        return false;
    }

    public IdentityMap buildNewIdentityMap(ClassDescriptor descriptor) throws ValidationException, DescriptorException {
        if (this.getSession().isUnitOfWork()) {
            if (((UnitOfWorkImpl)this.getSession()).getReferenceMode() == ReferenceMode.FORCE_WEAK) {
                return new WeakUnitOfWorkIdentityMap(32, descriptor);
            }
            if (((UnitOfWorkImpl)this.getSession()).getReferenceMode() == ReferenceMode.WEAK && descriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
                return new WeakUnitOfWorkIdentityMap(32, descriptor);
            }
            return new UnitOfWorkIdentityMap(32, descriptor);
        }
        try {
            if (this.getSession().isRemoteSession()) {
                Constructor constructor = null;
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(descriptor.getRemoteIdentityMapClass(), new Class[]{ClassConstants.PINT, ClassDescriptor.class}, false));
                        IdentityMap map = (IdentityMap)AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, new Object[]{new Integer(descriptor.getRemoteIdentityMapSize()), descriptor}));
                        if (descriptor.getCacheInterceptorClass() != null) {
                            constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(descriptor.getCacheInterceptorClass(), new Class[]{IdentityMap.class, AbstractSession.class}, false));
                            Object[] params = new Object[]{map, this.getSession()};
                            map = (IdentityMap)AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, params));
                        }
                        return map;
                    }
                    catch (PrivilegedActionException exception) {
                        throw DescriptorException.invalidIdentityMap(descriptor, exception.getException());
                    }
                }
                constructor = PrivilegedAccessHelper.getConstructorFor(descriptor.getRemoteIdentityMapClass(), new Class[]{ClassConstants.PINT, ClassDescriptor.class}, false);
                IdentityMap map = (IdentityMap)PrivilegedAccessHelper.invokeConstructor(constructor, new Object[]{new Integer(descriptor.getRemoteIdentityMapSize()), descriptor});
                if (descriptor.getCacheInterceptorClass() != null) {
                    constructor = PrivilegedAccessHelper.getConstructorFor(descriptor.getCacheInterceptorClass(), new Class[]{IdentityMap.class, AbstractSession.class}, false);
                    Object[] params = new Object[]{map, this.getSession()};
                    map = (IdentityMap)PrivilegedAccessHelper.invokeConstructor(constructor, params);
                }
                return map;
            }
            Constructor constructor = null;
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(descriptor.getIdentityMapClass(), new Class[]{ClassConstants.PINT, ClassDescriptor.class}, false));
                    IdentityMap map = (IdentityMap)AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, new Object[]{new Integer(descriptor.getIdentityMapSize()), descriptor}));
                    if (descriptor.getCacheInterceptorClass() != null) {
                        constructor = (Constructor)AccessController.doPrivileged(new PrivilegedGetConstructorFor(descriptor.getCacheInterceptorClass(), new Class[]{IdentityMap.class, AbstractSession.class}, false));
                        Object[] params = new Object[]{map, this.getSession()};
                        map = (IdentityMap)AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, params));
                    }
                    return map;
                }
                catch (PrivilegedActionException exception) {
                    throw DescriptorException.invalidIdentityMap(descriptor, exception.getException());
                }
            }
            constructor = PrivilegedAccessHelper.getConstructorFor(descriptor.getIdentityMapClass(), new Class[]{ClassConstants.PINT, ClassDescriptor.class}, false);
            IdentityMap map = (IdentityMap)PrivilegedAccessHelper.invokeConstructor(constructor, new Object[]{new Integer(descriptor.getIdentityMapSize()), descriptor});
            if (descriptor.getCacheInterceptorClass() != null) {
                constructor = PrivilegedAccessHelper.getConstructorFor(descriptor.getCacheInterceptorClass(), new Class[]{IdentityMap.class, AbstractSession.class}, false);
                Object[] params = new Object[]{map, this.getSession()};
                map = (IdentityMap)PrivilegedAccessHelper.invokeConstructor(constructor, params);
            }
            return map;
        }
        catch (Exception exception) {
            throw DescriptorException.invalidIdentityMap(descriptor, exception);
        }
    }

    public void clearLastAccessedIdentityMap() {
        this.lastAccessedIdentityMap = null;
    }

    public Object clone() {
        IdentityMapManager manager = null;
        try {
            manager = (IdentityMapManager)super.clone();
            manager.setIdentityMaps(new ConcurrentHashMap());
            for (Map.Entry entry : this.getIdentityMaps().entrySet()) {
                manager.getIdentityMaps().put((Class)entry.getKey(), (IdentityMap)((IdentityMap)entry.getValue()).clone());
            }
        }
        catch (CloneNotSupportedException exception) {
            throw new InternalError(exception.toString());
        }
        return manager;
    }

    public void clearQueryCache() {
        this.queryResults = new ConcurrentHashMap();
    }

    public void clearQueryCache(ReadQuery query) {
        if (query != null) {
            this.queryResults.remove(query);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(Vector key, Class theClass, ClassDescriptor descriptor) {
        int size = key.size();
        for (int index = 0; index < size; ++index) {
            if (key.get(index) != null) continue;
            return false;
        }
        IdentityMap map = this.getIdentityMap(descriptor);
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                boolean bl = map.containsKey(key);
                return bl;
            }
            finally {
                this.releaseReadLock();
                this.getSession().endOperationProfile("cache");
            }
        }
        return map.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector getAllFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow, int valueHolderPolicy, boolean shouldReturnInvalidatedObjects) {
        ClassDescriptor descriptor = this.getSession().getDescriptor(theClass);
        this.getSession().startOperationProfile("cache");
        Vector<Object> objects = null;
        try {
            ExpressionBuilder builder;
            if (selectionCriteria != null && (builder = selectionCriteria.getBuilder()).getSession() == null) {
                builder.setSession(this.getSession().getRootSession(null));
                builder.setQueryClass(theClass);
            }
            objects = new Vector<Object>();
            IdentityMap map = this.getIdentityMap(descriptor);
            long currentTimeInMillis = System.currentTimeMillis();
            Enumeration cacheEnum = map.keys();
            while (cacheEnum.hasMoreElements()) {
                Object object;
                CacheKey key = (CacheKey)cacheEnum.nextElement();
                if (key.getObject() == null || !shouldReturnInvalidatedObjects && descriptor.getCacheInvalidationPolicy().isInvalidated(key, currentTimeInMillis) || (object = key.getObject()) == null || object.getClass() != theClass && !theClass.isInstance(object)) continue;
                if (selectionCriteria == null) {
                    objects.add(object);
                    this.getSession().incrementProfile("CacheHits");
                    continue;
                }
                try {
                    if (!selectionCriteria.doesConform(object, this.getSession(), (AbstractRecord)translationRow, valueHolderPolicy)) continue;
                    objects.addElement(object);
                    this.getSession().incrementProfile("CacheHits");
                }
                catch (QueryException queryException) {
                    if (queryException.getErrorCode() != 6092) throw queryException;
                    if (valueHolderPolicy == 2) {
                        objects.add(object);
                        this.getSession().incrementProfile("CacheHits");
                        continue;
                    }
                    if (valueHolderPolicy != 0) continue;
                    throw queryException;
                    return objects;
                }
            }
        }
        finally {
            this.getSession().endOperationProfile("cache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey getCacheKeyForObject(Vector primaryKey, Class theClass, ClassDescriptor descriptor) {
        IdentityMap map = this.getIdentityMap(descriptor);
        CacheKey cacheKey = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = map.getCacheKey(primaryKey);
            }
            finally {
                this.releaseReadLock();
                this.getSession().endOperationProfile("cache");
            }
        } else {
            cacheKey = map.getCacheKey(primaryKey);
        }
        return cacheKey;
    }

    public ConcurrencyManager getCacheMutex() {
        return this.cacheMutex;
    }

    public Vector getClassesRegistered() {
        Iterator classes = this.getIdentityMaps().keySet().iterator();
        Vector<String> results = new Vector<String>(this.getIdentityMaps().size());
        while (classes.hasNext()) {
            results.add(((Class)classes.next()).getName());
        }
        return results;
    }

    public Object getFromIdentityMap(Object object) {
        ClassDescriptor descriptor = this.getSession().getDescriptor(object);
        Vector primaryKey = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this.getSession());
        return this.getFromIdentityMap(primaryKey, object.getClass(), descriptor);
    }

    public Object getFromIdentityMap(Vector key, Class theClass, ClassDescriptor descriptor) {
        return this.getFromIdentityMap(key, theClass, true, descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFromIdentityMap(Vector key, Class theClass, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        CacheKey cacheKey;
        if (key == null) {
            return null;
        }
        IdentityMap map = this.getIdentityMap(descriptor);
        Object domainObject = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = map.getCacheKey(key);
            }
            finally {
                this.releaseReadLock();
            }
        } else {
            cacheKey = map.getCacheKey(key);
        }
        if (cacheKey != null && (shouldReturnInvalidatedObjects || !descriptor.getCacheInvalidationPolicy().isInvalidated(cacheKey))) {
            domainObject = cacheKey.getObject();
            cacheKey.checkReadLock();
            domainObject = this.checkForInheritance(domainObject, theClass, descriptor);
        }
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().endOperationProfile("cache");
            if (domainObject == null) {
                this.getSession().incrementProfile("CacheMisses");
            } else {
                this.getSession().incrementProfile("CacheHits");
            }
        }
        return domainObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object getFromIdentityMap(Expression selectionCriteria, Class theClass, Record translationRow, int valueHolderPolicy, boolean conforming, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        UnitOfWorkImpl unitOfWork = conforming ? (UnitOfWorkImpl)this.getSession() : null;
        this.getSession().startOperationProfile("cache");
        try {
            ExpressionBuilder builder;
            if (selectionCriteria != null && (builder = selectionCriteria.getBuilder()).getSession() == null) {
                builder.setSession(this.getSession().getRootSession(null));
                builder.setQueryClass(theClass);
            }
            IdentityMap map = this.getIdentityMap(descriptor);
            long currentTimeInMillis = System.currentTimeMillis();
            Enumeration cacheEnum = map.keys();
            while (cacheEnum.hasMoreElements()) {
                Object object;
                CacheKey key = (CacheKey)cacheEnum.nextElement();
                if (!shouldReturnInvalidatedObjects && descriptor.getCacheInvalidationPolicy().isInvalidated(key, currentTimeInMillis) || (object = key.getObject()) == null || object.getClass() != theClass && !theClass.isInstance(object)) continue;
                if (!(selectionCriteria != null || conforming && unitOfWork.isObjectDeleted(object))) {
                    this.getSession().incrementProfile("CacheHits");
                    Object object2 = object;
                    this.getSession().endOperationProfile("cache");
                    return object2;
                }
                if (!selectionCriteria.doesConform(object, this.getSession(), (AbstractRecord)translationRow, valueHolderPolicy) || conforming && unitOfWork.isObjectDeleted(object)) continue;
                this.getSession().incrementProfile("CacheHits");
                Object object3 = object;
                this.getSession().endOperationProfile("cache");
                return object3;
            }
            return null;
        }
        finally {
            this.getSession().endOperationProfile("cache");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getFromIdentityMapWithDeferredLock(Vector key, Class theClass, boolean shouldReturnInvalidatedObjects, ClassDescriptor descriptor) {
        CacheKey cacheKey;
        if (key == null) {
            this.getSession().incrementProfile("CacheMisses");
            return null;
        }
        IdentityMap map = this.getIdentityMap(descriptor);
        Object domainObject = null;
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = map.getCacheKey(key);
            }
            finally {
                this.releaseReadLock();
            }
        } else {
            cacheKey = map.getCacheKey(key);
        }
        if (cacheKey != null && (shouldReturnInvalidatedObjects || !descriptor.getCacheInvalidationPolicy().isInvalidated(cacheKey))) {
            domainObject = cacheKey.getObject();
            cacheKey.checkDeferredLock();
            domainObject = this.checkForInheritance(domainObject, theClass, descriptor);
        }
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().endOperationProfile("cache");
            if (domainObject == null) {
                this.getSession().incrementProfile("CacheMisses");
            } else {
                this.getSession().incrementProfile("CacheHits");
            }
        }
        return domainObject;
    }

    public IdentityMap getIdentityMap(ClassDescriptor descriptor) {
        if (descriptor.hasInheritance()) {
            descriptor = descriptor.getInheritancePolicy().getRootParentDescriptor();
        }
        Class descriptorClass = descriptor.getJavaClass();
        IdentityMap tempMap = this.lastAccessedIdentityMap;
        if (tempMap != null && tempMap.getDescriptorClass() == descriptorClass) {
            return tempMap;
        }
        IdentityMap identityMap = (IdentityMap)this.getIdentityMaps().get(descriptorClass);
        if (identityMap == null) {
            IdentityMap newIdentityMap = this.buildNewIdentityMap(descriptor);
            identityMap = this.getIdentityMaps().putIfAbsent(descriptorClass, newIdentityMap);
            if (identityMap == null) {
                identityMap = newIdentityMap;
            }
        }
        this.lastAccessedIdentityMap = identityMap;
        return identityMap;
    }

    protected ConcurrentMap<Class, IdentityMap> getIdentityMaps() {
        return this.identityMaps;
    }

    public Iterator getIdentityMapClasses() {
        return this.getIdentityMaps().keySet().iterator();
    }

    public Object getQueryResult(ReadQuery query, Vector parameters, boolean shouldCheckExpiry) {
        CacheKey key;
        if (query.getQueryResultsCachePolicy() == null) {
            return null;
        }
        IdentityMap map = (IdentityMap)this.queryResults.get(query);
        if (map == null) {
            return null;
        }
        Vector lookupParameters = parameters;
        if (lookupParameters == null) {
            lookupParameters = new Vector();
        }
        if ((key = map.getCacheKey(lookupParameters)) == null || shouldCheckExpiry && query.getQueryResultsCachePolicy().getCacheInvalidationPolicy().isInvalidated(key)) {
            return null;
        }
        return key.getObject();
    }

    protected AbstractSession getSession() {
        return this.session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getWrapper(Vector primaryKey, Class theClass) {
        Object wrapper;
        ClassDescriptor descriptor = this.getSession().getDescriptor(theClass);
        IdentityMap map = this.getIdentityMap(descriptor);
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                wrapper = map.getWrapper(primaryKey);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            wrapper = map.getWrapper(primaryKey);
        }
        return wrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WriteLockManager getWriteLockManager() {
        IdentityMapManager identityMapManager = this;
        synchronized (identityMapManager) {
            if (this.writeLockManager == null) {
                this.writeLockManager = new WriteLockManager();
            }
        }
        return this.writeLockManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getWriteLockValue(Vector primaryKey, Class domainClass, ClassDescriptor descriptor) {
        Object value;
        IdentityMap map = this.getIdentityMap(descriptor);
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                value = map.getWriteLockValue(primaryKey);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            value = map.getWriteLockValue(primaryKey);
        }
        return value;
    }

    public void initializeIdentityMap(Class theClass) throws EclipseLinkException {
        ClassDescriptor descriptor = this.getSession().getDescriptor(theClass);
        if (descriptor == null) {
            throw ValidationException.missingDescriptor(String.valueOf(theClass));
        }
        if (descriptor.isChildDescriptor()) {
            throw ValidationException.childDescriptorsDoNotHaveIdentityMap();
        }
        Class javaClass = descriptor.getJavaClass();
        IdentityMap identityMap = this.buildNewIdentityMap(descriptor);
        this.getIdentityMaps().put(javaClass, identityMap);
        this.clearLastAccessedIdentityMap();
    }

    public void initializeIdentityMaps() {
        this.clearLastAccessedIdentityMap();
        this.setIdentityMaps(new ConcurrentHashMap());
        this.clearQueryCache();
    }

    public void printIdentityMap(Class businessClass) {
        String cr = Helper.cr();
        ClassDescriptor descriptor = this.getSession().getDescriptor(businessClass);
        int cacheCounter = 0;
        StringWriter writer = new StringWriter();
        if (descriptor.isAggregateDescriptor()) {
            return;
        }
        IdentityMap map = this.getIdentityMap(descriptor);
        writer.write(LoggingLocalization.buildMessage("identitymap_for", new Object[]{cr, Helper.getShortClassName(map.getClass()), Helper.getShortClassName(businessClass)}));
        if (descriptor.hasInheritance() && descriptor.getInheritancePolicy().isRootParentDescriptor()) {
            writer.write(LoggingLocalization.buildMessage("includes"));
            Vector childDescriptors = descriptor.getInheritancePolicy().getChildDescriptors();
            if (childDescriptors != null && childDescriptors.size() != 0) {
                Enumeration enum2 = childDescriptors.elements();
                writer.write(Helper.getShortClassName(((ClassDescriptor)enum2.nextElement()).getJavaClass()));
                while (enum2.hasMoreElements()) {
                    writer.write(", " + Helper.getShortClassName(((ClassDescriptor)enum2.nextElement()).getJavaClass()));
                }
            }
            writer.write(")");
        }
        Enumeration enumtr = map.keys();
        while (enumtr.hasMoreElements()) {
            CacheKey cacheKey = (CacheKey)enumtr.nextElement();
            Object object = cacheKey.getObject();
            if (!businessClass.isInstance(object)) continue;
            ++cacheCounter;
            if (object == null) {
                writer.write(LoggingLocalization.buildMessage("key_object_null", new Object[]{cr, cacheKey.getKey(), "\t"}));
                continue;
            }
            writer.write(LoggingLocalization.buildMessage("key_identity_hash_code_object", new Object[]{cr, cacheKey.getKey(), "\t", String.valueOf(System.identityHashCode(object)), object}));
        }
        writer.write(LoggingLocalization.buildMessage("elements", new Object[]{cr, String.valueOf(cacheCounter)}));
        this.getSession().log(7, "cache", writer.toString(), null, null, false);
    }

    public void printIdentityMaps() {
        for (Class businessClass : this.getSession().getDescriptors().keySet()) {
            ClassDescriptor descriptor = this.getSession().getDescriptor(businessClass);
            if (descriptor.hasInheritance()) {
                if (!descriptor.getInheritancePolicy().isRootParentDescriptor()) continue;
                this.printIdentityMap(businessClass);
                continue;
            }
            this.printIdentityMap(businessClass);
        }
    }

    public void printLocks() {
        StringWriter writer = new StringWriter();
        HashMap threadCollection = new HashMap();
        writer.write(TraceLocalization.buildMessage("lock_writer_header", null) + Helper.cr());
        for (IdentityMap idenityMap : this.session.getIdentityMapAccessorInstance().getIdentityMapManager().getIdentityMaps().values()) {
            idenityMap.collectLocks(threadCollection);
        }
        Object[] parameters = new Object[1];
        for (Thread activeThread : threadCollection.keySet()) {
            parameters[0] = activeThread.getName();
            writer.write(TraceLocalization.buildMessage("active_thread", parameters) + Helper.cr());
            for (CacheKey cacheKey : (HashSet)threadCollection.get(activeThread)) {
                parameters[0] = cacheKey.getObject();
                writer.write(TraceLocalization.buildMessage("locked_object", parameters) + Helper.cr());
                parameters[0] = new Integer(cacheKey.getMutex().getDepth());
                writer.write(TraceLocalization.buildMessage("depth", parameters) + Helper.cr());
            }
            DeferredLockManager deferredLockManager = ConcurrencyManager.getDeferredLockManager(activeThread);
            if (deferredLockManager == null) continue;
            for (ConcurrencyManager lock : deferredLockManager.getDeferredLocks()) {
                parameters[0] = lock.getOwnerCacheKey().getObject();
                writer.write(TraceLocalization.buildMessage("deferred_locks", parameters) + Helper.cr());
            }
        }
        writer.write(Helper.cr() + TraceLocalization.buildMessage("lock_writer_footer", null) + Helper.cr());
        this.getSession().log(1, "cache", writer.toString(), null, null, false);
    }

    public void printLocks(Class theClass) {
        ClassDescriptor descriptor = this.getSession().getDescriptor(theClass);
        StringWriter writer = new StringWriter();
        HashMap threadCollection = new HashMap();
        writer.write(TraceLocalization.buildMessage("lock_writer_header", null) + Helper.cr());
        IdentityMap identityMap = this.getIdentityMap(descriptor);
        identityMap.collectLocks(threadCollection);
        Object[] parameters = new Object[1];
        for (Thread activeThread : threadCollection.keySet()) {
            parameters[0] = activeThread.getName();
            writer.write(TraceLocalization.buildMessage("active_thread", parameters) + Helper.cr());
            for (CacheKey cacheKey : (HashSet)threadCollection.get(activeThread)) {
                parameters[0] = cacheKey.getObject();
                writer.write(TraceLocalization.buildMessage("locked_object", parameters) + Helper.cr());
                parameters[0] = new Integer(cacheKey.getMutex().getDepth());
                writer.write(TraceLocalization.buildMessage("depth", parameters) + Helper.cr());
            }
            DeferredLockManager deferredLockManager = ConcurrencyManager.getDeferredLockManager(activeThread);
            if (deferredLockManager == null) continue;
            for (ConcurrencyManager lock : deferredLockManager.getDeferredLocks()) {
                parameters[0] = lock.getOwnerCacheKey().getObject();
                writer.write(TraceLocalization.buildMessage("deferred_locks", parameters) + Helper.cr());
            }
        }
        writer.write(Helper.cr() + TraceLocalization.buildMessage("lock_writer_footer", null) + Helper.cr());
        this.getSession().log(1, "cache", writer.toString(), null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheKey putInIdentityMap(Object domainObject, Vector keys, Object writeLockValue, long readTime, ClassDescriptor descriptor) {
        CacheKey cacheKey;
        ObjectBuilder builder = descriptor.getObjectBuilder();
        Object implementation = builder.unwrapObject(domainObject, this.getSession());
        IdentityMap map = this.getIdentityMap(descriptor);
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                cacheKey = map.put(keys, implementation, writeLockValue, readTime);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            cacheKey = map.put(keys, implementation, writeLockValue, readTime);
        }
        return cacheKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putQueryResult(ReadQuery query, Vector parameters, Object results) {
        Vector lookupParameters;
        IdentityMap map = (IdentityMap)this.queryResults.get(query);
        if (map == null) {
            Map map2 = this.queryResults;
            synchronized (map2) {
                map = (IdentityMap)this.queryResults.get(query);
                if (map == null) {
                    map = new CacheIdentityMap(query.getQueryResultsCachePolicy().getMaximumCachedResults());
                    this.queryResults.put(query, map);
                }
            }
        }
        if ((lookupParameters = parameters) == null) {
            lookupParameters = new Vector();
        }
        long queryTime = 0L;
        if (query.isObjectLevelReadQuery()) {
            queryTime = ((ObjectLevelReadQuery)query).getExecutionTime();
        }
        if (queryTime == 0L) {
            queryTime = System.currentTimeMillis();
        }
        if (results == null) {
            results = InvalidObject.instance();
        }
        map.put(lookupParameters, results, null, queryTime);
    }

    protected void releaseReadLock() {
        if (this.getSession().getDatasourceLogin().shouldSynchronizedReadOnWrite()) {
            this.getCacheMutex().releaseReadLock();
        }
    }

    public void releaseWriteLock() {
        if (this.getSession().getDatasourceLogin().shouldSynchronizedReadOnWrite() || this.getSession().getDatasourceLogin().shouldSynchronizeWrites()) {
            this.getCacheMutex().release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object removeFromIdentityMap(Vector key, Class domainClass, ClassDescriptor descriptor, Object objectToRemove) {
        Object value;
        IdentityMap map = this.getIdentityMap(descriptor);
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                value = map.remove(key, objectToRemove);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            value = map.remove(key, objectToRemove);
        }
        return value;
    }

    protected void setCacheMutex(ConcurrencyManager cacheMutex) {
        this.cacheMutex = cacheMutex;
    }

    public void setIdentityMaps(ConcurrentMap identityMaps) {
        this.clearLastAccessedIdentityMap();
        this.identityMaps = identityMaps;
    }

    protected void setSession(AbstractSession session) {
        this.session = session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWrapper(Vector primaryKey, Class theClass, Object wrapper) {
        ClassDescriptor descriptor = this.getSession().getDescriptor(theClass);
        IdentityMap map = this.getIdentityMap(descriptor);
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                map.setWrapper(primaryKey, wrapper);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            map.setWrapper(primaryKey, wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setWriteLockValue(Vector primaryKey, Class theClass, Object writeLockValue) {
        ClassDescriptor descriptor = this.getSession().getDescriptor(theClass);
        IdentityMap map = this.getIdentityMap(descriptor);
        if (this.isCacheAccessPreCheckRequired()) {
            this.getSession().startOperationProfile("cache");
            this.acquireReadLock();
            try {
                map.setWriteLockValue(primaryKey, writeLockValue);
            }
            finally {
                this.releaseReadLock();
            }
            this.getSession().endOperationProfile("cache");
        } else {
            map.setWriteLockValue(primaryKey, writeLockValue);
        }
    }

    protected Object checkForInheritance(Object domainObject, Class superClass, ClassDescriptor descriptor) {
        if (domainObject != null && domainObject.getClass() != superClass && !superClass.isInstance(domainObject)) {
            if (descriptor.hasInheritance() && descriptor.getInheritancePolicy().getUseDescriptorsToValidateInheritedObjects()) {
                if (descriptor.getInheritancePolicy().getSubclassDescriptor(domainObject.getClass()) == null) {
                    return null;
                }
                return domainObject;
            }
            return null;
        }
        return domainObject;
    }
}

