/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XMLConversionPair;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.oxm.NamespaceResolver;

public class XMLField
extends DatabaseField {
    private NamespaceResolver namespaceResolver;
    private QName schemaType;
    private XPathFragment xPathFragment;
    private XPathFragment lastXPathFragment;
    private boolean isCDATA = false;
    private boolean usesSingleNode;
    protected HashMap userXMLTypes;
    protected HashMap userJavaTypes;
    private boolean isTypedTextField = false;
    private QName leafElementType;

    public XMLField() {
    }

    public XMLField(String xPath) {
        this.setXPath(xPath);
    }

    public String getXPath() {
        return this.getName();
    }

    public void setXPath(String xPath) {
        this.setName(xPath);
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public void setNamespaceResolver(NamespaceResolver newNamespaceResolver) {
        this.namespaceResolver = newNamespaceResolver;
    }

    public void setUsesSingleNode(boolean usesSingleNode) {
        this.usesSingleNode = usesSingleNode;
    }

    public boolean usesSingleNode() {
        return this.usesSingleNode;
    }

    public void setSchemaType(QName value) {
        this.schemaType = value;
    }

    public QName getSchemaType() {
        return this.schemaType;
    }

    public boolean isTypedTextField() {
        return this.isTypedTextField;
    }

    public void setIsTypedTextField(boolean value) {
        this.isTypedTextField = value;
    }

    public boolean isSelfField() {
        if (null == this.xPathFragment) {
            return false;
        }
        return this.xPathFragment.isSelfFragment();
    }

    public boolean isUnionField() {
        return false;
    }

    public void setName(String xPath) {
        super.setName(xPath);
        if (this.hasPath(xPath)) {
            this.buildFragments(xPath);
        } else {
            XPathFragment xPathFragment = new XPathFragment(xPath);
            this.setXPathFragment(xPathFragment);
            this.setLastXPathFragment(xPathFragment);
        }
    }

    private boolean hasPath(String xpathString) {
        return xpathString != null && xpathString.indexOf(47) != -1;
    }

    private void buildFragments(String xpathString) {
        String next;
        StringTokenizer st = new StringTokenizer(xpathString, "/");
        int i = 0;
        XPathFragment currentXPathFragment = null;
        XPathFragment nextXPathFragment = null;
        if (xpathString.startsWith("/")) {
            next = st.nextToken();
            next = "/" + next;
            currentXPathFragment = new XPathFragment(next);
            this.setXPathFragment(currentXPathFragment);
            ++i;
        }
        while (st.hasMoreTokens()) {
            next = st.nextToken();
            if (null != next) {
                nextXPathFragment = next.equals("text()") ? XPathFragment.TEXT_FRAGMENT : new XPathFragment(next);
                if (0 == i) {
                    this.setXPathFragment(nextXPathFragment);
                } else {
                    currentXPathFragment.setNextFragment(nextXPathFragment);
                    if (nextXPathFragment.isAttribute() || nextXPathFragment.nameIsText()) {
                        currentXPathFragment.setHasText(true);
                    }
                }
                currentXPathFragment = nextXPathFragment;
                ++i;
            }
            this.setLastXPathFragment(currentXPathFragment);
        }
    }

    public XPathFragment getXPathFragment() {
        return this.xPathFragment;
    }

    public void setXPathFragment(XPathFragment xPathFragment) {
        this.xPathFragment = xPathFragment;
    }

    public XPathFragment getLastXPathFragment() {
        return this.lastXPathFragment;
    }

    public void setLastXPathFragment(XPathFragment lastXPathFragment) {
        this.lastXPathFragment = lastXPathFragment;
    }

    public Class getJavaClass(QName qname) {
        if (this.userXMLTypes != null && this.userXMLTypes.containsKey(qname)) {
            return (Class)this.userXMLTypes.get(qname);
        }
        return (Class)XMLConversionManager.getDefaultXMLTypes().get(qname);
    }

    public QName getXMLType(Class javaClass) {
        if (this.userJavaTypes != null && this.userJavaTypes.containsKey(javaClass)) {
            return (QName)this.userJavaTypes.get(javaClass);
        }
        return (QName)XMLConversionManager.getDefaultJavaTypes().get(javaClass);
    }

    private HashMap getUserJavaTypes() {
        if (this.userJavaTypes == null) {
            this.userJavaTypes = new HashMap();
        }
        return this.userJavaTypes;
    }

    private HashMap getUserXMLTypes() {
        if (this.userXMLTypes == null) {
            this.userXMLTypes = new HashMap();
        }
        return this.userXMLTypes;
    }

    public ArrayList getUserXMLTypesForDeploymentXML() {
        if (this.userXMLTypes != null) {
            ArrayList<XMLConversionPair> types = new ArrayList<XMLConversionPair>(this.userXMLTypes.size());
            for (QName xmlType : this.userXMLTypes.keySet()) {
                Class javaType = (Class)this.userXMLTypes.get(xmlType);
                XMLConversionPair pair = new XMLConversionPair(xmlType, javaType.getName());
                types.add(pair);
            }
            return types;
        }
        return null;
    }

    public void setUserXMLTypesForDeploymentXML(ArrayList pairs) throws Exception {
        if (pairs.size() > 0) {
            this.userXMLTypes = new HashMap();
            for (XMLConversionPair pair : pairs) {
                if (pair.getXmlType() == null || pair.getJavaType() == null) continue;
                this.userXMLTypes.put(pair.getXmlType(), Class.forName(pair.getJavaType()));
            }
        }
    }

    public ArrayList getUserJavaTypesForDeploymentXML() {
        if (this.userJavaTypes != null) {
            ArrayList<XMLConversionPair> types = new ArrayList<XMLConversionPair>(this.userJavaTypes.size());
            for (Class javaType : this.userJavaTypes.keySet()) {
                QName xmlType = (QName)this.userJavaTypes.get(javaType);
                XMLConversionPair pair = new XMLConversionPair(xmlType, javaType.getName());
                types.add(pair);
            }
            return types;
        }
        return null;
    }

    public void setUserJavaTypesForDeploymentXML(ArrayList pairs) throws Exception {
        if (pairs.size() > 0) {
            this.userJavaTypes = new HashMap();
            for (XMLConversionPair pair : pairs) {
                if (pair.getXmlType() == null || pair.getJavaType() == null) continue;
                this.userJavaTypes.put(Class.forName(pair.getJavaType()), pair.getXmlType());
            }
        }
    }

    public Object convertValueBasedOnSchemaType(Object value, XMLConversionManager xmlConversionManager) {
        if (this.getSchemaType() != null) {
            Class fieldType = this.getType();
            if (fieldType == null) {
                fieldType = this.getJavaClass(this.getSchemaType());
            }
            return xmlConversionManager.convertObject(value, fieldType, this.getSchemaType());
        }
        return value;
    }

    public void addXMLConversion(QName qname, Class javaClass) {
        this.getUserXMLTypes().put(qname, javaClass);
    }

    public void addJavaConversion(Class javaClass, QName qname) {
        this.getUserJavaTypes().put(javaClass, qname);
    }

    public void addConversion(QName qname, Class javaClass) {
        this.addJavaConversion(javaClass, qname);
        this.addXMLConversion(qname, javaClass);
    }

    public void removeXMLConversion(QName qname) {
        this.getUserXMLTypes().remove(qname);
    }

    public void removeJavaConversion(Class javaClass) {
        this.getUserJavaTypes().remove(javaClass);
    }

    public void removeConversion(QName qname, Class javaClass) {
        this.removeJavaConversion(javaClass);
        this.removeXMLConversion(qname);
    }

    public void setLeafElementType(QName type) {
        this.leafElementType = type;
        if (this.hasLastXPathFragment()) {
            this.getLastXPathFragment().setLeafElementType(type);
        }
    }

    public QName getLeafElementType() {
        if (this.hasLastXPathFragment()) {
            return this.getLastXPathFragment().getLeafElementType();
        }
        return this.leafElementType;
    }

    public boolean hasLastXPathFragment() {
        return this.getLastXPathFragment() != null;
    }

    public void setIsCDATA(boolean CDATA2) {
        this.isCDATA = CDATA2;
    }

    public boolean isCDATA() {
        return this.isCDATA;
    }
}

