/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.LuceneIndexingParameters;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.optimization.OptimizerStrategy;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Workspace {
    private static final Logger log = LoggerFactory.make();
    private static final Analyzer SIMPLE_ANALYZER = new SimpleAnalyzer();
    private final SearchFactoryImplementor searchFactoryImplementor;
    private final DirectoryProvider directoryProvider;
    private final OptimizerStrategy optimizerStrategy;
    private final ReentrantLock lock;
    private final Set<Class<?>> entitiesInDirectory;
    private final LuceneIndexingParameters indexingParams;
    private IndexReader reader;
    private IndexWriter writer;
    private final AtomicLong operations = new AtomicLong(0L);

    public Workspace(SearchFactoryImplementor searchFactoryImplementor, DirectoryProvider<?> provider) {
        this.searchFactoryImplementor = searchFactoryImplementor;
        this.directoryProvider = provider;
        this.optimizerStrategy = searchFactoryImplementor.getOptimizerStrategy(this.directoryProvider);
        this.entitiesInDirectory = searchFactoryImplementor.getClassesInDirectoryProvider(provider);
        this.indexingParams = searchFactoryImplementor.getIndexingParameters(this.directoryProvider);
        this.lock = searchFactoryImplementor.getDirectoryProviderLock(provider);
    }

    public <T> DocumentBuilderIndexedEntity<T> getDocumentBuilder(Class<T> entity) {
        return this.searchFactoryImplementor.getDocumentBuilderIndexedEntity(entity);
    }

    public Analyzer getAnalyzer(String name) {
        return this.searchFactoryImplementor.getAnalyzer(name);
    }

    public void optimizerPhase() {
        this.assertOwnLock();
        this.optimizerStrategy.addTransaction(this.operations.getAndSet(0L));
        this.optimizerStrategy.optimize(this);
    }

    public void optimize() {
        this.assertOwnLock();
        this.optimizerStrategy.optimizationForced();
    }

    public synchronized IndexReader getIndexReader() {
        this.assertOwnLock();
        if (this.writer != null) {
            throw new AssertionFailure("Tries to read for update an index while a writer is in use.");
        }
        if (this.reader != null) {
            return this.reader;
        }
        Object directory = this.directoryProvider.getDirectory();
        try {
            this.reader = IndexReader.open(directory, (boolean)false);
            log.trace("IndexReader opened");
        }
        catch (IOException e) {
            this.reader = null;
            throw new SearchException("Unable to open IndexReader on directory " + directory, e);
        }
        return this.reader;
    }

    public synchronized void closeIndexReader() {
        this.assertOwnLock();
        IndexReader toClose = this.reader;
        this.reader = null;
        if (toClose != null) {
            try {
                toClose.close();
                log.trace("IndexReader closed");
            }
            catch (IOException e) {
                throw new SearchException("Exception while closing IndexReader", e);
            }
        } else {
            throw new AssertionFailure("No IndexReader open to close.");
        }
    }

    public synchronized IndexWriter getIndexWriter(boolean batchmode) {
        this.assertOwnLock();
        if (this.reader != null) {
            throw new AssertionFailure("Tries to open an IndexWriter while an IndexReader is open in update mode.");
        }
        if (this.writer != null) {
            return this.writer;
        }
        try {
            IndexWriter.MaxFieldLength fieldLength = new IndexWriter.MaxFieldLength(10000);
            this.writer = new IndexWriter(this.directoryProvider.getDirectory(), SIMPLE_ANALYZER, false, fieldLength);
            this.indexingParams.applyToWriter(this.writer, batchmode);
            log.trace("IndexWriter opened");
        }
        catch (IOException e) {
            this.writer = null;
            throw new SearchException("Unable to open IndexWriter", e);
        }
        return this.writer;
    }

    public synchronized void commitIndexWriter() {
        this.assertOwnLock();
        if (this.writer != null) {
            try {
                this.writer.commit();
                log.trace("Index changes commited.");
            }
            catch (IOException e) {
                throw new SearchException("Exception while commiting index changes", e);
            }
        } else {
            throw new AssertionFailure("No open IndexWriter to commit changes.");
        }
    }

    public synchronized void closeIndexWriter() {
        this.assertOwnLock();
        IndexWriter toClose = this.writer;
        this.writer = null;
        if (toClose != null) {
            try {
                toClose.close();
                log.trace("IndexWriter closed");
            }
            catch (IOException e) {
                throw new SearchException("Exception while closing IndexWriter", e);
            }
        } else {
            throw new AssertionFailure("No open IndexWriter to close");
        }
    }

    public void incrementModificationCounter(int modCount) {
        this.operations.addAndGet(modCount);
    }

    public Set<Class<?>> getEntitiesInDirectory() {
        return this.entitiesInDirectory;
    }

    public void lock() {
        this.lock.lock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unlock() {
        try {
            if (this.reader != null) {
                throw new AssertionFailure("Unlocking Workspace without having closed the IndexReader");
            }
            if (this.writer != null) {
                throw new AssertionFailure("Unlocking Workspace without having closed the IndexWriter");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void assertOwnLock() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new AssertionFailure("Not owning DirectoryProvider Lock");
        }
    }
}

