/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.connector;

import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.resource.ResourceException;
import javax.resource.spi.CommException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.SecurityException;
import org.objectweb.joram.client.connector.AdapterTracing;
import org.objectweb.joram.client.connector.ManagedConnectionFactoryImpl;
import org.objectweb.joram.client.connector.OutboundConnectionFactory;
import org.objectweb.joram.client.connector.TopicConnectionRequest;
import org.objectweb.util.monolog.api.BasicLevel;

public class OutboundTopicConnectionFactory
extends OutboundConnectionFactory
implements TopicConnectionFactory {
    private static final long serialVersionUID = 1L;

    OutboundTopicConnectionFactory(ManagedConnectionFactoryImpl mcf, ConnectionManager cxManager) {
        super(mcf, cxManager);
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)("OutboundTopicConnectionFactory(" + mcf + ", " + cxManager + ")"));
        }
    }

    public TopicConnection createTopicConnection() throws JMSException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createTopicConnection()"));
        }
        return this.createTopicConnection(this.mcf.userName, this.mcf.password);
    }

    public TopicConnection createTopicConnection(String userName, String password) throws JMSException {
        if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
            AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createTopicConnection(" + userName + ", " + password + ")"));
        }
        try {
            TopicConnectionRequest cxRequest = new TopicConnectionRequest(userName, password, this.mcf.getIdentityClass());
            Object o = this.cxManager.allocateConnection(this.mcf, cxRequest);
            if (AdapterTracing.dbgAdapter.isLoggable(BasicLevel.DEBUG)) {
                AdapterTracing.dbgAdapter.log(BasicLevel.DEBUG, (Object)(this + " createTopicConnection TopicConnection = " + o));
            }
            return (TopicConnection)o;
        }
        catch (SecurityException exc) {
            throw new JMSSecurityException("Invalid user identification: " + exc);
        }
        catch (CommException exc) {
            throw new IllegalStateException("Could not connect to the JORAM server: " + exc);
        }
        catch (ResourceException exc) {
            throw new JMSException("Could not create connection: " + exc);
        }
    }
}

