/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.metainfo.lib;

import java.util.Collection;
import java.util.Iterator;
import org.objectweb.jorm.metainfo.api.Manager;
import org.objectweb.jorm.metainfo.api.MetaObject;
import org.objectweb.jorm.util.api.Loggable;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.objectweb.util.monolog.api.LoggerFactory;

public class BasicMetaObject
implements MetaObject,
Loggable {
    protected MetaObject parent;
    protected transient Logger logger = null;
    protected transient LoggerFactory loggerFactory = null;
    protected transient boolean debug = false;

    public BasicMetaObject(MetaObject parent) {
        this.parent = parent;
        if (parent instanceof Loggable) {
            this.loggerFactory = ((Loggable)((Object)parent)).getLoggerFactory();
            this.logger = this.loggerFactory == null ? ((Loggable)((Object)parent)).getLogger() : this.loggerFactory.getLogger(this.getClass().getName());
        }
        this.debug = this.logger != null && this.logger.isLoggable(BasicLevel.DEBUG);
    }

    protected Collection getChildren() {
        return null;
    }

    public void setLoggingOnChild(MetaObject mo) {
        if (mo instanceof Loggable) {
            if (this.loggerFactory != null) {
                ((Loggable)((Object)mo)).setLoggerFactory(this.loggerFactory);
            } else if (this.logger != null) {
                ((Loggable)((Object)mo)).setLogger(this.logger);
            }
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public LoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
        Collection children = this.getChildren();
        if (children != null && !children.isEmpty()) {
            Iterator it = children.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (o == null || !(o instanceof Loggable)) continue;
                ((Loggable)o).setLogger(logger);
            }
        }
    }

    public void setLoggerFactory(LoggerFactory loggerfactory) {
        this.loggerFactory = loggerfactory;
        Collection children = this.getChildren();
        if (children != null && !children.isEmpty()) {
            Iterator it = children.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (o == null || !(o instanceof Loggable)) continue;
                ((Loggable)o).setLoggerFactory(this.loggerFactory);
            }
        }
        if (this.loggerFactory != null && this.logger == null) {
            this.setLogger(this.loggerFactory.getLogger(this.getClass().getName()));
        }
    }

    public MetaObject getParent() {
        return this.parent;
    }

    public void setParent(MetaObject parent) {
        this.parent = parent;
    }

    public Manager getManager() {
        MetaObject manager = null;
        for (MetaObject tmp = this.parent; tmp != null; tmp = tmp.getParent()) {
            manager = tmp;
        }
        return (Manager)manager;
    }
}

