/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jorm.naming.lib;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import org.objectweb.jorm.api.PBinding;
import org.objectweb.jorm.api.PClassMapping;
import org.objectweb.jorm.api.PException;
import org.objectweb.jorm.genclass.lib.GenClassMapping;
import org.objectweb.jorm.naming.api.PBinder;
import org.objectweb.jorm.naming.api.PExceptionNaming;
import org.objectweb.jorm.naming.api.PName;
import org.objectweb.jorm.naming.api.PNameManager;
import org.objectweb.jorm.naming.api.PolymorphicPName;
import org.objectweb.jorm.naming.api.PolymorphicPNamingContext;
import org.objectweb.jorm.type.api.PType;
import org.objectweb.medor.tuple.api.TupleCollection;
import org.objectweb.perseus.cache.api.CacheEntry;
import org.objectweb.perseus.cache.api.CacheManager;
import org.objectweb.perseus.persistence.api.ConnectionHolder;
import org.objectweb.perseus.persistence.api.WorkingSet;

public class BasicPolymorphicPNamingContext
implements PolymorphicPNamingContext {
    private PBinder delegatedBinder;
    private PClassMapping pcm;
    private CacheManager cache;
    private PNameManager delegatedPNM;

    public BasicPolymorphicPNamingContext() {
        this.delegatedBinder = null;
        this.pcm = null;
        this.cache = null;
        this.delegatedPNM = null;
    }

    public BasicPolymorphicPNamingContext(PBinder delegatedBinder, PClassMapping pcm, CacheManager cache, PNameManager delegatedPNM) {
        this.delegatedBinder = delegatedBinder;
        this.pcm = pcm;
        this.cache = cache;
        this.delegatedPNM = delegatedPNM;
    }

    public CacheManager getCache() {
        return this.cache;
    }

    public void setCache(CacheManager cache) {
        this.cache = cache;
    }

    public PBinder getDelegatedBinder() {
        return this.delegatedBinder;
    }

    public void setDelegatedBinder(PBinder delegatedBinder) {
        this.delegatedBinder = delegatedBinder;
    }

    public PClassMapping getPcm() {
        return this.pcm;
    }

    public void setPcm(PClassMapping pcm) {
        this.pcm = pcm;
    }

    public PName resolve(Object conn, PName pname) throws PException {
        if (pname.getPNameManager() instanceof PBinder) {
            return pname;
        }
        try {
            PName pnFound = this.checkCache(pname);
            if (pnFound != pname) {
                return pnFound;
            }
            if (!(conn instanceof ConnectionHolder)) {
                throw new PException("The conn parameter of PolymorphicPNC.resolve(conn, pname) must be an instance of ConnectionHolder");
            }
            ConnectionHolder connHolder = (ConnectionHolder)conn;
            WorkingSet ws = connHolder.getWorkingSet();
            TupleCollection tupleCollection = this.pcm.getPMapper().getPrefetchCache().getPrefetchTupleCollection(pname, this.pcm, ws);
            if (tupleCollection != null && tupleCollection.getMetaData() != null) {
                return this.pcm.getDecodedPName(tupleCollection, pname, false);
            }
            return this.pcm.resolve(conn, pname);
        }
        catch (Exception e) {
            throw new PException(e, "Exception while trying to resolve the pname in the BasicAsymetricPNC. " + e.getMessage());
        }
    }

    public PName export(Object conn, Object infoitem) throws PException {
        return this.delegatedBinder.export(conn, infoitem);
    }

    public PName export(Object conn, Object infoitem, Object hints) throws PException {
        return this.delegatedBinder.export(conn, infoitem, hints);
    }

    public void unexport(Object conn, PName pn) throws PException {
        this.delegatedBinder.unexport(conn, pn);
    }

    public void unexport(Object conn, PName pn, Object hints) throws PException {
        this.delegatedBinder.unexport(conn, pn, hints);
    }

    public boolean codingSupported(int codingtype) {
        return this.delegatedBinder.codingSupported(codingtype);
    }

    public PName decode(byte[] en) throws PExceptionNaming {
        PName pname = this.delegatedBinder.decode(en);
        return this.checkCache(this.markAsPolymorphic(pname));
    }

    public PName decodeAbstract(Object en, Object context) throws PExceptionNaming, UnsupportedOperationException {
        PName pname = this.delegatedBinder.decodeAbstract(en, context);
        return this.checkCache(this.markAsPolymorphic(pname));
    }

    public PName decodeByte(byte en) throws PExceptionNaming, UnsupportedOperationException {
        PName pname = this.delegatedBinder.decodeByte(en);
        return this.checkCache(this.markAsPolymorphic(pname));
    }

    public PName decodeObyte(Byte en) throws PExceptionNaming, UnsupportedOperationException {
        PName pname = this.delegatedBinder.decodeObyte(en);
        return this.checkCache(this.markAsPolymorphic(pname));
    }

    public PName decodeChar(char en) throws PExceptionNaming, UnsupportedOperationException {
        PName pname = this.delegatedBinder.decodeChar(en);
        return this.checkCache(this.markAsPolymorphic(pname));
    }

    public PName decodeOchar(Character en) throws PExceptionNaming, UnsupportedOperationException {
        PName pname = this.delegatedBinder.decodeOchar(en);
        return this.checkCache(this.markAsPolymorphic(pname));
    }

    public PName decodeInt(int en) throws PExceptionNaming, UnsupportedOperationException {
        PName pname = this.delegatedBinder.decodeInt(en);
        return this.checkCache(this.markAsPolymorphic(pname));
    }

    public PName decodeOint(Integer en) throws PExceptionNaming, UnsupportedOperationException {
        PName pname = this.delegatedBinder.decodeOint(en);
        return this.checkCache(this.markAsPolymorphic(pname));
    }

    public PName decodeLong(long en) throws PExceptionNaming, UnsupportedOperationException {
        PName pname = this.delegatedBinder.decodeLong(en);
        return this.checkCache(this.markAsPolymorphic(pname));
    }

    public PName decodeOlong(Long en) throws PExceptionNaming, UnsupportedOperationException {
        PName pname = this.delegatedBinder.decodeOlong(en);
        return this.checkCache(this.markAsPolymorphic(pname));
    }

    public PName decodeShort(short en) throws PExceptionNaming, UnsupportedOperationException {
        PName pname = this.delegatedBinder.decodeShort(en);
        return this.checkCache(this.markAsPolymorphic(pname));
    }

    public PName decodeOshort(Short en) throws PExceptionNaming, UnsupportedOperationException {
        PName pname = this.delegatedBinder.decodeOshort(en);
        return this.checkCache(this.markAsPolymorphic(pname));
    }

    public PName decodeString(String en) throws PExceptionNaming {
        PName pname = this.delegatedBinder.decodeString(en);
        return this.checkCache(this.markAsPolymorphic(pname));
    }

    public PName decodeCharArray(char[] en) throws PExceptionNaming {
        PName pname = this.delegatedBinder.decodeCharArray(en);
        return this.checkCache(this.markAsPolymorphic(pname));
    }

    public PName decodeDate(Date en) throws PExceptionNaming {
        PName pname = this.delegatedBinder.decodeDate(en);
        return this.checkCache(this.markAsPolymorphic(pname));
    }

    public PName decodeBigInteger(BigInteger en) throws PExceptionNaming {
        PName pname = this.delegatedBinder.decodeBigInteger(en);
        return this.checkCache(this.markAsPolymorphic(pname));
    }

    public PName decodeBigDecimal(BigDecimal en) throws PExceptionNaming {
        PName pname = this.delegatedBinder.decodeBigDecimal(en);
        return this.checkCache(this.markAsPolymorphic(pname));
    }

    public byte[] encode(PName pn) throws PExceptionNaming {
        return this.delegatedBinder.encode(pn);
    }

    public Object encodeAbstract(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        return this.delegatedBinder.encodeAbstract(pn);
    }

    public byte encodeByte(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        return this.delegatedBinder.encodeByte(pn);
    }

    public Byte encodeObyte(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        return this.delegatedBinder.encodeObyte(pn);
    }

    public char encodeChar(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        return this.delegatedBinder.encodeChar(pn);
    }

    public Character encodeOchar(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        return this.delegatedBinder.encodeOchar(pn);
    }

    public int encodeInt(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        return this.delegatedBinder.encodeInt(pn);
    }

    public Integer encodeOint(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        return this.delegatedBinder.encodeOint(pn);
    }

    public long encodeLong(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        return this.delegatedBinder.encodeLong(pn);
    }

    public Long encodeOlong(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        return this.delegatedBinder.encodeOlong(pn);
    }

    public short encodeShort(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        return this.delegatedBinder.encodeShort(pn);
    }

    public Short encodeOshort(PName pn) throws PExceptionNaming, UnsupportedOperationException {
        return this.delegatedBinder.encodeOshort(pn);
    }

    public String encodeString(PName pn) throws PExceptionNaming {
        return this.delegatedBinder.encodeString(pn);
    }

    public char[] encodeCharArray(PName pn) throws PExceptionNaming {
        return this.delegatedBinder.encodeCharArray(pn);
    }

    public Date encodeDate(PName pn) throws PExceptionNaming {
        return this.delegatedBinder.encodeDate(pn);
    }

    public BigInteger encodeBigInteger(PName pn) throws PExceptionNaming {
        return this.delegatedBinder.encodeBigInteger(pn);
    }

    public BigDecimal encodeBigDecimal(PName pn) throws PExceptionNaming {
        return this.delegatedBinder.encodeBigDecimal(pn);
    }

    public PName getNull() {
        return this.delegatedBinder.getNull();
    }

    public void setNullPName(Object o) throws PException {
        this.delegatedBinder.setNullPName(o);
    }

    public boolean supportDynamicComposite() {
        return this.delegatedBinder.supportDynamicComposite();
    }

    public boolean supportCompositeField(String fn, PType ft) {
        return this.delegatedBinder.supportCompositeField(fn, ft);
    }

    public boolean supportStaticComposite() {
        return this.delegatedBinder.supportStaticComposite();
    }

    public PType getPType() {
        PType type = this.delegatedBinder.getPType();
        if (type == null) {
            type = this.pcm.getPType();
            this.delegatedBinder.setPType(type);
        }
        return type;
    }

    public void setPType(PType pt) {
        this.delegatedBinder.setPType(pt);
    }

    private PName checkCache(PName pname) throws PExceptionNaming {
        PolymorphicPName polymorphicPN = (PolymorphicPName)pname;
        CacheEntry ce = this.cache.lookup(pname);
        if (ce != null) {
            PName pnFound = (PName)ce.getCeIdentifier();
            PBinding pbinding = (PBinding)ce.getCeObject();
            PClassMapping pcmFound = pbinding.getPClassMapping();
            if (pcmFound instanceof GenClassMapping) {
                return pname;
            }
            try {
                PClassMapping[] subPCMs = this.pcm.getSubPCMs();
                if (subPCMs != null) {
                    for (int i = 0; i < subPCMs.length; ++i) {
                        if (pcmFound != subPCMs[i]) continue;
                        return pnFound;
                    }
                }
                return pname;
            }
            catch (Exception e) {
                throw new PExceptionNaming(e, "Exception on decode, trying to get all the sub PClassMappings of " + this.pcm.getClassName() + "." + "Exception nested: " + e.getMessage());
            }
        }
        return pname;
    }

    private PolymorphicPName markAsPolymorphic(PName pn) {
        PolymorphicPName polymorphicPN = (PolymorphicPName)pn;
        polymorphicPN.setPolymorphic(true);
        polymorphicPN.setPNameManager(this);
        return polymorphicPN;
    }
}

