/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.easybeans.rpc.util;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import org.ow2.easybeans.asm.Type;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Hash {
    private static Log logger = LogFactory.getLog(Hash.class);
    private static final int BYTES_LENGTH = 8;
    private static final int BYTE_MASK = 255;

    private Hash() {
    }

    public static long hashMethod(String methodName, String methodDescriptor) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Algorithm SHA-1 is not available", e);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DigestOutputStream dos = new DigestOutputStream(baos, md);
        DataOutputStream das = new DataOutputStream(dos);
        StringBuilder sb = new StringBuilder();
        sb.append(methodName);
        sb.append(methodDescriptor);
        try {
            das.writeUTF(sb.toString());
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot write data for method '" + methodName + "'.", e);
        }
        try {
            das.flush();
        }
        catch (IOException e) {
            logger.warn("Cannot flush the stream", e);
        }
        try {
            das.close();
        }
        catch (IOException e) {
            logger.warn("Cannot flush the stream", e);
        }
        byte[] digest = md.digest();
        long hash = 0L;
        int size = Math.min(digest.length, 8);
        for (int i = 0; i < size; ++i) {
            hash += (long)(digest[i] & 0xFF) << 8 * i;
        }
        return hash;
    }

    public static long hashMethod(Method method) {
        return Hash.hashMethod(method.getName(), Type.getMethodDescriptor(method));
    }

    public static Map<Long, Method> hashClass(Class<?> clz) {
        Method[] methods;
        HashMap<Long, Method> map = new HashMap<Long, Method>();
        for (Method m : methods = clz.getMethods()) {
            map.put(Hash.hashMethod(m), m);
        }
        return map;
    }
}

