/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ejb.easybeans;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.ow2.easybeans.api.EZBContainer;
import org.ow2.easybeans.api.EZBContainerException;
import org.ow2.easybeans.loader.EasyBeansClassLoader;
import org.ow2.easybeans.server.Embedded;
import org.ow2.jonas.ejb.easybeans.PrefixedNamingStrategy;
import org.ow2.jonas.lib.bootstrap.JProp;
import org.ow2.jonas.lib.work.DeployerLog;
import org.ow2.jonas.properties.ServerProperties;
import org.ow2.jonas.versioning.VersioningService;
import org.ow2.util.archive.api.ArchiveException;
import org.ow2.util.archive.api.IArchive;
import org.ow2.util.ee.deploy.api.deployable.EJB3Deployable;
import org.ow2.util.ee.deploy.api.deployable.IDeployable;
import org.ow2.util.ee.deploy.api.deployer.DeployerException;
import org.ow2.util.ee.deploy.impl.deployer.AbsDeployer;
import org.ow2.util.ee.deploy.impl.helper.UnpackDeployableHelper;
import org.ow2.util.file.FileUtils;
import org.ow2.util.file.FileUtilsException;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.url.URLUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EasyBeansDeployer
extends AbsDeployer {
    private Log logger = LogFactory.getLog(EasyBeansDeployer.class);
    private Embedded easybeansServer = null;
    private ClassLoader appsClassLoader;
    private Map<URL, EJB3Deployable> ejb3s = new HashMap<URL, EJB3Deployable>();
    private static final String WORK_EJB3S_DIR = JProp.getWorkDir() + File.separator + "ejb3s";
    private ServerProperties serverProperties = null;
    private VersioningService versioningService;
    private DeployerLog deployerLog;

    @Override
    public void doDeploy(IDeployable<?> deployable) throws DeployerException {
        EJB3Deployable unpackedDeployable = null;
        File folder = new File(WORK_EJB3S_DIR, this.getServerProperties().getServerName());
        folder.mkdirs();
        try {
            unpackedDeployable = UnpackDeployableHelper.unpack((EJB3Deployable)deployable, folder, FileUtils.lastModifiedFileName(URLUtils.urlToFile(deployable.getArchive().getURL())));
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get archive while deploying EJB3Deployable", e);
        }
        catch (FileUtilsException e) {
            throw new DeployerException("Cannot get file last modified date while deploying EJB3Deployable", e);
        }
        URL initialURL = null;
        try {
            initialURL = deployable.getArchive().getURL();
            if (this.deployerLog != null) {
                this.deployerLog.addEntry(URLUtils.urlToFile(initialURL), URLUtils.urlToFile(unpackedDeployable.getArchive().getURL()));
            }
        }
        catch (Exception e) {
            throw new DeployerException("Cannot get  the url of the initial deployable for the EJB3 Module '" + deployable + "'.", e);
        }
        this.logger.info("Deploying ''{0}''...", deployable);
        EZBContainer container = this.easybeansServer.createContainer(unpackedDeployable);
        String prefix = null;
        if (this.versioningService != null && this.versioningService.isVersioningEnabled()) {
            prefix = this.versioningService.getPrefix(deployable);
        }
        if (prefix != null) {
            container.getConfiguration().setNamingStrategy(new PrefixedNamingStrategy(prefix, container.getConfiguration().getNamingStrategy()));
        }
        URL[] arrayURLs = new URL[]{this.getURL(unpackedDeployable)};
        EasyBeansClassLoader ejb3ClassLoader = new EasyBeansClassLoader(arrayURLs, this.appsClassLoader);
        container.setClassLoader(ejb3ClassLoader);
        try {
            container.start();
        }
        catch (EZBContainerException e) {
            this.easybeansServer.removeContainer(container);
            throw new DeployerException("Cannot deploy the given EJB '" + deployable + "'.", e);
        }
        this.ejb3s.put(initialURL, unpackedDeployable);
        if (prefix != null) {
            this.versioningService.createJNDIBindingMBeans(deployable);
        }
        this.logger.info("''{0}'' EJB3 Deployable is now deployed", deployable);
    }

    @Override
    public void doUndeploy(IDeployable<?> deployable) throws DeployerException {
        URL initialURL = null;
        try {
            initialURL = deployable.getArchive().getURL();
        }
        catch (ArchiveException e) {
            throw new DeployerException("Cannot get the URL of the EJB3 deployable '" + deployable + "'.", e);
        }
        IArchive archive = null;
        if (!this.ejb3s.containsKey(initialURL)) {
            throw new DeployerException("Cannot get the URL of the unpacked EJB3 deployable '" + deployable + "'.");
        }
        archive = this.ejb3s.get(initialURL).getArchive();
        this.logger.info("Undeploying ''{0}''...", deployable);
        Map<String, EZBContainer> containers = this.easybeansServer.getContainers();
        EZBContainer foundContainer = null;
        for (EZBContainer container : containers.values()) {
            IArchive containerArchive = container.getArchive();
            if (!archive.equals(containerArchive)) continue;
            foundContainer = container;
            break;
        }
        if (foundContainer == null) {
            throw new DeployerException("Cannot undeploy the deployable '" + deployable + "' as this container is not deployed");
        }
        this.ejb3s.remove(initialURL);
        this.logger.debug("Found a matching container ''{0}'' for the archive ''{1}''", foundContainer, deployable.getArchive());
        try {
            foundContainer.stop();
            this.easybeansServer.removeContainer(foundContainer);
        }
        catch (Exception e) {
            throw new DeployerException("Cannot undeploy the deployable '" + deployable + "'", e);
        }
        if (this.versioningService != null && this.versioningService.isVersioningEnabled()) {
            this.versioningService.garbageCollectJNDIBindingMBeans();
        }
        this.logger.info("''{0}'' EJB3 Deployable is now undeployed", deployable);
    }

    @Override
    public boolean supports(IDeployable<?> deployable) {
        return deployable instanceof EJB3Deployable;
    }

    public Map<URL, EJB3Deployable> getEJB3s() {
        return this.ejb3s;
    }

    public void setEmbedded(Embedded easybeansServer) {
        this.easybeansServer = easybeansServer;
    }

    public ServerProperties getServerProperties() {
        return this.serverProperties;
    }

    public void setServerProperties(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public void setVersioningService(VersioningService versioningService) {
        this.versioningService = versioningService;
    }

    public void unsetVersioningService() {
        this.versioningService = null;
    }

    public VersioningService getVersioningService() {
        return this.versioningService;
    }

    public void setDeployerLog(DeployerLog deployerLog) {
        this.deployerLog = deployerLog;
    }

    public void setAppsClassLoader(ClassLoader appsClassLoader) {
        this.appsClassLoader = appsClassLoader;
    }
}

