/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.generators.wsgen.finder;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.xml.parsers.SAXParser;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.generators.genbase.archive.J2EEArchive;
import org.ow2.jonas.generators.wsgen.finder.J2EEWebServicesFinder;
import org.ow2.jonas.lib.util.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WebServicesXmlFinder
extends DefaultHandler
implements J2EEWebServicesFinder {
    private static Logger logger = Log.getLogger("org.ow2.jonas.generators.wsgen");
    private static final String WEBINF_WEBSERVICES_XML = "WEB-INF/webservices.xml";
    private static final String METAINF_WEBSERVICES_XML = "META-INF/webservices.xml";
    private static final String JAXRPC_VERSION = "1.1";
    private J2EEArchive archive = null;
    private boolean jaxrpc = false;

    public WebServicesXmlFinder(J2EEArchive archive) {
        this.archive = archive;
    }

    public boolean find() {
        return this.jaxrpc;
    }

    public void init(SAXParser parser2) {
        List files = this.archive.getContainedFiles();
        for (String filename : files) {
            if (WEBINF_WEBSERVICES_XML.equals(filename)) {
                this.parseWebservicesDescriptor(parser2, filename);
            }
            if (!METAINF_WEBSERVICES_XML.equals(filename)) continue;
            this.parseWebservicesDescriptor(parser2, filename);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseWebservicesDescriptor(SAXParser parser2, String filename) {
        InputStream is = null;
        try {
            is = this.archive.getArchive().getInputStream(filename);
            parser2.parse(is, (DefaultHandler)this);
        }
        catch (IOException e) {
            logger.log(BasicLevel.DEBUG, (Object)("Cannot open " + filename + " in archive " + this.archive.getArchive().getName()));
        }
        catch (SAXException e) {
            logger.log(BasicLevel.DEBUG, (Object)("Cannot parse " + filename + " in archive " + this.archive.getArchive().getName()));
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    logger.log(BasicLevel.DEBUG, (Object)"Ignored");
                }
            }
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        String value;
        if ("webservices".equals(localName) && JAXRPC_VERSION.equals(value = attributes.getValue("version"))) {
            this.jaxrpc = true;
        }
    }
}

