/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.ejb21.ha;

import javax.ejb.EJBException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.cmi.controller.common.ClusterViewManager;
import org.ow2.cmi.controller.factory.ClusterViewManagerFactory;
import org.ow2.cmi.ha.SessionId;
import org.ow2.jonas.lib.ejb21.JSessionFactory;
import org.ow2.jonas.lib.ejb21.JSessionLocal;
import org.ow2.jonas.lib.ejb21.JStatefulSwitch;
import org.ow2.jonas.lib.ejb21.RequestCtx;
import org.ow2.jonas.lib.ejb21.ha.JRepUtil;
import org.ow2.jonas.lib.util.Log;

public abstract class JRepStatefulLocal
extends JSessionLocal {
    protected static Logger cmilogger = Log.getLogger("org.ow2.jonas.lib.ejb21.ha");
    public SessionId clusterOId = null;

    public JRepStatefulLocal(JSessionFactory bf) {
        super(bf);
        ClusterViewManager clusterViewManager = ClusterViewManagerFactory.getFactory().getClusterViewManager();
        if (clusterViewManager != null) {
            if (cmilogger.isLoggable(BasicLevel.DEBUG)) {
                cmilogger.log(BasicLevel.DEBUG, (Object)("JRepStatefulLocal : this=" + this));
            }
            this.clusterOId = clusterViewManager.getSessionId();
        }
    }

    public RequestCtx preInvoke(int txa) {
        RequestCtx rctx = super.preInvoke(txa);
        this.preInvokeHook(rctx);
        return rctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postInvoke(RequestCtx rctx, boolean remove) {
        try {
            this.postInvokeHook(rctx, remove);
        }
        catch (Exception e) {
            e.printStackTrace();
            cmilogger.log(BasicLevel.ERROR, (Object)"Error calling postInvokeHook in sfsb.", (Throwable)e);
        }
        finally {
            super.postInvoke(rctx);
        }
    }

    protected void injectState() {
        if (this.clusterOId != null) {
            JRepUtil.injectState(this.clusterOId, (JStatefulSwitch)this.bs);
        }
    }

    private void preInvokeHook(RequestCtx rctx) {
        if (this.clusterOId != null) {
            try {
                JRepUtil.preInvokeHook(this.bs, this.clusterOId, rctx);
            }
            catch (EJBException e) {
                e.printStackTrace();
                cmilogger.log(BasicLevel.ERROR, (Object)"Error in preInvokeHook in sfsb.", (Throwable)e);
            }
        }
    }

    private void postInvokeHook(RequestCtx rctx, boolean remove) {
        if (this.clusterOId != null) {
            JRepUtil.postInvokeHook(rctx, this.clusterOId, this.bs, remove);
        }
    }

    public SessionId getClusterOId() {
        return this.clusterOId;
    }

    public void setClusterOId(SessionId oid) {
        this.clusterOId = oid;
    }
}

