/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.management.extensions.cluster;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.ow2.jonas.lib.management.extensions.base.BaseManagement;
import org.ow2.jonas.lib.management.extensions.base.JonasManagementRepr;
import org.ow2.jonas.lib.management.extensions.domain.DomainManagement;
import org.ow2.jonas.lib.util.JonasObjectName;
import org.ow2.jonas.management.extensions.cluster.api.ICluster;

public class ClusterManagement
extends BaseManagement
implements ICluster {
    public void startAllServers(String clusterName) {
        DomainManagement dm = new DomainManagement();
        String domainName = this.getDomainName();
        String clusterType = dm.getClusterType(clusterName);
        String serverName = this.getServerName();
        ObjectName on = null;
        try {
            on = JonasObjectName.cluster(domainName, clusterName, clusterType);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        JonasManagementRepr.invoke(on, "startit", null, null, serverName);
    }

    public void stopAllServers(String clusterName) {
        DomainManagement dm = new DomainManagement();
        String domainName = this.getDomainName();
        String clusterType = dm.getClusterType(clusterName);
        String serverName = this.getServerName();
        ObjectName on = null;
        try {
            on = JonasObjectName.cluster(domainName, clusterName, clusterType);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        JonasManagementRepr.invoke(on, "stopit", null, null, serverName);
    }

    public String getMcastAddr(String clusterName) {
        DomainManagement dm = new DomainManagement();
        String domainName = this.getDomainName();
        String clusterType = dm.getClusterType(clusterName);
        ObjectName on = null;
        try {
            on = JonasObjectName.cluster(domainName, clusterName, clusterType);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        return this.getStringAttribute(on, "McastAddr");
    }

    public int getMcastPort(String clusterName) {
        String domainName = this.getDomainName();
        DomainManagement dm = new DomainManagement();
        String clusterType = dm.getClusterType(clusterName);
        ObjectName on = null;
        try {
            on = JonasObjectName.cluster(domainName, clusterName, clusterType);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        return this.getIntegerAttribute(on, "McastPort");
    }

    public String getProtocol(String clusterName) {
        String domainName = this.getDomainName();
        ObjectName on = null;
        try {
            on = JonasObjectName.cluster(domainName, clusterName, "CmiCluster");
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        return this.getStringAttribute(on, "Protocol");
    }

    public int getDelayToRefresh(String clusterName) {
        String domainName = this.getDomainName();
        ObjectName on = null;
        try {
            on = JonasObjectName.cluster(domainName, clusterName, "CmiCluster");
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        return this.getIntegerAttribute(on, "DelayToRefresh");
    }
}

