/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.lib.naming;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.ow2.jonas.lib.execution.ExecutionResult;
import org.ow2.jonas.lib.execution.IExecution;
import org.ow2.jonas.lib.execution.RunnableHelper;
import org.ow2.jonas.lib.loader.OSGiClassLoader;
import org.ow2.jonas.lib.util.Log;
import org.ow2.jonas.naming.JComponentContextFactory;
import org.ow2.jonas.naming.JNamingManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonNamingManager
implements JNamingManager {
    private static Logger logger = Log.getLogger("org.ow2.jonas.naming");
    private ThreadLocal<Context> threadContext = new ThreadLocal();
    private InitialContext ictx = null;
    private static Context serverContext = null;
    private Hashtable<?, ?> myEnv = null;
    private Hashtable<ClassLoader, Context> clBindings = new Hashtable();
    private static Context clientCtx = null;
    private static JNamingManager unique = null;
    private JComponentContextFactory factory = null;

    private SingletonNamingManager() throws NamingException {
        IExecution<InitialContext> ie = new IExecution<InitialContext>(){

            @Override
            public InitialContext execute() throws Exception {
                return new InitialContext();
            }
        };
        ExecutionResult<InitialContext> result = null;
        result = RunnableHelper.execute(new OSGiClassLoader(), ie);
        if (result.hasException()) {
            logger.log(BasicLevel.ERROR, (Object)("NamingManager: " + result.getException()));
            throw new NamingException("Cannot get InitialContext: " + result.getException());
        }
        this.ictx = result.getResult();
        unique = this;
    }

    public static JNamingManager getInstance() throws NamingException {
        if (unique == null) {
            unique = new SingletonNamingManager();
        }
        return unique;
    }

    @Override
    public void setJComponentContextFactory(JComponentContextFactory factory) {
        this.factory = factory;
    }

    @Override
    public InitialContext getInitialContext() {
        return this.ictx;
    }

    @Override
    public Context getComponentContext() throws NamingException {
        Context ctx = null;
        ctx = this.threadContext.get();
        if (ctx != null) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"return Context for ejb");
            }
            return ctx;
        }
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl != null && cl.getParent() != null && (ctx = this.clBindings.get(cl.getParent())) != null) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"return Context for webapp");
            }
            return ctx;
        }
        if (clientCtx != null && (ctx = clientCtx) != null) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"return Context for client");
            }
            return ctx;
        }
        if (ctx == null) {
            ctx = this.getServerContext();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)"return default server Context");
            }
        }
        return ctx;
    }

    @Override
    public Context setComponentContext(Context ctx) {
        Context ret = this.threadContext.get();
        this.threadContext.set(ctx);
        return ret;
    }

    @Override
    public void resetComponentContext(Context ctx) {
        this.threadContext.set(ctx);
    }

    @Override
    public void setComponentContext(Context ctx, ClassLoader cl) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("class loader = " + cl));
        }
        this.clBindings.put(cl, ctx);
    }

    @Override
    public void setClientContainerComponentContext(Context ctx) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)"");
        }
        clientCtx = ctx;
    }

    @Override
    public Context getComponentContext(ClassLoader cl) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("class loader = " + cl));
        }
        return this.clBindings.get(cl);
    }

    @Override
    public void unSetComponentContext(ClassLoader cl) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("class loader = " + cl));
        }
        this.clBindings.remove(cl);
    }

    @Override
    public Hashtable<?, ?> getEnv() {
        return this.myEnv;
    }

    public Context getServerContext() {
        if (serverContext == null && this.factory != null) {
            try {
                serverContext = this.factory.createComponentContext("server");
            }
            catch (NamingException e) {
                logger.log(BasicLevel.ERROR, (Object)("cannot create serverContext:" + e));
            }
        }
        return serverContext;
    }
}

