/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.web.tomcat6.ws;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardWrapper;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityCollection;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.startup.ContextConfig;
import org.ow2.jonas.deployment.web.WebContainerDeploymentDesc;
import org.ow2.jonas.lib.security.PermissionManagerException;
import org.ow2.jonas.web.base.lib.PermissionManager;
import org.ow2.jonas.web.tomcat6.JOnASStandardContext;
import org.ow2.jonas.web.tomcat6.Tomcat6Service;
import org.ow2.jonas.web.tomcat6.security.Realm;
import org.ow2.jonas.web.tomcat6.ws.URLUtils;
import org.ow2.jonas.web.tomcat6.ws.WebServiceEndpointStandardWrapper;
import org.ow2.jonas.web.tomcat6.ws.security.SecureWebDeploymentDescBuilder;
import org.ow2.jonas.web.tomcat6.ws.strategy.EjbJarContextNamingStrategy;
import org.ow2.jonas.ws.jaxws.IWebservicesContainer;
import org.ow2.jonas.ws.jaxws.IWebservicesModule;
import org.ow2.jonas.ws.jaxws.PortMetaData;
import org.ow2.jonas.ws.jaxws.WSException;
import org.ow2.jonas.ws.jaxws.ejb.IEJBWebserviceEndpoint;
import org.ow2.jonas.ws.jaxws.ejb.ISecurityConstraint;
import org.ow2.jonas.ws.jaxws.ejb.IWebDeployer;
import org.ow2.jonas.ws.jaxws.ejb.context.ContextNamingStrategyException;
import org.ow2.jonas.ws.jaxws.ejb.context.IContextNamingInfo;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebservicesWebDeployer
implements IWebDeployer {
    private static Log logger = LogFactory.getLog(WebservicesWebDeployer.class);
    private Tomcat6Service tomcatService;
    private String workDirectory;

    public WebservicesWebDeployer(Tomcat6Service tomcatService) {
        this.tomcatService = tomcatService;
    }

    public void setWorkDirectory(String workDirectory) {
        this.workDirectory = workDirectory;
    }

    @Override
    public void deploy(IWebservicesModule<? extends IWebservicesContainer<? extends IEJBWebserviceEndpoint>> module) throws WSException {
        logger.debug("Deploying WsModule {0}", module.getName());
        Map<WebContext, List<IEJBWebserviceEndpoint>> endpoints = this.getWebContextPartitions(module);
        for (Map.Entry<WebContext, List<IEJBWebserviceEndpoint>> entry : endpoints.entrySet()) {
            this.deployEndpoints(entry.getKey(), entry.getValue());
        }
    }

    protected void deployEndpoints(WebContext webContext, List<IEJBWebserviceEndpoint> endpoints) throws WSException {
        logger.debug("Deploying Web Context {0}", webContext.getContextName());
        JOnASStandardContext context = this.createWebservicesContext(webContext.getContextName());
        Host host = this.getDefaultHost();
        this.configureSecurityRealm(host, context, webContext, endpoints);
        for (IEJBWebserviceEndpoint endpoint : endpoints) {
            this.configureWebservicesServlet(context, endpoint);
            PortMetaData pmd = endpoint.getPortMetaData();
            String url = URLUtils.getEndpointURL(pmd, host);
            pmd.setEndpointURL(url);
        }
        host.addChild((Container)context);
    }

    private void configureSecurityRealm(Host host, JOnASStandardContext context, WebContext webContext, List<IEJBWebserviceEndpoint> endpoints) throws WSException {
        Realm realm = null;
        if (webContext.getRealmName() != null) {
            realm = this.tomcatService.createJOnASRealm(webContext.getRealmName(), true);
        } else if (webContext.getJaasEntry() != null) {
            realm = this.tomcatService.createJOnASRealm(webContext.getJaasEntry(), false);
        } else {
            org.apache.catalina.Realm parentRealm = host.getRealm();
            if (parentRealm != null && parentRealm instanceof Realm) {
                try {
                    realm = (Realm)((Realm)parentRealm).clone();
                }
                catch (CloneNotSupportedException cnse) {
                    String err = "Cannot clone the realm used by the existing context or its parent realm";
                    throw new WSException(err, cnse);
                }
            }
        }
        if (realm != null) {
            String contextId = host.getName() + context.getPath();
            WebContainerDeploymentDesc dd = this.createWebDeploymentDescriptor(endpoints);
            PermissionManager permissionManager = this.createPermissionManager(contextId, dd);
            realm.setPermissionManager(permissionManager);
            context.setWebDeploymentDescriptor(dd);
            realm.setContext((Context)context);
            context.setRealm((org.apache.catalina.Realm)realm);
        }
    }

    private PermissionManager createPermissionManager(String contextId, WebContainerDeploymentDesc dd) throws WSException {
        PermissionManager manager = null;
        try {
            manager = new PermissionManager(dd, contextId, true);
            manager.translateServletDeploymentDescriptor();
            manager.commit();
        }
        catch (PermissionManagerException e) {
            throw new WSException("Cannot construct PermissionManager", e);
        }
        return manager;
    }

    private WebContainerDeploymentDesc createWebDeploymentDescriptor(List<IEJBWebserviceEndpoint> endpoints) throws WSException {
        SecureWebDeploymentDescBuilder builder = new SecureWebDeploymentDescBuilder();
        ArrayList<ISecurityConstraint> constraints = new ArrayList<ISecurityConstraint>();
        for (IEJBWebserviceEndpoint endpoint : endpoints) {
            ISecurityConstraint sc = endpoint.getSecurityConstraint();
            if (sc == null) continue;
            constraints.add(sc);
        }
        return builder.createJOnASWebDescriptor(constraints);
    }

    @Override
    public void undeploy(IWebservicesModule<? extends IWebservicesContainer<? extends IEJBWebserviceEndpoint>> module) {
        logger.debug("Undeploying WsModule {0}", module.getName());
        List<String> contextsToBeUndeployed = this.getAssociatedWebContexts(module);
        for (String contextName : contextsToBeUndeployed) {
            Realm ctxRealm;
            PermissionManager manager;
            Context context;
            Host host = this.getDefaultHost();
            if (host == null || (context = (Context)host.findChild(contextName)) == null) continue;
            logger.debug("Undeploying Web Context {0}", contextName);
            String path = context.getDocBase();
            File docBase = new File(path);
            if (docBase.isDirectory()) {
                docBase.delete();
            }
            host.removeChild((Container)context);
            org.apache.catalina.Realm realm = context.getRealm();
            if (realm == null || !(realm instanceof Realm) || (manager = (ctxRealm = (Realm)realm).getPermissionManager()) == null) continue;
            try {
                manager.delete();
            }
            catch (PermissionManagerException pme) {
                logger.debug("Cannot delete PermissionManager of Context ''{0}''", contextName, pme);
            }
        }
    }

    protected List<String> getAssociatedWebContexts(IWebservicesModule<? extends IWebservicesContainer<? extends IEJBWebserviceEndpoint>> module) {
        ArrayList<String> contexts = new ArrayList<String>();
        for (IWebservicesContainer<? extends IEJBWebserviceEndpoint> iWebservicesContainer : module.getContainers()) {
            for (IEJBWebserviceEndpoint iEJBWebserviceEndpoint : iWebservicesContainer.getEndpoints()) {
                Map<String, Object> infos = iEJBWebserviceEndpoint.getDeploymentInfos();
                String name = (String)infos.get("context-name");
                contexts.add(name);
            }
        }
        return contexts;
    }

    private void configureWebservicesServlet(StandardContext context, IEJBWebserviceEndpoint endpoint) {
        StandardWrapper wrapper = this.wrapWebserviceEndpoint(endpoint);
        this.configureSecurityConstraints(context, endpoint);
        logger.debug("Added Wrapper/Servlet: {0}", wrapper);
        context.addChild((Container)wrapper);
        String pattern = endpoint.getPortMetaData().getUrlPattern();
        context.addServletMapping(pattern, wrapper.getServletName());
    }

    private void configureSecurityConstraints(StandardContext context, IEJBWebserviceEndpoint endpoint) {
        String method2;
        if (endpoint.getSecurityConstraint() == null) {
            return;
        }
        ISecurityConstraint security = endpoint.getSecurityConstraint();
        SecurityConstraint constraint = new SecurityConstraint();
        constraint.setUserConstraint(security.getTransportGuarantee());
        for (String role : security.getRoleNames()) {
            constraint.addAuthRole(role);
        }
        SecurityCollection collection = new SecurityCollection();
        collection.addPattern(security.getUrlPattern());
        if (security.getHttpMethods() != null) {
            for (String method2 : security.getHttpMethods()) {
                collection.addMethod(method2);
            }
        }
        constraint.addCollection(collection);
        context.addConstraint(constraint);
        for (String role : security.getRoleNames()) {
            context.addSecurityRole(role);
        }
        LoginConfig loginConfig = new LoginConfig();
        method2 = security.getAuthMethod();
        if (method2 == null) {
            method2 = "BASIC";
        } else if ("FORM".equals(method2) || "NONE".equals(method2)) {
            logger.warn("This is an error to set auth-method to ''{0}'', changing it to ''BASIC''", method2);
            method2 = "BASIC";
        }
        loginConfig.setAuthMethod(method2);
        loginConfig.setRealmName(security.getRealmName());
        context.setLoginConfig(loginConfig);
    }

    private Map<WebContext, List<IEJBWebserviceEndpoint>> getWebContextPartitions(IWebservicesModule<? extends IWebservicesContainer<? extends IEJBWebserviceEndpoint>> module) throws WSException {
        HashMap<WebContext, List<IEJBWebserviceEndpoint>> endpoints = new HashMap<WebContext, List<IEJBWebserviceEndpoint>>();
        Host host = this.getDefaultHost();
        for (IWebservicesContainer<? extends IEJBWebserviceEndpoint> iWebservicesContainer : module.getContainers()) {
            for (IEJBWebserviceEndpoint iEJBWebserviceEndpoint : iWebservicesContainer.getEndpoints()) {
                ArrayList<IEJBWebserviceEndpoint> list;
                String contextName = this.getContextRoot(iEJBWebserviceEndpoint);
                String realmName = null;
                String jaasEntry = null;
                if (iEJBWebserviceEndpoint.getSecurityConstraint() != null) {
                    realmName = iEJBWebserviceEndpoint.getSecurityConstraint().getRealmName();
                }
                WebContext key = new WebContext(contextName, realmName, jaasEntry);
                if (host.findChild(contextName) != null) {
                    throw new WSException("Context '" + contextName + "' already deployed in Host '" + host + "'");
                }
                if (endpoints.containsKey(key)) {
                    list = (ArrayList<IEJBWebserviceEndpoint>)endpoints.get(key);
                    list.add(iEJBWebserviceEndpoint);
                    continue;
                }
                if (this.findWebContext(endpoints.keySet(), contextName) == null) {
                    list = new ArrayList<IEJBWebserviceEndpoint>();
                    list.add(iEJBWebserviceEndpoint);
                    endpoints.put(key, list);
                    continue;
                }
                WebContext ctx = this.findWebContext(endpoints.keySet(), contextName);
                List endpointsGroup = (List)endpoints.get(ctx);
                StringBuilder sb = new StringBuilder();
                sb.append("Context '");
                sb.append(contextName);
                sb.append("' for Bean WSEndpoint '");
                sb.append(iEJBWebserviceEndpoint.getContextNamingInfo().getBeanName());
                sb.append("' is incompatible in regards to security with a context used by beans [");
                for (IEJBWebserviceEndpoint ep : endpointsGroup) {
                    sb.append(ep.getContextNamingInfo().getBeanName());
                    sb.append(" ");
                }
                sb.append("]. ");
                sb.append("Specify the <session>/<context-root> element in the META-INF/easybeans.xml ");
                sb.append("or set compatibles <session>/<realm-name> (or <session>/<jaas-entry>)");
                throw new WSException(sb.toString());
            }
        }
        return endpoints;
    }

    private WebContext findWebContext(Set<WebContext> contexts, String name) {
        for (WebContext webContext : contexts) {
            if (!name.equals(webContext.getContextName())) continue;
            return webContext;
        }
        return null;
    }

    private Host getDefaultHost() {
        return this.tomcatService.findHost(null);
    }

    protected JOnASStandardContext createWebservicesContext(String contextName) {
        JOnASStandardContext context = new JOnASStandardContext(false, true, false);
        context.setPath(contextName);
        context.setTomcatService(this.tomcatService);
        File docBase = new File(this.workDirectory, contextName);
        if (!docBase.exists()) {
            docBase.mkdirs();
        }
        context.setDocBase(docBase.getPath());
        context.addLifecycleListener(new WebservicesContextLifecycleListener());
        context.addLifecycleListener((LifecycleListener)new ContextConfig());
        return context;
    }

    private String getContextRoot(IEJBWebserviceEndpoint endpoint) throws WSException {
        String name = endpoint.getPortMetaData().getContextRoot();
        if (name == null) {
            EjbJarContextNamingStrategy strategy = new EjbJarContextNamingStrategy();
            try {
                name = strategy.getContextName(endpoint.getContextNamingInfo());
            }
            catch (ContextNamingStrategyException e) {
                throw new WSException("Cannot define a web context name for endpoint " + endpoint, e);
            }
        }
        if (!name.startsWith("/")) {
            name = "/" + name;
        }
        endpoint.getPortMetaData().setContextRoot(name);
        endpoint.getDeploymentInfos().put("context-name", name);
        return name;
    }

    protected StandardWrapper wrapWebserviceEndpoint(IEJBWebserviceEndpoint endpoint) {
        IContextNamingInfo info = endpoint.getContextNamingInfo();
        WebServiceEndpointStandardWrapper wrapper = new WebServiceEndpointStandardWrapper(endpoint, info.getBeanName());
        wrapper.setParentClassLoader(this.getClass().getClassLoader());
        return wrapper;
    }

    private static class WebContext {
        private String contextName;
        private String realmName;
        private String jaasEntry;

        public WebContext(String name, String realmName, String jaasEntry) {
            this.contextName = name;
            this.realmName = realmName;
            this.jaasEntry = jaasEntry;
        }

        public String getContextName() {
            return this.contextName;
        }

        public String getRealmName() {
            return this.realmName;
        }

        public String getJaasEntry() {
            return this.jaasEntry;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WebContext that = (WebContext)o;
            if (this.contextName != null ? !this.contextName.equals(that.contextName) : that.contextName != null) {
                return false;
            }
            if (this.jaasEntry != null ? !this.jaasEntry.equals(that.jaasEntry) : that.jaasEntry != null) {
                return false;
            }
            return !(this.realmName != null ? !this.realmName.equals(that.realmName) : that.realmName != null);
        }

        public int hashCode() {
            int result = this.contextName != null ? this.contextName.hashCode() : 0;
            result = 31 * result + (this.realmName != null ? this.realmName.hashCode() : 0);
            result = 31 * result + (this.jaasEntry != null ? this.jaasEntry.hashCode() : 0);
            return result;
        }
    }

    private static class WebservicesContextLifecycleListener
    implements LifecycleListener {
        private WebservicesContextLifecycleListener() {
        }

        public void lifecycleEvent(LifecycleEvent lifecycleEvent) {
            if ("start".equals(lifecycleEvent.getType())) {
                Context ctx = (Context)lifecycleEvent.getLifecycle();
                ctx.setConfigured(true);
            } else if ("after_start".equals(lifecycleEvent.getType())) {
                String[] listeners;
                Context ctx = (Context)lifecycleEvent.getLifecycle();
                for (String listener : listeners = ctx.findApplicationListeners()) {
                    ctx.removeApplicationListener(listener);
                }
            }
        }
    }
}

