/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.util.plan.fetcher.impl.maven2.activator;

import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.plan.fetcher.api.IResourceFetcherFactory;
import org.ow2.util.plan.fetcher.impl.maven2.Maven2ResourceFetcherFactory;
import org.ow2.util.plan.repository.api.IRepositoryManager;

public class Maven2FetcherActivator
implements BundleActivator,
ServiceListener {
    private Log logger = LogFactory.getLog(Maven2FetcherActivator.class);
    Maven2ResourceFetcherFactory fetcherFactory = null;
    private ServiceRegistration maven2FetcherFactoryServiceRegistration = null;
    private BundleContext bundleContext = null;
    private static final String LISTENER_FILTER_STRING = "(objectClass=" + IRepositoryManager.class.getName() + ")";

    public void start(BundleContext context) throws Exception {
        this.bundleContext = context;
        this.fetcherFactory = new Maven2ResourceFetcherFactory();
        ServiceReference repositoryManagerRef = context.getServiceReference(IRepositoryManager.class.getName());
        if (repositoryManagerRef != null) {
            this.fetcherFactory.setRepositoryManager((IRepositoryManager)context.getService(repositoryManagerRef));
        }
        this.maven2FetcherFactoryServiceRegistration = context.registerService(IResourceFetcherFactory.class.getName(), (Object)this.fetcherFactory, null);
        context.addServiceListener((ServiceListener)this, LISTENER_FILTER_STRING);
    }

    public void stop(BundleContext context) throws Exception {
        this.maven2FetcherFactoryServiceRegistration.unregister();
    }

    public void serviceChanged(ServiceEvent event) {
        ServiceReference serviceRef = event.getServiceReference();
        Object serviceObject = this.bundleContext.getService(serviceRef);
        if (serviceObject instanceof IRepositoryManager) {
            IRepositoryManager repositoryManager = (IRepositoryManager)serviceObject;
            switch (event.getType()) {
                case 1: {
                    if (this.fetcherFactory.getRepositoryManager() != null) break;
                    this.fetcherFactory.setRepositoryManager(repositoryManager);
                    this.logger.debug("The repository manager is set to '''{0}'''.", repositoryManager);
                    break;
                }
                case 4: {
                    this.fetcherFactory.setRepositoryManager(null);
                    this.logger.debug("The repository manager is unset", new Object[0]);
                    break;
                }
            }
        }
    }
}

