/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.agent;

import fr.dyade.aaa.agent.AgentServer;
import fr.dyade.aaa.agent.PoolNetwork;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public final class SSLNetwork
extends PoolNetwork {
    public static final String SSLCONTEXT = "fr.dyade.aaa.agent.SSLNetwork.SSLContext";
    public static final String KTYPE = "fr.dyade.aaa.agent.SSLNetwork.KeyStoreType";
    public static final String PASS = "SSLNetwork.pass";
    public static final String KEYFILE = "SSLNetwork.keyfile";
    SSLSocketFactory socketFactory = null;
    SSLServerSocketFactory serverSocketFactory = null;

    public SSLNetwork() throws Exception {
        this.name = "SSLNetwork#" + AgentServer.getServerId();
        char[] pass = AgentServer.getProperty(PASS, "changeit").toCharArray();
        String keyFile = AgentServer.getProperty(KEYFILE, ".keystore");
        KeyStore keystore = KeyStore.getInstance(AgentServer.getProperty(KTYPE, "JKS"));
        keystore.load(new FileInputStream(keyFile), pass);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keystore, pass);
        TrustManagerFactory tmf = TrustManagerFactory.getInstance("SunX509");
        tmf.init(keystore);
        SSLContext ctx = SSLContext.getInstance(AgentServer.getProperty(SSLCONTEXT, "TLS"));
        ctx.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
        this.socketFactory = ctx.getSocketFactory();
        this.serverSocketFactory = ctx.getServerSocketFactory();
    }

    ServerSocket createServerSocket(int port) throws IOException {
        ServerSocket serverSocket = this.serverSocketFactory.createServerSocket(port, this.backlog, this.inLocalAddr);
        ((SSLServerSocket)serverSocket).setNeedClientAuth(true);
        return serverSocket;
    }

    Socket createSocket(InetAddress addr, int port) throws IOException {
        if (addr == null) {
            throw new UnknownHostException();
        }
        return this.socketFactory.createSocket(addr, port, this.outLocalAddr, this.outLocalPort);
    }
}

