/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.admin;

import java.io.Reader;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.objectweb.joram.client.jms.ConnectionFactory;
import org.objectweb.joram.client.jms.Destination;
import org.objectweb.joram.client.jms.Queue;
import org.objectweb.joram.client.jms.Topic;
import org.objectweb.joram.client.jms.admin.AbstractConnectionFactory;
import org.objectweb.joram.client.jms.admin.AdminModule;
import org.objectweb.joram.client.jms.admin.ClusterConnectionFactory;
import org.objectweb.joram.client.jms.admin.ClusterQueue;
import org.objectweb.joram.client.jms.admin.ClusterTopic;
import org.objectweb.joram.client.jms.admin.DeadMQueue;
import org.objectweb.joram.client.jms.admin.User;
import org.objectweb.joram.client.jms.ha.tcp.TopicHATcpConnectionFactory;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.joram.shared.security.SimpleIdentity;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class JoramSaxWrapper
extends DefaultHandler {
    public static final String SCN = "scn:comp/";
    public static final String HASCN = "hascn:comp/";
    static final String ELT_JORAMADMIN = "JoramAdmin";
    static final String ELT_ADMINMODULE = "AdminModule";
    static final String ELT_CONNECT = "connect";
    static final String ELT_HACONNECT = "haConnect";
    static final String ELT_COLLOCATEDCONNECT = "collocatedConnect";
    static final String ELT_CONNECTIONFACTORY = "ConnectionFactory";
    static final String ELT_TCP = "tcp";
    static final String ELT_LOCAL = "local";
    static final String ELT_HATCP = "hatcp";
    static final String ELT_HALOCAL = "halocal";
    static final String ELT_SOAP = "soap";
    static final String ELT_JNDI = "jndi";
    static final String ELT_SERVER = "Server";
    static final String ELT_USER = "User";
    static final String ELT_DESTINATION = "Destination";
    static final String ELT_QUEUE = "Queue";
    static final String ELT_TOPIC = "Topic";
    static final String ELT_DMQUEUE = "DMQueue";
    static final String ELT_PROPERTY = "property";
    static final String ELT_READER = "reader";
    static final String ELT_WRITER = "writer";
    static final String ELT_FREEREADER = "freeReader";
    static final String ELT_FREEWRITER = "freeWriter";
    static final String ELT_INITIALCONTEXT = "InitialContext";
    static final String ELT_CLUSTER_CF = "ClusterCF";
    static final String ELT_CLUSTER_QUEUE = "ClusterQueue";
    static final String ELT_CLUSTER_TOPIC = "ClusterTopic";
    static final String ELT_CLUSTER_ELEMENT = "ClusterElement";
    static final String ATT_NAME = "name";
    static final String ATT_LOGIN = "login";
    static final String ATT_PASSWORD = "password";
    static final String ATT_VALUE = "value";
    static final String ATT_HOST = "host";
    static final String ATT_PORT = "port";
    static final String ATT_CNXTIMER = "cnxTimer";
    static final String ATT_RELIABLECLASS = "reliableClass";
    static final String ATT_URL = "url";
    static final String ATT_TIMEOUT = "timeout";
    static final String ATT_SERVERID = "serverId";
    static final String ATT_TYPE = "type";
    static final String ATT_CLASSNAME = "className";
    static final String ATT_USER = "user";
    static final String ATT_DMQ = "dmq";
    static final String ATT_NBMAXMSG = "nbMaxMsg";
    static final String ATT_PARENT = "parent";
    static final String ATT_THRESHOLD = "threshold";
    static final String ATT_LOCATION = "location";
    static final String ATT_IDENTITYCLASS = "identityClass";
    static final String DFLT_LISTEN_HOST = "localhost";
    static final int DFLT_LISTEN_PORT = 16010;
    static final String DFLT_HA_URL = "hajoram://localhost:2560,localhost:2561,localhost:2562";
    static final String DFLT_CF = "org.objectweb.joram.client.jms.tcp.TcpConnectionFactory";
    boolean result = true;
    Object obj = null;
    String name = null;
    String login = null;
    String password = null;
    String value = null;
    String host = null;
    int port = -1;
    int cnxTimer = -1;
    String reliableClass = null;
    String url = null;
    int timeout = -1;
    int serverId = -1;
    String className = null;
    String user = null;
    String type = null;
    Properties properties = null;
    String identityClass = null;
    String jndiName = null;
    Hashtable toBind = new Hashtable();
    Vector readers = new Vector();
    Vector writers = new Vector();
    boolean freeReading = false;
    boolean freeWriting = false;
    InitialContext jndiCtx = null;
    Hashtable cfs = new Hashtable();
    Hashtable users = new Hashtable();
    Hashtable queues = new Hashtable();
    Hashtable topics = new Hashtable();
    Hashtable dmqs = new Hashtable();
    Hashtable cluster = new Hashtable();
    String dmq = null;
    int threshold = -1;
    int nbMaxMsg = -1;
    String parent = null;
    String joramAdmName = "default";
    String conf = null;
    Logger logger = null;

    public boolean parse(Reader cfgReader, String cfgName) throws Exception {
        this.joramAdmName = cfgName;
        this.logger = JoramTracing.dbgAdmin;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        SAXParser parser2 = factory.newSAXParser();
        parser2.parse(new InputSource(cfgReader), (DefaultHandler)this);
        return this.result;
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.logger.log(BasicLevel.FATAL, (Object)("fatal error parsing " + e.getPublicId() + " at " + e.getLineNumber() + "." + e.getColumnNumber()));
        throw e;
    }

    public void error(SAXParseException e) throws SAXException {
        this.logger.log(BasicLevel.ERROR, (Object)("error parsing " + e.getPublicId() + " at " + e.getLineNumber() + "." + e.getColumnNumber()));
        throw e;
    }

    public void warning(SAXParseException e) throws SAXException {
        if (this.logger.isLoggable(BasicLevel.WARN)) {
            this.logger.log(BasicLevel.WARN, (Object)("warning parsing " + e.getPublicId() + " at " + e.getLineNumber() + "." + e.getColumnNumber()));
        }
        throw e;
    }

    private final boolean isSet(String value) {
        return value != null && value.length() > 0;
    }

    public void startDocument() throws SAXException {
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)"startDocument");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String uri, String localName, String rawName, Attributes atts) throws SAXException {
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)("startElement: " + rawName));
        }
        if (rawName.equals(ELT_JORAMADMIN)) {
            this.conf = atts.getValue(ATT_NAME);
            if (this.conf != null) return;
            this.conf = this.joramAdmName;
            return;
        }
        if (!this.joramAdmName.equals(this.conf) || rawName.equals(ELT_ADMINMODULE)) return;
        if (rawName.equals(ELT_CONNECT)) {
            try {
                try {
                    String value;
                    this.host = atts.getValue(ATT_HOST);
                    if (!this.isSet(this.host)) {
                        this.host = DFLT_LISTEN_HOST;
                    }
                    this.port = (value = atts.getValue(ATT_PORT)) == null ? 16010 : Integer.parseInt(value);
                    this.name = atts.getValue(ATT_NAME);
                    if (!this.isSet(this.name)) {
                        this.name = AbstractConnectionFactory.getDefaultRootLogin();
                    }
                    this.password = atts.getValue(ATT_PASSWORD);
                    if (!this.isSet(this.password)) {
                        this.password = AbstractConnectionFactory.getDefaultRootPassword();
                    }
                    this.cnxTimer = (value = atts.getValue(ATT_CNXTIMER)) == null ? 60 : Integer.parseInt(value);
                    this.reliableClass = atts.getValue(ATT_RELIABLECLASS);
                    this.identityClass = atts.getValue(ATT_IDENTITYCLASS);
                    if (this.isSet(this.identityClass)) return;
                    this.identityClass = SimpleIdentity.class.getName();
                    return;
                }
                catch (NumberFormatException exc) {
                    throw new Exception("bad value for port: " + atts.getValue(ATT_PORT) + " or cnxTimer: " + atts.getValue(ATT_CNXTIMER));
                }
            }
            catch (Exception exc) {
                throw new SAXException(exc.getMessage(), exc);
            }
        }
        if (rawName.equals(ELT_HACONNECT)) {
            try {
                try {
                    this.url = atts.getValue(ATT_URL);
                    if (!this.isSet(this.url)) {
                        this.url = DFLT_HA_URL;
                    }
                    this.name = atts.getValue(ATT_NAME);
                    if (!this.isSet(this.name)) {
                        this.name = AbstractConnectionFactory.getDefaultRootLogin();
                    }
                    this.password = atts.getValue(ATT_PASSWORD);
                    if (!this.isSet(this.password)) {
                        this.password = AbstractConnectionFactory.getDefaultRootPassword();
                    }
                    this.value = atts.getValue(ATT_CNXTIMER);
                    this.cnxTimer = this.value == null ? 60 : Integer.parseInt(this.value);
                    this.identityClass = atts.getValue(ATT_IDENTITYCLASS);
                    if (this.isSet(this.identityClass)) return;
                    this.identityClass = SimpleIdentity.class.getName();
                    return;
                }
                catch (NumberFormatException exc) {
                    throw new Exception("cnxTimer: " + atts.getValue(ATT_CNXTIMER));
                }
            }
            catch (Exception exc) {
                throw new SAXException(exc.getMessage(), exc);
            }
        }
        if (rawName.equals(ELT_COLLOCATEDCONNECT)) {
            try {
                this.name = atts.getValue(ATT_NAME);
                if (!this.isSet(this.name)) {
                    this.name = AbstractConnectionFactory.getDefaultRootLogin();
                }
                this.password = atts.getValue(ATT_PASSWORD);
                if (!this.isSet(this.password)) {
                    this.password = AbstractConnectionFactory.getDefaultRootPassword();
                }
                this.identityClass = atts.getValue(ATT_IDENTITYCLASS);
                if (this.isSet(this.identityClass)) return;
                this.identityClass = SimpleIdentity.class.getName();
                return;
            }
            catch (Exception exc) {
                throw new SAXException(exc.getMessage(), exc);
            }
        }
        if (rawName.equals(ELT_CONNECTIONFACTORY)) {
            try {
                this.name = atts.getValue(ATT_NAME);
                this.className = atts.getValue(ATT_CLASSNAME);
                if (!this.isSet(this.className)) {
                    this.className = DFLT_CF;
                }
                this.identityClass = atts.getValue(ATT_IDENTITYCLASS);
                return;
            }
            catch (Exception exc) {
                throw new SAXException(exc.getMessage(), exc);
            }
        }
        if (rawName.equals(ELT_TCP)) {
            try {
                try {
                    String value;
                    this.host = atts.getValue(ATT_HOST);
                    if (!this.isSet(this.host)) {
                        this.host = DFLT_LISTEN_HOST;
                    }
                    this.port = (value = atts.getValue(ATT_PORT)) == null ? 16010 : Integer.parseInt(value);
                    this.reliableClass = atts.getValue(ATT_RELIABLECLASS);
                    return;
                }
                catch (NumberFormatException exc) {
                    throw new Exception("bad value for port: " + atts.getValue(ATT_PORT));
                }
            }
            catch (Exception exc) {
                throw new SAXException(exc.getMessage(), exc);
            }
        }
        if (rawName.equals(ELT_LOCAL)) return;
        if (rawName.equals(ELT_HATCP)) {
            try {
                this.url = atts.getValue(ATT_URL);
                this.reliableClass = atts.getValue(ATT_RELIABLECLASS);
                return;
            }
            catch (Exception exc) {
                throw new SAXException(exc.getMessage(), exc);
            }
        }
        if (rawName.equals(ELT_HALOCAL)) return;
        if (rawName.equals(ELT_SOAP)) {
            try {
                try {
                    String value;
                    this.host = atts.getValue(ATT_HOST);
                    if (!this.isSet(this.host)) {
                        this.host = DFLT_LISTEN_HOST;
                    }
                    this.port = (value = atts.getValue(ATT_PORT)) == null ? 16010 : Integer.parseInt(value);
                    value = atts.getValue(ATT_TIMEOUT);
                    if (value == null) {
                        this.timeout = 60;
                        return;
                    }
                    this.timeout = Integer.parseInt(value);
                    return;
                }
                catch (NumberFormatException exc) {
                    throw new Exception("bad value for port: " + atts.getValue(ATT_PORT));
                }
            }
            catch (Exception exc) {
                throw new SAXException(exc.getMessage(), exc);
            }
        }
        if (rawName.equals(ELT_JNDI)) {
            try {
                this.jndiName = atts.getValue(ATT_NAME);
                return;
            }
            catch (Exception exc) {
                throw new SAXException(exc.getMessage(), exc);
            }
        }
        if (rawName.equals(ELT_SERVER)) {
            try {
                try {
                    String value = atts.getValue(ATT_SERVERID);
                    this.serverId = value == null ? AdminModule.getLocalServerId() : Integer.parseInt(value);
                }
                catch (NumberFormatException exc) {
                    throw new Exception("bad value for serverId: " + atts.getValue(ATT_SERVERID));
                }
                this.dmq = atts.getValue(ATT_DMQ);
                this.value = atts.getValue(ATT_THRESHOLD);
                try {
                    if (this.value == null) {
                        this.threshold = -1;
                        return;
                    }
                    this.threshold = Integer.parseInt(this.value);
                    return;
                }
                catch (NumberFormatException exc) {
                    throw new Exception("bad value for threshold: " + atts.getValue(ATT_THRESHOLD));
                }
            }
            catch (Exception exc) {
                throw new SAXException(exc.getMessage(), exc);
            }
        }
        if (rawName.equals(ELT_USER)) {
            try {
                try {
                    this.name = atts.getValue(ATT_NAME);
                    this.login = atts.getValue(ATT_LOGIN);
                    this.password = atts.getValue(ATT_PASSWORD);
                    String value = atts.getValue(ATT_SERVERID);
                    this.serverId = value == null ? AdminModule.getLocalServerId() : Integer.parseInt(value);
                    this.dmq = atts.getValue(ATT_DMQ);
                    value = atts.getValue(ATT_THRESHOLD);
                    this.threshold = value == null ? -1 : Integer.parseInt(value);
                    this.identityClass = atts.getValue(ATT_IDENTITYCLASS);
                    return;
                }
                catch (NumberFormatException exc) {
                    throw new Exception("bad value for serverId: " + atts.getValue(ATT_SERVERID));
                }
            }
            catch (Exception exc) {
                throw new SAXException(exc.getMessage(), exc);
            }
        }
        if (rawName.equals(ELT_DESTINATION)) {
            try {
                try {
                    this.type = atts.getValue(ATT_TYPE);
                    this.name = atts.getValue(ATT_NAME);
                    String value = atts.getValue(ATT_SERVERID);
                    this.serverId = value == null ? AdminModule.getLocalServerId() : Integer.parseInt(value);
                    this.className = atts.getValue(ATT_CLASSNAME);
                    this.dmq = atts.getValue(ATT_DMQ);
                    return;
                }
                catch (NumberFormatException exc) {
                    throw new Exception("bad value for serverId: " + atts.getValue(ATT_SERVERID));
                }
            }
            catch (Exception exc) {
                throw new SAXException(exc.getMessage(), exc);
            }
        }
        if (rawName.equals(ELT_QUEUE)) {
            try {
                try {
                    this.name = atts.getValue(ATT_NAME);
                    String value = atts.getValue(ATT_SERVERID);
                    this.serverId = value == null ? AdminModule.getLocalServerId() : Integer.parseInt(value);
                    this.className = atts.getValue(ATT_CLASSNAME);
                    this.dmq = atts.getValue(ATT_DMQ);
                    value = atts.getValue(ATT_THRESHOLD);
                    this.threshold = value == null ? -1 : Integer.parseInt(value);
                    value = atts.getValue(ATT_NBMAXMSG);
                    if (value == null) {
                        this.nbMaxMsg = -1;
                        return;
                    }
                    this.nbMaxMsg = Integer.parseInt(value);
                    return;
                }
                catch (NumberFormatException exc) {
                    throw new Exception("bad value for serverId: " + atts.getValue(ATT_SERVERID));
                }
            }
            catch (Exception exc) {
                throw new SAXException(exc.getMessage(), exc);
            }
        }
        if (rawName.equals(ELT_TOPIC)) {
            try {
                try {
                    this.name = atts.getValue(ATT_NAME);
                    String value = atts.getValue(ATT_SERVERID);
                    this.serverId = value == null ? AdminModule.getLocalServerId() : Integer.parseInt(value);
                    this.className = atts.getValue(ATT_CLASSNAME);
                    this.dmq = atts.getValue(ATT_DMQ);
                    this.parent = atts.getValue(ATT_PARENT);
                    return;
                }
                catch (NumberFormatException exc) {
                    throw new Exception("bad value for serverId: " + atts.getValue(ATT_SERVERID));
                }
            }
            catch (Exception exc) {
                throw new SAXException(exc.getMessage(), exc);
            }
        }
        if (rawName.equals(ELT_DMQUEUE)) {
            try {
                try {
                    this.name = atts.getValue(ATT_NAME);
                    String value = atts.getValue(ATT_SERVERID);
                    if (value == null) {
                        this.serverId = AdminModule.getLocalServerId();
                        return;
                    }
                    this.serverId = Integer.parseInt(value);
                    return;
                }
                catch (NumberFormatException exc) {
                    throw new Exception("bad value for serverId: " + atts.getValue(ATT_SERVERID));
                }
            }
            catch (Exception exc) {
                throw new SAXException(exc.getMessage(), exc);
            }
        } else if (rawName.equals(ELT_PROPERTY)) {
            try {
                if (this.properties == null) {
                    this.properties = new Properties();
                }
                this.properties.put(atts.getValue(ATT_NAME), atts.getValue(ATT_VALUE));
                return;
            }
            catch (Exception exc) {
                throw new SAXException(exc.getMessage(), exc);
            }
        } else if (rawName.equals(ELT_READER)) {
            try {
                this.user = atts.getValue(ATT_USER);
                return;
            }
            catch (Exception exc) {
                throw new SAXException(exc.getMessage(), exc);
            }
        } else if (rawName.equals(ELT_WRITER)) {
            try {
                this.user = atts.getValue(ATT_USER);
                return;
            }
            catch (Exception exc) {
                throw new SAXException(exc.getMessage(), exc);
            }
        } else if (rawName.equals(ELT_FREEREADER)) {
            this.freeReading = true;
            return;
        } else if (rawName.equals(ELT_FREEWRITER)) {
            this.freeWriting = true;
            return;
        } else {
            if (rawName.equals(ELT_INITIALCONTEXT)) return;
            if (rawName.equals(ELT_CLUSTER_ELEMENT)) {
                try {
                    this.cluster.put(atts.getValue(ATT_NAME), atts.getValue(ATT_LOCATION));
                    return;
                }
                catch (Exception exc) {
                    throw new SAXException(exc.getMessage(), exc);
                }
            } else if (rawName.equals(ELT_CLUSTER_QUEUE)) {
                this.cluster.clear();
                return;
            } else if (rawName.equals(ELT_CLUSTER_TOPIC)) {
                this.cluster.clear();
                return;
            } else {
                if (!rawName.equals(ELT_CLUSTER_CF)) throw new SAXException("unknown element \"" + rawName + "\"");
                this.cluster.clear();
            }
        }
    }

    public void endElement(String uri, String localName, String rawName) throws SAXException {
        block87: {
            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                this.logger.log(BasicLevel.DEBUG, (Object)("endElement: " + rawName));
            }
            if (rawName.equals(ELT_JORAMADMIN)) {
                this.conf = null;
            } else if (this.joramAdmName.equals(this.conf)) {
                try {
                    if (rawName.equals(ELT_ADMINMODULE)) break block87;
                    if (rawName.equals(ELT_CONNECT)) {
                        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                            this.logger.log(BasicLevel.DEBUG, (Object)("AdminModule.connect(" + this.host + "," + this.port + "," + this.name + "," + "***** ," + this.cnxTimer + "," + this.reliableClass + ")"));
                        }
                        AdminModule.connect(this.host, this.port, this.name, this.password, this.cnxTimer, this.reliableClass, this.identityClass);
                        break block87;
                    }
                    if (rawName.equals(ELT_HACONNECT)) {
                        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                            this.logger.log(BasicLevel.DEBUG, (Object)("AdminModule.haConnect(" + this.url + "," + this.name + "," + "***** ," + this.cnxTimer + ")"));
                        }
                        TopicConnectionFactory tcf = TopicHATcpConnectionFactory.create(this.url);
                        ((ConnectionFactory)tcf).getParameters().connectingTimer = this.cnxTimer;
                        AdminModule.connect(tcf, this.name, this.password, this.identityClass);
                        break block87;
                    }
                    if (rawName.equals(ELT_COLLOCATEDCONNECT)) {
                        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                            this.logger.log(BasicLevel.DEBUG, (Object)("AdminModule.collocatedConnect(" + this.name + "," + "*****)"));
                        }
                        AdminModule.collocatedConnect(this.name, this.password, this.identityClass);
                        break block87;
                    }
                    if (rawName.equals(ELT_CONNECTIONFACTORY)) {
                        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                            this.logger.log(BasicLevel.DEBUG, (Object)("cf \"" + this.name + "\"= " + this.obj));
                        }
                        if (this.isSet(this.identityClass)) {
                            ((AbstractConnectionFactory)this.obj).setIdentityClassName(this.identityClass);
                        }
                        if (this.isSet(this.jndiName)) {
                            this.toBind.put(this.jndiName, this.obj);
                        }
                        this.jndiName = null;
                        if (this.isSet(this.name)) {
                            this.cfs.put(this.name, this.obj);
                        }
                        this.className = null;
                        this.obj = null;
                        this.identityClass = null;
                        break block87;
                    }
                    if (rawName.equals(ELT_TCP)) {
                        Class<?> clazz = Class.forName(this.className);
                        Class[] classParams = new Class[]{new String().getClass(), Integer.TYPE, new String().getClass()};
                        Method methode = clazz.getMethod("create", classParams);
                        Object[] objParams = new Object[]{this.host, new Integer(this.port), this.reliableClass};
                        this.obj = methode.invoke(null, objParams);
                        break block87;
                    }
                    if (rawName.equals(ELT_LOCAL)) {
                        Class<?> clazz = Class.forName(this.className);
                        Method methode = clazz.getMethod("create", new Class[0]);
                        this.obj = methode.invoke(null, new Object[0]);
                        break block87;
                    }
                    if (rawName.equals(ELT_HATCP)) {
                        Class<?> clazz = Class.forName(this.className);
                        Class[] classParams = new Class[]{new String().getClass(), new String().getClass()};
                        Method methode = clazz.getMethod("create", classParams);
                        Object[] objParams = new Object[]{this.url, this.reliableClass};
                        this.obj = methode.invoke(null, objParams);
                        break block87;
                    }
                    if (rawName.equals(ELT_HALOCAL)) {
                        Class<?> clazz = Class.forName(this.className);
                        Method methode = clazz.getMethod("create", new Class[0]);
                        this.obj = methode.invoke(null, new Object[0]);
                        break block87;
                    }
                    if (rawName.equals(ELT_SOAP)) {
                        Class<?> clazz = Class.forName(this.className);
                        Class[] classParams = new Class[]{new String().getClass(), Integer.TYPE, Integer.TYPE};
                        Method methode = clazz.getMethod("create", classParams);
                        Object[] objParams = new Object[]{this.host, new Integer(this.port), new Integer(this.timeout)};
                        this.obj = methode.invoke(null, objParams);
                        break block87;
                    }
                    if (rawName.equals(ELT_JNDI)) break block87;
                    if (rawName.equals(ELT_SERVER)) {
                        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                            this.logger.log(BasicLevel.DEBUG, (Object)("Server.configure(" + this.serverId + ")"));
                        }
                        if (this.threshold > 0) {
                            AdminModule.setDefaultThreshold(this.serverId, this.threshold);
                        }
                        if (this.isSet(this.dmq)) {
                            if (this.dmqs.containsKey(this.dmq)) {
                                AdminModule.setDefaultDMQ(this.serverId, (DeadMQueue)this.dmqs.get(this.dmq));
                            } else {
                                this.logger.log(BasicLevel.ERROR, (Object)("User.create(): Unknown DMQ: " + this.dmq));
                            }
                        }
                        break block87;
                    }
                    if (rawName.equals(ELT_USER)) {
                        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                            this.logger.log(BasicLevel.DEBUG, (Object)("User.create(" + this.name + "," + this.login + "," + "*****," + this.serverId + ")"));
                        }
                        if (!this.isSet(this.login)) {
                            this.login = this.name;
                        }
                        if (!this.isSet(this.identityClass)) {
                            this.identityClass = SimpleIdentity.class.getName();
                        }
                        User user = User.create(this.login, this.password, this.serverId, this.identityClass);
                        this.users.put(this.name, user);
                        if (this.threshold > 0) {
                            user.setThreshold(this.threshold);
                        }
                        if (this.isSet(this.dmq)) {
                            if (this.dmqs.containsKey(this.dmq)) {
                                user.setDMQ((DeadMQueue)this.dmqs.get(this.dmq));
                            } else {
                                this.logger.log(BasicLevel.ERROR, (Object)("User.create(): Unknown DMQ: " + this.dmq));
                            }
                        }
                        break block87;
                    }
                    if (rawName.equals(ELT_DESTINATION)) {
                        Destination dest = null;
                        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                            this.logger.log(BasicLevel.DEBUG, (Object)("dest type =" + this.type));
                        }
                        if (this.type.equals("queue")) {
                            if (this.className == null) {
                                this.className = "org.objectweb.joram.mom.dest.Queue";
                            }
                            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                                this.logger.log(BasicLevel.DEBUG, (Object)("Queue.create(" + this.serverId + "," + this.name + "," + this.className + "," + this.properties + ")"));
                            }
                            dest = Queue.create(this.serverId, this.name, this.className, this.properties);
                        } else if (this.type.equals("topic")) {
                            if (this.className == null) {
                                this.className = "org.objectweb.joram.mom.dest.Topic";
                            }
                            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                                this.logger.log(BasicLevel.DEBUG, (Object)("Topic.create(" + this.serverId + "," + this.name + "," + this.className + "," + this.properties + ")"));
                            }
                            dest = Topic.create(this.serverId, this.name, this.className, this.properties);
                        } else {
                            throw new Exception("type " + this.type + " bad value. (queue or topic)");
                        }
                        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                            this.logger.log(BasicLevel.DEBUG, (Object)("destination = " + dest));
                        }
                        this.properties = null;
                        this.configureDestination(dest);
                        if (this.isSet(this.jndiName)) {
                            this.toBind.put(this.jndiName, dest);
                        }
                        this.jndiName = null;
                        String name = dest.getAdminName();
                        if (!this.isSet(name)) {
                            name = dest.getName();
                        }
                        if (dest instanceof Queue) {
                            this.queues.put(name, dest);
                        } else {
                            this.topics.put(name, dest);
                        }
                        this.setDestinationDMQ(dest, this.dmq);
                        break block87;
                    }
                    if (rawName.equals(ELT_QUEUE)) {
                        if (this.className == null) {
                            this.className = "org.objectweb.joram.mom.dest.Queue";
                        }
                        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                            this.logger.log(BasicLevel.DEBUG, (Object)("Queue.create(" + this.serverId + "," + this.name + "," + this.className + "," + this.properties + ")"));
                        }
                        Queue queue = Queue.create(this.serverId, this.name, this.className, this.properties);
                        this.properties = null;
                        this.configureDestination(queue);
                        if (this.threshold > 0) {
                            queue.setThreshold(this.threshold);
                        }
                        if (this.nbMaxMsg > 0) {
                            queue.setNbMaxMsg(this.nbMaxMsg);
                        }
                        if (this.isSet(this.jndiName)) {
                            this.toBind.put(this.jndiName, queue);
                        }
                        this.jndiName = null;
                        String name = queue.getAdminName();
                        if (!this.isSet(name)) {
                            name = queue.getName();
                        }
                        this.queues.put(name, queue);
                        this.setDestinationDMQ(queue, this.dmq);
                        break block87;
                    }
                    if (rawName.equals(ELT_TOPIC)) {
                        if (this.className == null) {
                            this.className = "org.objectweb.joram.mom.dest.Topic";
                        }
                        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                            this.logger.log(BasicLevel.DEBUG, (Object)("Topic.create(" + this.serverId + "," + this.name + "," + this.className + "," + this.properties + ")"));
                        }
                        Topic topic = Topic.create(this.serverId, this.name, this.className, this.properties);
                        this.properties = null;
                        this.configureDestination(topic);
                        if (this.isSet(this.parent)) {
                            if (this.topics.containsKey(this.parent)) {
                                topic.setParent((Topic)this.topics.get(this.parent));
                            } else {
                                this.logger.log(BasicLevel.ERROR, (Object)("Topic.create(): Unknown parent: " + this.parent));
                            }
                        }
                        if (this.isSet(this.jndiName)) {
                            this.toBind.put(this.jndiName, topic);
                        }
                        this.jndiName = null;
                        String name = topic.getAdminName();
                        if (!this.isSet(name)) {
                            name = topic.getName();
                        }
                        this.topics.put(name, topic);
                        this.setDestinationDMQ(topic, this.dmq);
                        break block87;
                    }
                    if (rawName.equals(ELT_DMQUEUE)) {
                        this.className = "org.objectweb.joram.mom.dest.DeadMQueue";
                        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                            this.logger.log(BasicLevel.DEBUG, (Object)("DeadMQueue.create(" + this.serverId + "," + this.name + ")"));
                        }
                        DeadMQueue dmq = (DeadMQueue)DeadMQueue.create(this.serverId, this.name);
                        this.configureDestination(dmq);
                        if (this.isSet(this.jndiName)) {
                            this.toBind.put(this.jndiName, dmq);
                        }
                        this.jndiName = null;
                        if (this.isSet(this.name)) {
                            this.dmqs.put(this.name, dmq);
                        }
                        break block87;
                    }
                    if (rawName.equals(ELT_PROPERTY)) break block87;
                    if (rawName.equals(ELT_READER)) {
                        this.readers.add(this.user);
                        break block87;
                    }
                    if (rawName.equals(ELT_WRITER)) {
                        this.writers.add(this.user);
                        break block87;
                    }
                    if (rawName.equals(ELT_FREEREADER) || rawName.equals(ELT_FREEWRITER)) break block87;
                    if (rawName.equals(ELT_INITIALCONTEXT)) {
                        try {
                            this.jndiCtx = new InitialContext(this.properties);
                        }
                        catch (NamingException exc) {
                            this.logger.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
                        }
                        break block87;
                    }
                    if (rawName.equals(ELT_CLUSTER_ELEMENT)) break block87;
                    if (rawName.equals(ELT_CLUSTER_CF)) {
                        Map.Entry[] entries = new Map.Entry[this.cluster.size()];
                        this.cluster.entrySet().toArray(entries);
                        ClusterConnectionFactory clusterCF = new ClusterConnectionFactory();
                        for (int i = 0; i < entries.length; ++i) {
                            ConnectionFactory cf = (ConnectionFactory)this.cfs.get(entries[i].getKey());
                            clusterCF.addConnectionFactory((String)entries[i].getValue(), cf);
                        }
                        this.cluster.clear();
                        if (this.isSet(this.jndiName)) {
                            this.toBind.put(this.jndiName, clusterCF);
                        }
                        this.jndiName = null;
                        break block87;
                    }
                    if (rawName.equals(ELT_CLUSTER_QUEUE)) {
                        Map.Entry[] entries = new Map.Entry[this.cluster.size()];
                        this.cluster.entrySet().toArray(entries);
                        ClusterQueue clusterQueue = new ClusterQueue();
                        Queue root = null;
                        for (int i = 0; i < entries.length; ++i) {
                            Queue queue = (Queue)this.queues.get(entries[i].getKey());
                            clusterQueue.addDestination((String)entries[i].getValue(), queue);
                            if (i == 0) {
                                root = queue;
                                continue;
                            }
                            root.addClusteredQueue(queue);
                        }
                        this.cluster.clear();
                        this.configureDestination(clusterQueue);
                        if (this.isSet(this.jndiName)) {
                            this.toBind.put(this.jndiName, clusterQueue);
                        }
                        this.jndiName = null;
                        break block87;
                    }
                    if (rawName.equals(ELT_CLUSTER_TOPIC)) {
                        Map.Entry[] entries = new Map.Entry[this.cluster.size()];
                        this.cluster.entrySet().toArray(entries);
                        ClusterTopic clusterTopic = new ClusterTopic();
                        Topic root = null;
                        for (int i = 0; i < entries.length; ++i) {
                            Topic topic = (Topic)this.topics.get(entries[i].getKey());
                            clusterTopic.addDestination((String)entries[i].getValue(), topic);
                            if (i == 0) {
                                root = topic;
                                continue;
                            }
                            root.addClusteredTopic(topic);
                        }
                        this.cluster.clear();
                        this.configureDestination(clusterTopic);
                        if (this.isSet(this.jndiName)) {
                            this.toBind.put(this.jndiName, clusterTopic);
                        }
                        this.jndiName = null;
                        break block87;
                    }
                    throw new SAXException("unknown element \"" + rawName + "\"");
                }
                catch (SAXException exc) {
                    throw exc;
                }
                catch (Exception exc) {
                    this.logger.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
                    throw new SAXException(exc.getMessage(), exc);
                }
            }
        }
    }

    void configureDestination(Destination dest) throws Exception {
        User u;
        int i;
        if (this.freeReading) {
            dest.setFreeReading();
        }
        this.freeReading = false;
        if (this.freeWriting) {
            dest.setFreeWriting();
        }
        this.freeWriting = false;
        for (i = 0; i < this.readers.size(); ++i) {
            u = (User)this.users.get(this.readers.get(i));
            if (u == null) continue;
            dest.setReader(u);
        }
        this.readers.clear();
        for (i = 0; i < this.writers.size(); ++i) {
            u = (User)this.users.get(this.writers.get(i));
            if (u == null) continue;
            dest.setWriter(u);
        }
        this.writers.clear();
    }

    void setDestinationDMQ(Destination dest, String dmq) throws Exception {
        if (this.isSet(dmq)) {
            if (this.dmqs.containsKey(dmq)) {
                dest.setDMQ((DeadMQueue)this.dmqs.get(dmq));
            } else {
                this.logger.log(BasicLevel.ERROR, (Object)("Destination.create(): Unknown DMQ: " + dmq));
            }
        }
    }

    public void endDocument() throws SAXException {
        if (this.logger.isLoggable(BasicLevel.DEBUG)) {
            this.logger.log(BasicLevel.DEBUG, (Object)"endDocument");
        }
        AdminModule.disconnect();
        try {
            if (this.jndiCtx == null) {
                this.jndiCtx = new InitialContext();
            }
            Enumeration e = this.toBind.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                StringBuffer buff = null;
                StringTokenizer st = null;
                if (name.startsWith(SCN)) {
                    buff = new StringBuffer(SCN);
                    st = new StringTokenizer(name.substring(SCN.length(), name.length()), "/");
                } else if (name.startsWith(HASCN)) {
                    buff = new StringBuffer(HASCN);
                    st = new StringTokenizer(name.substring(HASCN.length(), name.length()), "/");
                } else {
                    buff = new StringBuffer();
                    st = new StringTokenizer(name, "/");
                }
                buff.append(st.nextToken());
                while (st.hasMoreTokens()) {
                    block14: {
                        try {
                            this.jndiCtx.createSubcontext(buff.toString());
                        }
                        catch (NameAlreadyBoundException exc) {
                            if (this.logger.isLoggable(BasicLevel.DEBUG)) {
                                this.logger.log(BasicLevel.DEBUG, (Object)("createSubcontext:: NameAlreadyBoundException" + buff.toString()));
                            }
                        }
                        catch (NamingException exc) {
                            if (!this.logger.isLoggable(BasicLevel.WARN)) break block14;
                            this.logger.log(BasicLevel.WARN, (Object)"createSubcontext", (Throwable)exc);
                        }
                    }
                    buff.append("/");
                    buff.append(st.nextToken());
                }
                this.jndiCtx.rebind(name, this.toBind.get(name));
            }
            this.jndiCtx.close();
            this.toBind.clear();
        }
        catch (NamingException exc) {
            this.logger.log(BasicLevel.ERROR, (Object)"", (Throwable)exc);
        }
    }
}

