/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.client.jms.tcp;

import fr.dyade.aaa.util.Debug;
import fr.dyade.aaa.util.ReliableTcpConnection;
import fr.dyade.aaa.util.SocketFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Timer;
import java.util.Vector;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import org.objectweb.joram.client.jms.FactoryParameters;
import org.objectweb.joram.shared.JoramTracing;
import org.objectweb.joram.shared.client.AbstractJmsMessage;
import org.objectweb.joram.shared.security.Identity;
import org.objectweb.joram.shared.stream.MetaData;
import org.objectweb.joram.shared.stream.StreamUtil;
import org.objectweb.util.monolog.api.BasicLevel;
import org.objectweb.util.monolog.api.Logger;

public class ReliableTcpClient {
    public static Logger logger = Debug.getLogger(ReliableTcpClient.class.getName());
    public static final int INIT = 0;
    public static final int CONNECT = 1;
    public static final int CLOSE = 2;
    public static final String[] statusNames = new String[]{"INIT", "CONNECT", "CLOSE"};
    protected FactoryParameters params;
    protected Identity identity;
    protected int key;
    private ReliableTcpConnection connection;
    private volatile int status;
    private Vector addresses;
    private boolean reconnect;
    private int reconnectTimeout = 0;
    private Timer timer;

    public void setTimer(Timer timer2) {
        this.timer = timer2;
    }

    public void init(FactoryParameters params, Identity identity, boolean reconnect) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ReliableTcpClient.init(" + params + ',' + identity + ',' + reconnect + ')'));
        }
        this.params = params;
        this.reconnect = reconnect;
        if (params.cnxPendingTimer > 0) {
            this.reconnectTimeout = Math.max(2 * params.cnxPendingTimer, params.connectingTimer * 1000 + params.cnxPendingTimer);
        }
        this.addresses = new Vector();
        this.key = -1;
        this.identity = identity;
        this.setStatus(0);
    }

    private void setStatus(int status) {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ReliableTcpClient[" + this.identity + ',' + this.key + "].setStatus(" + statusNames[status] + ')'));
        }
        this.status = status;
    }

    public void connect() throws JMSException {
        this.connect(false);
    }

    public synchronized void connect(boolean reconnect) throws JMSException {
        long startTime;
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ReliableTcpClient[" + this.identity + ',' + this.key + "].connect(" + reconnect + ')'));
        }
        if (this.status != 0) {
            throw new IllegalStateException("Connect: state error");
        }
        long endTime = startTime = System.currentTimeMillis();
        endTime = this.addresses.size() > 1 ? Long.MAX_VALUE : (reconnect ? (endTime += (long)this.reconnectTimeout) : (endTime += (long)this.params.connectingTimer * 1000L));
        int attemptsC = 0;
        long nextSleep = 100L;
        while (true) {
            if (this.status == 2) {
                throw new IllegalStateException("Closed connection");
            }
            ++attemptsC;
            for (int i = 0; i < this.addresses.size(); ++i) {
                ServerAddress sa = (ServerAddress)this.addresses.elementAt(i);
                try {
                    this.doConnect(sa.hostName, sa.port);
                    this.setStatus(1);
                    return;
                }
                catch (JMSSecurityException exc) {
                    throw exc;
                }
                catch (UnknownHostException uhe) {
                    if (logger.isLoggable(BasicLevel.DEBUG)) {
                        logger.log(BasicLevel.DEBUG, (Object)"ReliableTcpClient.connect", (Throwable)uhe);
                    }
                    IllegalStateException jmsExc = new IllegalStateException("Server's host is unknown: " + sa.hostName);
                    jmsExc.setLinkedException((Exception)uhe);
                    throw jmsExc;
                }
                catch (IOException ioe) {
                    if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                    logger.log(BasicLevel.DEBUG, (Object)"ReliableTcpClient.connect", (Throwable)ioe);
                    continue;
                }
                catch (JMSException jmse) {
                    if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                    logger.log(BasicLevel.DEBUG, (Object)"ReliableTcpClient.connect", (Throwable)jmse);
                    continue;
                }
                catch (Exception e) {
                    if (!logger.isLoggable(BasicLevel.DEBUG)) continue;
                    logger.log(BasicLevel.DEBUG, (Object)"ReliableTcpClient.connect", (Throwable)e);
                }
            }
            long currentTime = System.currentTimeMillis();
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> currentTime = " + currentTime + ",endTime = " + endTime));
            }
            if (currentTime >= endTime) break;
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> retry connection " + this.identity + ',' + this.key));
            }
            if (currentTime + nextSleep > endTime) {
                nextSleep = endTime - currentTime;
            }
            try {
                this.wait(nextSleep);
            }
            catch (InterruptedException intExc) {
                throw new IllegalStateException("Could not open the connection with " + this.addresses + ": interrupted");
            }
            nextSleep *= 2L;
        }
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(" -> close connection " + this.identity + ',' + this.key));
        }
        long attemptsT = (System.currentTimeMillis() - startTime) / 1000L;
        IllegalStateException jmsExc = new IllegalStateException("Could not connect to JMS server with " + this.addresses + " after " + attemptsC + " attempts during " + attemptsT + " secs: server is" + " not listening");
        throw jmsExc;
    }

    protected Socket createSocket(String hostname, int port) throws Exception {
        InetAddress addr = InetAddress.getByName(hostname);
        InetAddress outLocalAddr = null;
        String outLocalAddrStr = this.params.outLocalAddress;
        if (outLocalAddrStr != null) {
            outLocalAddr = InetAddress.getByName(outLocalAddrStr);
        }
        int outLocalPort = this.params.outLocalPort;
        if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)("ReliableTcpClient[" + this.identity + ',' + this.key + "].createSocket(" + hostname + "," + port + ") on interface " + outLocalAddrStr + ":" + outLocalPort));
        }
        SocketFactory factory = SocketFactory.getFactory(this.params.socketFactory);
        Socket socket = factory.createSocket(addr, port, outLocalAddr, outLocalPort, this.params.connectingTimer * 1000);
        return socket;
    }

    private void doConnect(String hostname, int port) throws Exception, JMSException {
        if (JoramTracing.dbgClient.isLoggable(BasicLevel.DEBUG)) {
            JoramTracing.dbgClient.log(BasicLevel.DEBUG, (Object)("ReliableTcpClient[" + this.identity + ',' + this.key + "].doConnect(" + hostname + "," + port + ")"));
        }
        Socket socket = this.createSocket(hostname, port);
        socket.setTcpNoDelay(this.params.TcpNoDelay);
        socket.setSoTimeout(this.params.SoTimeout);
        if (this.params.SoLinger >= 0) {
            socket.setSoLinger(true, this.params.SoLinger);
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        OutputStream os = socket.getOutputStream();
        InputStream is = socket.getInputStream();
        baos.write(MetaData.joramMagic);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(" -> write identity = " + this.identity));
        }
        Identity.write(this.identity, baos);
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)(" -> write key = " + this.key));
        }
        StreamUtil.writeTo(this.key, (OutputStream)baos);
        if (this.key == -1) {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)" -> open new connection");
            }
            StreamUtil.writeTo(this.reconnectTimeout, (OutputStream)baos);
            baos.writeTo(os);
            os.flush();
            int len = StreamUtil.readIntFrom(is);
            int res = StreamUtil.readIntFrom(is);
            if (res > 0) {
                String info = StreamUtil.readStringFrom(is);
                this.throwSecurityError(info);
            }
            this.key = StreamUtil.readIntFrom(is);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> key = " + this.identity.getUserName() + ',' + this.key));
            }
            this.connection = new ReliableTcpConnection(this.timer);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)" -> init reliable connection");
            }
        } else {
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> reopen connection " + this.identity + ',' + this.key));
            }
            baos.writeTo(os);
            os.flush();
            int len = StreamUtil.readIntFrom(is);
            int res = StreamUtil.readIntFrom(is);
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)(" -> read res = " + res));
            }
            if (res > 0) {
                String info = StreamUtil.readStringFrom(is);
                this.throwSecurityError(info);
            }
            if (logger.isLoggable(BasicLevel.DEBUG)) {
                logger.log(BasicLevel.DEBUG, (Object)" -> reset reliable connection");
            }
        }
        this.connection.init(socket);
    }

    private void throwSecurityError(String info) throws JMSSecurityException {
        JMSSecurityException jmsExc = new JMSSecurityException("Can't open the connection with the server " + this.params.getHost() + " on port " + this.params.getPort() + ": " + info);
        throw jmsExc;
    }

    public void send(AbstractJmsMessage request) throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ReliableTcpClient[" + this.identity + ',' + this.key + "].send(" + request + ')'));
        }
        if (this.status == 2) {
            throw new IOException("Closed connection");
        }
        if (this.status != 1) {
            if (this.reconnect) {
                this.waitForReconnection();
            } else {
                throw new IOException("Closed connection");
            }
        }
        while (true) {
            try {
                this.connection.send(request);
                return;
            }
            catch (IOException exc) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("ReliableTcpClient[" + this.identity + ',' + this.key + "]"), (Throwable)exc);
                }
                if (this.reconnect) {
                    this.waitForReconnection();
                    continue;
                }
                this.close();
                throw exc;
            }
            break;
        }
    }

    public Object receive() throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ReliableTcpClient[" + this.identity + ',' + this.key + "].receive()"));
        }
        while (true) {
            try {
                return this.connection.receive();
            }
            catch (IOException exc) {
                if (logger.isLoggable(BasicLevel.DEBUG)) {
                    logger.log(BasicLevel.DEBUG, (Object)("ReliableTcpClient[" + this.identity + ',' + this.key + "]"), (Throwable)exc);
                }
                if (this.reconnect) {
                    this.reconnect();
                    continue;
                }
                this.close();
                throw exc;
            }
            break;
        }
    }

    private synchronized void waitForReconnection() throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ReliableTcpClient[" + this.identity + ',' + this.key + "].waitForReconnection()"));
        }
        while (this.status == 0) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        switch (this.status) {
            case 1: {
                break;
            }
            case 2: {
                throw new Exception("Connection closed");
            }
        }
    }

    private synchronized void reconnect() throws Exception {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ReliableTcpClient[" + this.identity + ',' + this.key + "].reconnect()"));
        }
        switch (this.status) {
            case 1: {
                this.setStatus(0);
            }
            case 0: {
                try {
                    this.connect(true);
                    break;
                }
                catch (JMSException exc) {
                    this.close();
                    throw exc;
                }
                finally {
                    this.notifyAll();
                }
            }
            case 2: {
                throw new Exception("Connection closed");
            }
            default: {
                throw new Error("State error");
            }
        }
    }

    public synchronized void close() {
        if (logger.isLoggable(BasicLevel.DEBUG)) {
            logger.log(BasicLevel.DEBUG, (Object)("ReliableTcpClient[" + this.identity + ',' + this.key + "].close()"));
        }
        if (this.status != 2) {
            this.setStatus(2);
            this.connection.close();
            this.identity = null;
        }
    }

    public void addServerAddress(String host, int port) {
        this.addresses.addElement(new ServerAddress(host, port));
    }

    public String toString() {
        return '(' + super.toString() + ",params=" + this.params + ",name=" + this.identity + ",key=" + this.key + ",connection=" + this.connection + ",status=" + statusNames[this.status] + ",addresses=" + this.addresses + ')';
    }

    static class ServerAddress {
        String hostName;
        int port;

        public ServerAddress(String hostName, int port) {
            this.hostName = hostName;
            this.port = port;
        }

        public String toString() {
            return "(hostName=" + this.hostName + ",port=" + this.port + ')';
        }
    }
}

