/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.joram.shared.stream;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public final class StreamUtil {
    private static ThreadLocal perThreadBuffer = new ThreadLocal(){

        protected synchronized Object initialValue() {
            return new byte[8];
        }
    };
    public static final int TRUE = 0;
    public static final int FALSE = 1;
    static final String EMPTY_STRING = "";
    static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    static final byte NULL = -1;
    static final byte BOOLEAN = 1;
    static final byte BYTE = 2;
    static final byte SHORT = 3;
    static final byte INT = 4;
    static final byte LONG = 5;
    static final byte FLOAT = 6;
    static final byte DOUBLE = 7;
    static final byte STRING = 8;
    static final byte BYTEARRAY = 9;

    private static byte[] readFully(int length, InputStream is) throws IOException {
        int count = 0;
        byte[] buf = (byte[])perThreadBuffer.get();
        if (length > buf.length) {
            buf = new byte[length];
        }
        int nb = -1;
        do {
            if ((nb = is.read(buf, count, length - count)) >= 0) continue;
            throw new EOFException();
        } while ((count += nb) != length);
        return buf;
    }

    private static void readFully(byte[] buf, InputStream is) throws IOException {
        int count = 0;
        int nb = -1;
        do {
            if ((nb = is.read(buf, count, buf.length - count)) >= 0) continue;
            throw new EOFException();
        } while ((count += nb) != buf.length);
    }

    public static void writeTo(boolean b, OutputStream os) throws IOException {
        if (b) {
            os.write(0);
        } else {
            os.write(1);
        }
    }

    public static boolean readBooleanFrom(InputStream is) throws IOException {
        return is.read() == 0;
    }

    public static void writeTo(byte b, OutputStream os) throws IOException {
        os.write(b);
    }

    public static byte readByteFrom(InputStream is) throws IOException {
        return (byte)is.read();
    }

    public static int readUnsignedByteFrom(InputStream is) throws IOException {
        return is.read();
    }

    public static void writeTo(short s, OutputStream os) throws IOException {
        byte[] buf = (byte[])perThreadBuffer.get();
        buf[0] = (byte)(s >>> 8);
        buf[1] = (byte)(s >>> 0);
        os.write(buf, 0, 2);
    }

    public static short readShortFrom(InputStream is) throws IOException {
        byte[] buf = StreamUtil.readFully(2, is);
        return (short)((buf[0] & 0xFF) << 8 | buf[1] & 0xFF);
    }

    public static void writeTo(int i, OutputStream os) throws IOException {
        byte[] buf = (byte[])perThreadBuffer.get();
        buf[0] = (byte)(i >>> 24);
        buf[1] = (byte)(i >>> 16);
        buf[2] = (byte)(i >>> 8);
        buf[3] = (byte)(i >>> 0);
        os.write(buf, 0, 4);
    }

    public static int readIntFrom(InputStream is) throws IOException {
        byte[] buf = StreamUtil.readFully(4, is);
        return (buf[0] & 0xFF) << 24 | (buf[1] & 0xFF) << 16 | (buf[2] & 0xFF) << 8 | buf[3] & 0xFF;
    }

    public static long readUnsignedIntFrom(InputStream is) throws IOException {
        byte[] buf = StreamUtil.readFully(4, is);
        return ((long)buf[0] & 0xFFL) << 24 | (long)((buf[1] & 0xFF) << 16) | (long)((buf[2] & 0xFF) << 8) | (long)(buf[3] & 0xFF);
    }

    public static void writeTo(long l, OutputStream os) throws IOException {
        byte[] buf = (byte[])perThreadBuffer.get();
        buf[0] = (byte)(l >>> 56);
        buf[1] = (byte)(l >>> 48);
        buf[2] = (byte)(l >>> 40);
        buf[3] = (byte)(l >>> 32);
        buf[4] = (byte)(l >>> 24);
        buf[5] = (byte)(l >>> 16);
        buf[6] = (byte)(l >>> 8);
        buf[7] = (byte)(l >>> 0);
        os.write(buf, 0, 8);
    }

    public static long readLongFrom(InputStream is) throws IOException {
        byte[] buf = StreamUtil.readFully(8, is);
        return ((long)buf[0] & 0xFFL) << 56 | ((long)buf[1] & 0xFFL) << 48 | ((long)buf[2] & 0xFFL) << 40 | ((long)buf[3] & 0xFFL) << 32 | ((long)buf[4] & 0xFFL) << 24 | ((long)buf[5] & 0xFFL) << 16 | ((long)buf[6] & 0xFFL) << 8 | (long)buf[7] & 0xFFL;
    }

    public static void writeTo(float f, OutputStream os) throws IOException {
        StreamUtil.writeTo(Float.floatToIntBits(f), os);
    }

    public static float readFloatFrom(InputStream is) throws IOException {
        return Float.intBitsToFloat(StreamUtil.readIntFrom(is));
    }

    public static void writeTo(double d, OutputStream os) throws IOException {
        StreamUtil.writeTo(Double.doubleToLongBits(d), os);
    }

    public static double readDoubleFrom(InputStream is) throws IOException {
        return Double.longBitsToDouble(StreamUtil.readLongFrom(is));
    }

    public static void writeTo(String str, OutputStream os) throws IOException {
        if (str == null) {
            StreamUtil.writeTo(-1, os);
        } else if (str.length() == 0) {
            StreamUtil.writeTo(0, os);
        } else {
            byte[] buf = str.getBytes();
            StreamUtil.writeTo(buf.length, os);
            os.write(buf);
        }
    }

    public static String readStringFrom(InputStream is) throws IOException {
        int length = StreamUtil.readIntFrom(is);
        if (length == -1) {
            return null;
        }
        if (length == 0) {
            return EMPTY_STRING;
        }
        if (length > 0) {
            byte[] tab = StreamUtil.readFully(length, is);
            return new String(tab, 0, length);
        }
        throw new IOException("bad string length");
    }

    public static void writeTo(byte[] tab, OutputStream os) throws IOException {
        if (tab == null) {
            StreamUtil.writeTo(-1, os);
        } else if (tab.length == 0) {
            StreamUtil.writeTo(0, os);
        } else {
            StreamUtil.writeTo(tab.length, os);
            os.write(tab);
        }
    }

    public static byte[] readByteArrayFrom(InputStream is) throws IOException {
        int length = StreamUtil.readIntFrom(is);
        return StreamUtil.readByteArrayFrom(is, length);
    }

    public static byte[] readByteArrayFrom(InputStream is, int length) throws IOException {
        if (length == -1) {
            return null;
        }
        if (length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        if (length > 0) {
            byte[] tab = new byte[length];
            StreamUtil.readFully(tab, is);
            return tab;
        }
        throw new IOException("bad array length");
    }

    public static void writeObjectTo(Object obj, OutputStream os) throws IOException {
        if (obj == null) {
            StreamUtil.writeTo((byte)-1, os);
        } else if (obj instanceof Boolean) {
            StreamUtil.writeTo((byte)1, os);
            StreamUtil.writeTo((Boolean)obj, os);
        } else if (obj instanceof Byte) {
            StreamUtil.writeTo((byte)2, os);
            StreamUtil.writeTo((Byte)obj, os);
        } else if (obj instanceof Short) {
            StreamUtil.writeTo((byte)3, os);
            StreamUtil.writeTo((Short)obj, os);
        } else if (obj instanceof Integer) {
            StreamUtil.writeTo((byte)4, os);
            StreamUtil.writeTo((Integer)obj, os);
        } else if (obj instanceof Long) {
            StreamUtil.writeTo((byte)5, os);
            StreamUtil.writeTo((Long)obj, os);
        } else if (obj instanceof Float) {
            StreamUtil.writeTo((byte)6, os);
            StreamUtil.writeTo(((Float)obj).floatValue(), os);
        } else if (obj instanceof Double) {
            StreamUtil.writeTo((byte)7, os);
            StreamUtil.writeTo((Double)obj, os);
        } else if (obj instanceof String) {
            StreamUtil.writeTo((byte)8, os);
            StreamUtil.writeTo((String)obj, os);
        } else if (obj instanceof byte[]) {
            StreamUtil.writeTo((byte)9, os);
            StreamUtil.writeTo((byte[])obj, os);
        } else {
            throw new InvalidClassException("Bad primitive type");
        }
    }

    public static Object readObjectFrom(InputStream is) throws IOException {
        byte type = StreamUtil.readByteFrom(is);
        switch (type) {
            case -1: {
                return null;
            }
            case 1: {
                return new Boolean(StreamUtil.readBooleanFrom(is));
            }
            case 2: {
                return new Byte(StreamUtil.readByteFrom(is));
            }
            case 3: {
                return new Short(StreamUtil.readShortFrom(is));
            }
            case 4: {
                return new Integer(StreamUtil.readIntFrom(is));
            }
            case 5: {
                return new Long(StreamUtil.readLongFrom(is));
            }
            case 6: {
                return new Float(StreamUtil.readFloatFrom(is));
            }
            case 7: {
                return new Double(StreamUtil.readDoubleFrom(is));
            }
            case 8: {
                return StreamUtil.readStringFrom(is);
            }
            case 9: {
                return StreamUtil.readByteArrayFrom(is);
            }
        }
        throw new InvalidClassException("Bad primitive type");
    }

    public static void writeTo(org.objectweb.joram.shared.util.Properties p, OutputStream os) throws IOException {
        if (p == null) {
            StreamUtil.writeTo(-1, os);
        } else {
            p.writeTo(os);
        }
    }

    public static org.objectweb.joram.shared.util.Properties readPropertiesFrom(InputStream is) throws IOException {
        return org.objectweb.joram.shared.util.Properties.readFrom(is);
    }

    public static void writeVectorOfStringTo(Vector v, OutputStream os) throws IOException {
        if (v == null) {
            StreamUtil.writeTo(-1, os);
        } else {
            int size = v.size();
            StreamUtil.writeTo(size, os);
            for (int i = 0; i < size; ++i) {
                StreamUtil.writeTo((String)v.elementAt(i), os);
            }
        }
    }

    public static Vector readVectorOfStringFrom(InputStream is) throws IOException {
        int size = StreamUtil.readIntFrom(is);
        if (size == -1) {
            return null;
        }
        Vector<String> v = new Vector<String>(size);
        for (int i = 0; i < size; ++i) {
            v.addElement(StreamUtil.readStringFrom(is));
        }
        return v;
    }

    public static void writeArrayOfStringTo(String[] array, OutputStream os) throws IOException {
        if (array == null) {
            StreamUtil.writeTo(-1, os);
        } else {
            int size = array.length;
            StreamUtil.writeTo(size, os);
            for (int i = 0; i < size; ++i) {
                StreamUtil.writeTo(array[i], os);
            }
        }
    }

    public static String[] readArrayOfStringFrom(InputStream is) throws IOException {
        int size = StreamUtil.readIntFrom(is);
        String[] array = null;
        if (size != -1) {
            array = new String[size];
            for (int i = 0; i < size; ++i) {
                array[i] = StreamUtil.readStringFrom(is);
            }
        }
        return array;
    }

    public static void writeArrayOfIntTo(int[] array, OutputStream os) throws IOException {
        if (array == null) {
            StreamUtil.writeTo(-1, os);
        } else {
            int size = array.length;
            StreamUtil.writeTo(size, os);
            for (int i = 0; i < size; ++i) {
                StreamUtil.writeTo(array[i], os);
            }
        }
    }

    public static int[] readArrayOfIntFrom(InputStream is) throws IOException {
        int size = StreamUtil.readIntFrom(is);
        int[] array = null;
        if (size != -1) {
            array = new int[size];
            for (int i = 0; i < size; ++i) {
                array[i] = StreamUtil.readIntFrom(is);
            }
        }
        return array;
    }

    public static void writeArrayOfBooleanTo(boolean[] array, OutputStream os) throws IOException {
        if (array == null) {
            StreamUtil.writeTo(-1, os);
        } else {
            int size = array.length;
            StreamUtil.writeTo(size, os);
            for (int i = 0; i < size; ++i) {
                StreamUtil.writeTo(array[i], os);
            }
        }
    }

    public static boolean[] readArrayOfBooleanFrom(InputStream is) throws IOException {
        int size = StreamUtil.readIntFrom(is);
        boolean[] array = null;
        if (size != -1) {
            array = new boolean[size];
            for (int i = 0; i < size; ++i) {
                array[i] = StreamUtil.readBooleanFrom(is);
            }
        }
        return array;
    }

    public static void writeTo(Properties p, OutputStream os) throws IOException {
        if (p == null) {
            StreamUtil.writeTo(-1, os);
        } else {
            StreamUtil.writeTo(p.size(), os);
            Enumeration<Object> keys = p.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                StreamUtil.writeTo(key, os);
                String value = p.getProperty(key);
                StreamUtil.writeTo(value, os);
            }
        }
    }

    public static Properties readJPropertiesFrom(InputStream is) throws IOException {
        int size = StreamUtil.readIntFrom(is);
        Properties prop = null;
        if (size != -1) {
            prop = new Properties();
            for (int i = 0; i < size; ++i) {
                String key = StreamUtil.readStringFrom(is);
                String value = StreamUtil.readStringFrom(is);
                prop.put(key, value);
            }
        }
        return prop;
    }
}

