/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.modeler;

import java.io.Serializable;
import java.lang.reflect.Method;
import javax.management.Descriptor;
import javax.management.modelmbean.ModelMBeanAttributeInfo;
import org.apache.commons.modeler.FeatureInfo;

public class AttributeInfo
extends FeatureInfo
implements Serializable {
    static final long serialVersionUID = -2511626862303972143L;
    protected transient ModelMBeanAttributeInfo info = null;
    protected String displayName = null;
    protected String getMethod = null;
    protected String setMethod = null;
    protected transient Method getMethodObj = null;
    protected transient Method setMethodObj = null;
    protected boolean readable = true;
    protected boolean writeable = true;
    protected boolean is = false;
    protected String type = null;
    protected String persist;
    protected String defaultStringValue;

    public void setDescription(String description) {
        super.setDescription(description);
        this.info = null;
    }

    public void setName(String name) {
        super.setName(name);
        this.info = null;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getGetMethod() {
        return this.getMethod;
    }

    public void setGetMethod(String getMethod) {
        this.getMethod = getMethod;
        this.info = null;
    }

    public Method getGetMethodObj() {
        return this.getMethodObj;
    }

    public void setGetMethodObj(Method getMethodObj) {
        this.getMethodObj = getMethodObj;
    }

    public Method getSetMethodObj() {
        return this.setMethodObj;
    }

    public void setSetMethodObj(Method setMethodObj) {
        this.setMethodObj = setMethodObj;
    }

    public boolean isIs() {
        return this.is;
    }

    public void setIs(boolean is) {
        this.is = is;
        this.info = null;
    }

    public boolean isReadable() {
        return this.readable;
    }

    public void setReadable(boolean readable) {
        this.readable = readable;
        this.info = null;
    }

    public String getSetMethod() {
        return this.setMethod;
    }

    public void setSetMethod(String setMethod) {
        this.setMethod = setMethod;
        this.info = null;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
        this.info = null;
    }

    public boolean isWriteable() {
        return this.writeable;
    }

    public void setWriteable(boolean writeable) {
        this.writeable = writeable;
        this.info = null;
    }

    public String getPersist() {
        return this.persist;
    }

    public void setPersist(String persist) {
        this.persist = persist;
    }

    public String getDefault() {
        return this.defaultStringValue;
    }

    public void setDefault(String defaultStringValue) {
        this.defaultStringValue = defaultStringValue;
    }

    public ModelMBeanAttributeInfo createAttributeInfo() {
        if (this.info != null) {
            return this.info;
        }
        if (this.getMethodObj != null || this.setMethodObj != null) {
            try {
                this.info = new ModelMBeanAttributeInfo(this.getName(), this.getDescription(), this.getMethodObj, this.setMethodObj);
                return this.info;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.info = new ModelMBeanAttributeInfo(this.getName(), this.getType(), this.getDescription(), this.isReadable(), this.isWriteable(), false);
        Descriptor descriptor = this.info.getDescriptor();
        if (this.getDisplayName() != null) {
            descriptor.setField("displayName", this.getDisplayName());
        }
        if (this.isReadable()) {
            if (this.getGetMethod() != null) {
                descriptor.setField("getMethod", this.getGetMethod());
            } else {
                descriptor.setField("getMethod", this.getMethodName(this.getName(), true, this.isIs()));
            }
        }
        if (this.isWriteable()) {
            if (this.getSetMethod() != null) {
                descriptor.setField("setMethod", this.getSetMethod());
            } else {
                descriptor.setField("setMethod", this.getMethodName(this.getName(), false, false));
            }
        }
        this.addFields(descriptor);
        this.info.setDescriptor(descriptor);
        return this.info;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("AttributeInfo[");
        sb.append("name=");
        sb.append(this.name);
        sb.append(", description=");
        sb.append(this.description);
        if (!this.readable) {
            sb.append(", readable=");
            sb.append(this.readable);
        }
        sb.append(", type=");
        sb.append(this.type);
        if (!this.writeable) {
            sb.append(", writeable=");
            sb.append(this.writeable);
        }
        sb.append("]");
        return sb.toString();
    }

    private String getMethodName(String name, boolean getter, boolean is) {
        StringBuffer sb = new StringBuffer();
        if (getter) {
            if (is) {
                sb.append("is");
            } else {
                sb.append("get");
            }
        } else {
            sb.append("set");
        }
        sb.append(Character.toUpperCase(name.charAt(0)));
        sb.append(name.substring(1));
        return sb.toString();
    }
}

