/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.jonas.ws.jaxws.handler.builder;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import org.ow2.jonas.ws.jaxws.handler.HandlerResourceProcessor;
import org.ow2.util.annotation.processor.DefaultAnnotationProcessor;
import org.ow2.util.annotation.processor.IAnnotationHandler;
import org.ow2.util.annotation.processor.IAnnotationProcessor;
import org.ow2.util.annotation.processor.ProcessorException;
import org.ow2.util.ee.metadata.common.api.xml.struct.IHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerBuilder {
    private IHandler handlerDesc;
    private ClassLoader classloader;

    public HandlerBuilder(IHandler pcHandler, ClassLoader loader) {
        this.handlerDesc = pcHandler;
        this.classloader = loader;
    }

    public Handler buildHandler() {
        Handler handler;
        String classname = this.handlerDesc.getHandlerClass();
        try {
            Class<Handler> clazz = Class.forName(classname, true, this.classloader).asSubclass(Handler.class);
            handler = clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new WebServiceException("Cannot load class '" + classname + "' from loader '" + this.classloader + "'", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new WebServiceException("Cannot call default constructor of class '" + classname + "'", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new WebServiceException("Cannot instanciate class '" + classname + "'", (Throwable)e);
        }
        this.initHandler(handler, this.handlerDesc.getInitParams());
        return handler;
    }

    private void initHandler(Handler handler, Map<String, String> initParams) {
        Method initMethod = this.findInitMethod(handler.getClass());
        if (initMethod != null) {
            this.initHandlerUsingMethod(handler, initMethod, initParams);
        } else {
            this.initHandlerUsingResource(handler, initParams);
        }
    }

    private void initHandlerUsingResource(Handler handler, Map<String, String> initParams) {
        IAnnotationProcessor processor = this.createAnnotationProcessor(initParams);
        try {
            processor.process((Object)handler);
        }
        catch (ProcessorException e) {
            throw new WebServiceException("Cannot initialise the handler '" + handler + "'", (Throwable)e);
        }
    }

    private IAnnotationProcessor createAnnotationProcessor(Map<String, String> initParams) {
        DefaultAnnotationProcessor processor = new DefaultAnnotationProcessor();
        processor.addAnnotationHandler((IAnnotationHandler)new HandlerResourceProcessor(initParams));
        return processor;
    }

    private void initHandlerUsingMethod(Handler handler, Method initMethod, Map<String, String> initParams) {
        boolean access = initMethod.isAccessible();
        try {
            initMethod.setAccessible(true);
            initMethod.invoke((Object)handler, initParams);
        }
        catch (IllegalAccessException e) {
            throw new WebServiceException("Cannot use method '" + initMethod + "'", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new WebServiceException("Exception during '" + initMethod + "' invocation", (Throwable)e);
        }
        finally {
            initMethod.setAccessible(access);
        }
    }

    private Method findInitMethod(Class<? extends Handler> clazz) {
        try {
            return clazz.getMethod("init", Map.class);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

