/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.objects;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Enumerated;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Temporal;
import javax.persistence.Version;
import org.eclipse.persistence.annotations.BasicCollection;
import org.eclipse.persistence.annotations.BasicMap;
import org.eclipse.persistence.annotations.ReadTransformer;
import org.eclipse.persistence.annotations.VariableOneToOne;
import org.eclipse.persistence.annotations.WriteTransformer;
import org.eclipse.persistence.annotations.WriteTransformers;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataLogger;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.xml.XMLEntityMappings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataAnnotatedElement
extends MetadataAccessibleObject {
    public static final String JPA_PERSISTENCE_PACKAGE_PREFIX = "javax.persistence";
    public static final String ECLIPSELINK_PERSISTENCE_PACKAGE_PREFIX = "org.eclipse.persistence.annotations";
    private String m_name;
    private Class m_rawClass;
    private Type m_relationType;
    private String m_attributeName;
    private AnnotatedElement m_annotatedElement;
    private HashMap<String, Annotation> m_annotations;

    protected MetadataAnnotatedElement(AnnotatedElement annotatedElement) {
        super(annotatedElement, null);
        this.setAnnotatedElement(annotatedElement);
    }

    public MetadataAnnotatedElement(AnnotatedElement annotatedElement, MetadataLogger logger) {
        super(annotatedElement, logger);
        this.setAnnotatedElement(annotatedElement);
    }

    public MetadataAnnotatedElement(AnnotatedElement annotatedElement, XMLEntityMappings entityMappings) {
        super(entityMappings.getMappingFile(), entityMappings);
        this.setAnnotatedElement(annotatedElement);
    }

    public AnnotatedElement getAnnotatedElement() {
        return this.m_annotatedElement;
    }

    public <T extends Annotation> T getAnnotation(Class annotation) {
        return (T)this.m_annotations.get(annotation.getName());
    }

    public <T extends Annotation> T getAnnotation(Class annotationClass, MetadataDescriptor descriptor) {
        Annotation annotation = this.m_annotations.get(annotationClass.getName());
        if (annotation != null && descriptor.ignoreAnnotations()) {
            this.getLogger().logWarningMessage("annotation_warning_ignore_annotation", annotation, this.m_annotatedElement);
            return null;
        }
        return (T)annotation;
    }

    public Map<String, Annotation> getAnnotations() {
        return this.m_annotations;
    }

    public String getAttributeName() {
        return this.m_attributeName;
    }

    protected int getDeclaredAnnotationsCount(MetadataDescriptor descriptor) {
        return descriptor.ignoreAnnotations() ? 0 : this.m_annotations.size();
    }

    @Override
    public Object getElement() {
        return this.getAnnotatedElement();
    }

    public Class getMapKeyClass(MetadataDescriptor descriptor) {
        if (this.isGenericCollectionType()) {
            Type referenceType = ((ParameterizedType)this.m_relationType).getActualTypeArguments()[0];
            if (referenceType instanceof Class) {
                return (Class)referenceType;
            }
            return (Class)descriptor.getGenericType(((TypeVariable)referenceType).getName());
        }
        return null;
    }

    public String getName() {
        return this.m_name;
    }

    public Class getRawClass(MetadataDescriptor descriptor) {
        if (this.m_rawClass == null) {
            if (this.isGenericCollectionType()) {
                return (Class)((ParameterizedType)this.m_relationType).getRawType();
            }
            if (this.m_relationType instanceof Class) {
                return (Class)this.m_relationType;
            }
            this.m_rawClass = (Class)descriptor.getGenericType(((TypeVariable)this.m_relationType).getName());
        }
        return this.m_rawClass;
    }

    public Class getReferenceClassFromGeneric(MetadataDescriptor descriptor) {
        if (this.isGenericCollectionType()) {
            ParameterizedType pType = (ParameterizedType)this.m_relationType;
            Type referenceType = Map.class.isAssignableFrom((Class)pType.getRawType()) ? pType.getActualTypeArguments()[1] : pType.getActualTypeArguments()[0];
            if (referenceType instanceof Class) {
                return (Class)referenceType;
            }
            return (Class)descriptor.getGenericType(((TypeVariable)referenceType).getName());
        }
        return null;
    }

    public Type getRelationType() {
        return this.m_relationType;
    }

    public boolean hasDeclaredAnnotations(MetadataDescriptor descriptor) {
        return this.getDeclaredAnnotationsCount(descriptor) > 0;
    }

    public boolean hasMoreThanOneDeclaredAnnotation(MetadataDescriptor descriptor) {
        return this.getDeclaredAnnotationsCount(descriptor) > 1;
    }

    public boolean isAnnotationNotPresent(Class annotation) {
        return !this.isAnnotationPresent(annotation);
    }

    public boolean isAnnotationPresent(Class annotation) {
        return this.getAnnotation(annotation) != null;
    }

    public boolean isAnnotationPresent(Class annotationClass, MetadataDescriptor descriptor) {
        Object annotation = this.getAnnotation(annotationClass);
        if (annotation != null && descriptor.ignoreAnnotations()) {
            this.getLogger().logWarningMessage("annotation_warning_ignore_annotation", annotation, this.m_annotatedElement);
            return false;
        }
        return annotation != null;
    }

    public boolean isBasic(MetadataDescriptor descriptor) {
        return this.isAnnotationPresent(Basic.class, descriptor) || this.isAnnotationPresent(Lob.class, descriptor) || this.isAnnotationPresent(Temporal.class, descriptor) || this.isAnnotationPresent(Enumerated.class, descriptor);
    }

    public boolean isBasicCollection(MetadataDescriptor descriptor) {
        return this.isAnnotationPresent(BasicCollection.class, descriptor);
    }

    public boolean isBasicMap(MetadataDescriptor descriptor) {
        return this.isAnnotationPresent(BasicMap.class, descriptor);
    }

    public boolean isEmbedded(MetadataDescriptor descriptor) {
        if (this.isAnnotationNotPresent(Embedded.class) && this.isAnnotationNotPresent(EmbeddedId.class)) {
            Class rawClass = this.getRawClass(descriptor);
            MetadataClass metadataClass = new MetadataClass(rawClass);
            return metadataClass.isAnnotationPresent(Embeddable.class) || descriptor.getProject().hasEmbeddable(rawClass);
        }
        return this.isAnnotationPresent(Embedded.class, descriptor);
    }

    public boolean isEmbeddedId(MetadataDescriptor descriptor) {
        return this.isAnnotationPresent(EmbeddedId.class, descriptor);
    }

    public boolean isGenericCollectionType() {
        return this.m_relationType instanceof ParameterizedType;
    }

    public boolean isGenericType() {
        return this.m_relationType instanceof TypeVariable;
    }

    public boolean isId(MetadataDescriptor descriptor) {
        return this.isAnnotationPresent(Id.class, descriptor);
    }

    public boolean isManyToMany(MetadataDescriptor descriptor) {
        return this.isAnnotationPresent(ManyToMany.class, descriptor);
    }

    public boolean isManyToOne(MetadataDescriptor descriptor) {
        return this.isAnnotationPresent(ManyToOne.class, descriptor);
    }

    public boolean isOneToMany(MetadataDescriptor descriptor) {
        if (this.isAnnotationNotPresent(OneToMany.class) && !descriptor.ignoreDefaultMappings()) {
            if (this.isGenericCollectionType() && this.isSupportedCollectionClass(descriptor) && descriptor.getProject().hasEntity(this.getReferenceClassFromGeneric(descriptor))) {
                this.getLogger().logConfigMessage("metadata_default_one_to_many_mapping", this.m_annotatedElement);
                return true;
            }
            return false;
        }
        return this.isAnnotationPresent(OneToMany.class, descriptor);
    }

    public boolean isOneToOne(MetadataDescriptor descriptor) {
        if (this.isAnnotationNotPresent(OneToOne.class) && !descriptor.ignoreDefaultMappings()) {
            if (descriptor.getProject().hasEntity(this.getRawClass(descriptor)) && !this.isEmbedded(descriptor)) {
                this.getLogger().logConfigMessage("metadata_default_one_to_one_mapping", this.m_annotatedElement);
                return true;
            }
            return false;
        }
        return this.isAnnotationPresent(OneToOne.class, descriptor);
    }

    public boolean isSupportedCollectionClass(MetadataDescriptor descriptor) {
        Class rawClass = this.getRawClass(descriptor);
        return Collection.class.isAssignableFrom(rawClass) || Set.class.isAssignableFrom(rawClass) || List.class.isAssignableFrom(rawClass) || Map.class.isAssignableFrom(rawClass);
    }

    public boolean isTransformation(MetadataDescriptor descriptor) {
        return this.isAnnotationPresent(ReadTransformer.class, descriptor) || this.isAnnotationPresent(WriteTransformers.class, descriptor) || this.isAnnotationPresent(WriteTransformer.class, descriptor);
    }

    protected boolean isValidPersistenceElement(int modifiers) {
        return !Modifier.isTransient(modifiers) && !Modifier.isStatic(modifiers) && !Modifier.isAbstract(modifiers);
    }

    public boolean isVariableOneToOne(MetadataDescriptor descriptor) {
        if (this.isAnnotationNotPresent(VariableOneToOne.class) && !descriptor.ignoreDefaultMappings()) {
            if (this.getRawClass(descriptor).isInterface() && !Map.class.isAssignableFrom(this.getRawClass(descriptor)) && !Collection.class.isAssignableFrom(this.getRawClass(descriptor)) && !this.getRawClass(descriptor).equals(ValueHolderInterface.class)) {
                this.getLogger().logConfigMessage("metadata_default_variable_one_to_one_mapping", this.m_annotatedElement);
                return true;
            }
            return false;
        }
        return this.isAnnotationPresent(VariableOneToOne.class, descriptor);
    }

    public boolean isVersion(MetadataDescriptor descriptor) {
        return this.isAnnotationPresent(Version.class, descriptor);
    }

    public void setAnnotatedElement(AnnotatedElement annotatedElement) {
        this.m_annotatedElement = annotatedElement;
        this.m_annotations = new HashMap();
        for (Annotation annotation : annotatedElement.getDeclaredAnnotations()) {
            String annotationName = annotation.annotationType().getName();
            if (!annotationName.startsWith(JPA_PERSISTENCE_PACKAGE_PREFIX) && !annotationName.startsWith(ECLIPSELINK_PERSISTENCE_PACKAGE_PREFIX)) continue;
            String annotationShortName = ((Object)annotation).toString().substring(1, ((Object)annotation).toString().indexOf("("));
            this.m_annotations.put(annotationShortName, annotation);
        }
    }

    protected void setAttributeName(String attributeName) {
        this.m_attributeName = attributeName;
    }

    protected void setName(String name) {
        this.m_name = name;
    }

    protected void setRelationType(Type relationType) {
        this.m_relationType = relationType;
    }
}

