/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.queries;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.indirection.IndirectList;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.queries.InterfaceContainerPolicy;

public class IndirectListContainerPolicy
extends InterfaceContainerPolicy {
    public IndirectListContainerPolicy() {
    }

    public IndirectListContainerPolicy(Class containerClass) {
        super(containerClass);
        DescriptorException.invalidContainerPolicy(this, containerClass);
    }

    protected boolean addInto(Object key, Object element, Object container) {
        try {
            ((IndirectList)container).addElement(element);
            return true;
        }
        catch (ClassCastException ex) {
            throw QueryException.cannotAddElement(element, container, ex);
        }
    }

    public void addIntoWithOrder(Vector indexes, Hashtable elements, Object container) {
        Object object = null;
        try {
            Enumeration indexEnum = indexes.elements();
            while (indexEnum.hasMoreElements()) {
                Integer index = (Integer)indexEnum.nextElement();
                object = elements.get(index);
                if (index >= this.sizeFor(container) - 1) {
                    ((IndirectList)container).addElement((Object)object);
                    continue;
                }
                ((IndirectList)container).setElementAt((Object)object, (int)index);
            }
        }
        catch (ClassCastException ex1) {
            throw QueryException.cannotAddElement(object, container, ex1);
        }
    }

    public void clear(Object container) {
        ((IndirectList)container).clear();
    }

    protected boolean contains(Object element, Object container) {
        return ((IndirectList)container).contains(element);
    }

    public Class getInterfaceType() {
        return ClassConstants.IndirectList_Class;
    }

    public boolean hasNext(Object iterator) {
        return ((Enumeration)iterator).hasMoreElements();
    }

    public boolean hasOrder() {
        return true;
    }

    public Object iteratorFor(Object container) {
        return ((IndirectList)container).elements();
    }

    protected Object next(Object iterator) {
        return ((Enumeration)iterator).nextElement();
    }

    protected boolean removeFrom(Object key, Object element, Object container) {
        return ((IndirectList)container).removeElement(element);
    }

    public void removeFromWithOrder(int beginIndex, Object container) {
        int size;
        try {
            for (size = this.sizeFor(container) - 1; size >= beginIndex; --size) {
                ((IndirectList)container).removeElementAt(size);
            }
        }
        catch (ClassCastException ex1) {
            throw QueryException.cannotRemoveFromContainer(new Integer(size), container, this);
        }
    }

    public int sizeFor(Object container) {
        return ((IndirectList)container).size();
    }
}

