/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.compat;

import com.ctc.wstx.compat.JdkImpl;

public class JdkInfo {
    static final int JDK_INFO_UNKNOWN = 0;

    public static int getJDKVersion() {
        int id = 0;
        try {
            id = JdkInfo.findVersion("java.specification.version");
            if (id == 0) {
                JdkInfo.findVersion("java.vm.version");
                if (id == 0) {
                    JdkInfo.findVersion("java.version");
                }
            }
            return id;
        }
        catch (Throwable t) {
            System.err.println("Problems trying to access System properties: " + t);
            return id;
        }
    }

    public static JdkImpl constructImpl(int version2) throws Exception {
        Class<?> cls = Class.forName("com.ctc.wstx.compat.Jdk" + version2 + "Impl");
        return (JdkImpl)cls.newInstance();
    }

    private static int findVersion(String propId) {
        int major;
        String str = System.getProperty(propId);
        if (str == null || str.length() < 3) {
            return 0;
        }
        int ix = str.indexOf(46);
        if (ix < 1) {
            return 0;
        }
        try {
            major = Integer.parseInt(str.substring(0, ix));
        }
        catch (NumberFormatException nex) {
            return 0;
        }
        if (major < 1 || major > 99) {
            return 0;
        }
        int len = (str = str.substring(ix + 1)).length();
        if (len < 1 || str.charAt(0) < '0' || str.charAt(0) > '9') {
            return 0;
        }
        int med = 0;
        for (int i = 0; i < len; ++i) {
            char c = str.charAt(i);
            if (c < '0' || c > '9') continue;
            med = med * 10 + (c - 48);
        }
        if (med > 9) {
            return 0;
        }
        return major * 100 + med;
    }
}

