/*
 * Decompiled with CFR 0.152.
 */
package fr.dyade.aaa.util;

import fr.dyade.aaa.util.Daemon;
import fr.dyade.aaa.util.Timer;
import fr.dyade.aaa.util.TimerTask;
import org.objectweb.util.monolog.api.BasicLevel;

class TimerDaemon
extends Daemon {
    private Timer timer;
    long nextWakeup = -1L;
    boolean started = false;

    TimerDaemon(Timer timer) {
        super("timer");
        this.setDaemon(true);
        this.timer = timer;
    }

    public void start() {
        super.start();
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            TimerTask task = null;
            while (this.running) {
                this.canStop = true;
                task = null;
                try {
                    Timer timer = this.timer;
                    synchronized (timer) {
                        if (this.timer.tasks.isEmpty()) {
                            this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", run and wait()"));
                            this.timer.wait();
                        } else {
                            task = (TimerTask)this.timer.tasks.elementAt(0);
                            this.nextWakeup = task.wakeupTime;
                            long sleepPeriod = this.nextWakeup - System.currentTimeMillis();
                            if (sleepPeriod <= 0L) {
                                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", run, remove task and continue"));
                                this.timer.tasks.removeElementAt(0);
                                this.canStop = false;
                            } else {
                                this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", run and wait(" + sleepPeriod + ")"));
                                task.waiting = true;
                                this.timer.wait(sleepPeriod);
                                task = null;
                            }
                        }
                    }
                    if (task == null) continue;
                    this.canStop = false;
                    task.run();
                    task = null;
                }
                catch (InterruptedException e1) {
                    this.logmon.log(BasicLevel.DEBUG, (Object)(this.getName() + ", run," + e1.toString()));
                }
            }
            this.started = false;
        }
        catch (Exception e) {
            this.logmon.log(BasicLevel.WARN, (Object)(this.getName() + ", run," + e.toString()));
        }
        finally {
            this.finish();
        }
    }

    public synchronized void interrupt() {
        if (this.canStop) {
            this.thread.interrupt();
        }
    }

    public void shutdown() {
        this.timer.notify();
    }

    public void close() {
    }
}

