/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.spring;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.bus.spring.BusEntityResolver;
import org.apache.cxf.bus.spring.ControlledValidationXmlBeanDefinitionReader;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.xml.BeansDtdResolver;
import org.springframework.beans.factory.xml.DefaultNamespaceHandlerResolver;
import org.springframework.beans.factory.xml.PluggableSchemaResolver;
import org.springframework.beans.factory.xml.ResourceEntityResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

public class BusApplicationContext
extends ClassPathXmlApplicationContext {
    private static final String DEFAULT_CXF_CFG_FILE = "META-INF/cxf/cxf.xml";
    private static final String DEFAULT_CXF_EXT_CFG_FILE = "classpath*:META-INF/cxf/cxf.extension";
    private static final Logger LOG = LogUtils.getL7dLogger(BusApplicationContext.class);
    private DefaultNamespaceHandlerResolver nsHandlerResolver;
    private boolean includeDefaults;
    private String[] cfgFiles;
    private URL[] cfgFileURLs;

    public BusApplicationContext(String cf, boolean include) {
        this(cf, include, null);
    }

    public BusApplicationContext(String[] cfs, boolean include) {
        this(cfs, include, null);
    }

    public BusApplicationContext(URL url, boolean include) {
        this(url, include, null);
    }

    public BusApplicationContext(URL[] urls, boolean include) {
        this(urls, include, null);
    }

    public BusApplicationContext(String cf, boolean include, ApplicationContext parent) {
        this(new String[]{cf}, include, parent);
    }

    public BusApplicationContext(URL url, boolean include, ApplicationContext parent) {
        this(new URL[]{url}, include, parent);
    }

    public BusApplicationContext(String[] cf, boolean include, ApplicationContext parent) {
        super(new String[0], false, parent);
        this.cfgFiles = cf;
        this.includeDefaults = include;
        this.refresh();
    }

    public BusApplicationContext(URL[] url, boolean include, ApplicationContext parent) {
        super(new String[0], false, parent);
        this.cfgFileURLs = url;
        this.includeDefaults = include;
        this.refresh();
    }

    protected Resource[] getConfigResources() {
        String sysCfgFileUrl;
        String cfgFile;
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (this.includeDefaults) {
            try {
                Resource[] exts;
                PathMatchingResourcePatternResolver resolver2 = new PathMatchingResourcePatternResolver(Thread.currentThread().getContextClassLoader());
                Collections.addAll(resources, resolver2.getResources(DEFAULT_CXF_CFG_FILE));
                for (Resource r : exts = resolver2.getResources(DEFAULT_CXF_EXT_CFG_FILE)) {
                    InputStream is = r.getInputStream();
                    BufferedReader rd = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    String line = rd.readLine();
                    while (line != null) {
                        if (!"".equals(line)) {
                            resources.add(resolver2.getResource(line));
                        }
                        line = rd.readLine();
                    }
                    is.close();
                }
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        boolean usingDefault = false;
        if (null == this.cfgFiles && (cfgFile = System.getProperty("cxf.config.file")) != null) {
            this.cfgFiles = new String[]{cfgFile};
        }
        if (null == this.cfgFiles) {
            this.cfgFiles = new String[]{"cxf.xml"};
            usingDefault = true;
        }
        for (String cfgFile2 : this.cfgFiles) {
            Resource cpr = this.findResource(cfgFile2);
            if (cpr != null && cpr.exists()) {
                resources.add(cpr);
                continue;
            }
            if (!usingDefault) {
                LogUtils.log(LOG, Level.WARNING, "USER_CFG_FILE_NOT_FOUND_MSG", cfgFile2);
                continue;
            }
            LogUtils.log(LOG, Level.INFO, "USER_CFG_FILE_NOT_SPECIFIED_MSG", cfgFile2);
        }
        if (null != this.cfgFileURLs) {
            for (URL cfgFileURL : this.cfgFileURLs) {
                UrlResource ur = new UrlResource(cfgFileURL);
                if (ur.exists()) {
                    resources.add(ur);
                    continue;
                }
                LogUtils.log(LOG, Level.WARNING, "USER_CFG_FILE_URL_NOT_FOUND_MSG", cfgFileURL);
            }
        }
        if (null != (sysCfgFileUrl = System.getProperty("cxf.config.file.url"))) {
            try {
                UrlResource ur = new UrlResource(sysCfgFileUrl);
                if (ur.exists()) {
                    resources.add(ur);
                } else {
                    LogUtils.log(LOG, Level.WARNING, "USER_CFG_FILE_URL_NOT_FOUND_MSG", sysCfgFileUrl);
                }
            }
            catch (MalformedURLException e) {
                LogUtils.log(LOG, Level.WARNING, "USER_CFG_FILE_URL_ERROR_MSG", sysCfgFileUrl);
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Creating application context with resources: " + resources);
        }
        if (0 == resources.size()) {
            return null;
        }
        Resource[] res = new Resource[resources.size()];
        res = resources.toArray(res);
        return res;
    }

    protected Resource findResource(String cfgFile) {
        URL url;
        AbstractResource cpr = new ClassPathResource(cfgFile);
        if (cpr.exists()) {
            return cpr;
        }
        try {
            url = new URL(cfgFile);
            cpr = new UrlResource(url);
            if (cpr.exists()) {
                return cpr;
            }
        }
        catch (MalformedURLException e) {
            // empty catch block
        }
        url = ClassLoaderUtils.getResource(cfgFile, this.getClass());
        if (url != null && (cpr = new UrlResource(url)).exists()) {
            return cpr;
        }
        cpr = new FileSystemResource(cfgFile);
        if (cpr.exists()) {
            return cpr;
        }
        return null;
    }

    protected void initBeanDefinitionReader(XmlBeanDefinitionReader reader) {
        if (this.nsHandlerResolver == null) {
            this.nsHandlerResolver = new DefaultNamespaceHandlerResolver();
        }
        reader.setNamespaceHandlerResolver(this.nsHandlerResolver);
        String mode = System.getProperty("org.apache.cxf.spring.validation.mode");
        if (mode == null) {
            mode = System.getProperty("spring.validation.mode");
        }
        if (null != mode) {
            reader.setValidationModeName(mode);
        }
        reader.setNamespaceAware(true);
        this.setEntityResolvers(reader);
    }

    void setEntityResolvers(XmlBeanDefinitionReader reader) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        reader.setEntityResolver(new BusEntityResolver(new BeansDtdResolver(), new PluggableSchemaResolver(cl)));
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException {
        ControlledValidationXmlBeanDefinitionReader beanDefinitionReader = new ControlledValidationXmlBeanDefinitionReader(beanFactory);
        beanDefinitionReader.setResourceLoader(this);
        beanDefinitionReader.setEntityResolver(new ResourceEntityResolver(this));
        this.initBeanDefinitionReader(beanDefinitionReader);
        this.loadBeanDefinitions(beanDefinitionReader);
    }
}

