/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import java.io.OutputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.validation.Schema;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.JAXBContextInitializer;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxb.attachment.JAXBAttachmentMarshaller;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JAXBEncoderDecoder {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(JAXBEncoderDecoder.class);
    private static final Logger LOG = LogUtils.getLogger(JAXBEncoderDecoder.class);

    private JAXBEncoderDecoder() {
    }

    private static Marshaller createMarshaller(JAXBContext context, Class<?> cls, Map<String, Object> marshallerProperties) throws JAXBException {
        Marshaller jm = null;
        if (context == null) {
            context = JAXBContext.newInstance(cls);
        }
        jm = context.createMarshaller();
        jm.setProperty("jaxb.encoding", "UTF-8");
        jm.setProperty("jaxb.formatted.output", Boolean.TRUE);
        if (marshallerProperties != null) {
            for (Map.Entry<String, Object> propEntry : marshallerProperties.entrySet()) {
                try {
                    jm.setProperty(propEntry.getKey(), propEntry.getValue());
                }
                catch (PropertyException pe) {
                    LOG.log(Level.INFO, "PropertyException setting Marshaller properties", pe);
                }
            }
        }
        return jm;
    }

    public static void marshall(JAXBContext context, Schema schema, Object elValue, MessagePartInfo part, Object source, AttachmentMarshaller am, Map<String, Object> marshallerProperties) {
        Class<?> cls = null;
        if (part != null) {
            cls = part.getTypeClass();
        }
        if (cls == null) {
            Class<?> clazz = cls = null != elValue ? elValue.getClass() : null;
        }
        if (cls != null && cls.isArray() && elValue instanceof Collection) {
            Collection col = (Collection)elValue;
            elValue = col.toArray((Object[])Array.newInstance(cls.getComponentType(), col.size()));
        }
        try {
            Marshaller u = JAXBEncoderDecoder.createMarshaller(context, cls, marshallerProperties);
            try {
                u.setProperty("jaxb.fragment", true);
                u.setProperty("jaxb.formatted.output", false);
            }
            catch (PropertyException e) {
                // empty catch block
            }
            Object mObj = elValue;
            QName elName = null;
            if (part != null) {
                elName = part.getConcreteName();
            }
            u.setSchema(schema);
            if (am != null) {
                if (am instanceof JAXBAttachmentMarshaller) {
                    u.setEventHandler(new MtomValidationHandler(u.getEventHandler(), (JAXBAttachmentMarshaller)am));
                }
                u.setAttachmentMarshaller(am);
            }
            if (null != elName) {
                if (part != null && part.getXmlSchema() instanceof XmlSchemaElement) {
                    XmlSchemaElement el = (XmlSchemaElement)part.getXmlSchema();
                    if (mObj.getClass().isArray() && el.getSchemaType() instanceof XmlSchemaSimpleType && ((XmlSchemaSimpleType)el.getSchemaType()).getContent() instanceof XmlSchemaSimpleTypeList) {
                        mObj = Arrays.asList(mObj);
                        JAXBEncoderDecoder.writeObject(u, source, new JAXBElement<Object>(elName, cls, mObj));
                    } else if (part.getMessageInfo().getOperation().isUnwrapped() && (mObj.getClass().isArray() || mObj instanceof List) && el.getMaxOccurs() != 1L) {
                        Object objArray;
                        if (mObj instanceof List) {
                            List l = (List)mObj;
                            objArray = l.toArray(new Object[l.size()]);
                            cls = null;
                        } else {
                            objArray = mObj;
                            cls = objArray.getClass().getComponentType();
                        }
                        int len = Array.getLength(objArray);
                        for (int x = 0; x < len; ++x) {
                            Object o = Array.get(objArray, x);
                            JAXBEncoderDecoder.writeObject(u, source, new JAXBElement<Object>(elName, cls == null ? o.getClass() : cls, o));
                        }
                    } else {
                        JAXBEncoderDecoder.writeObject(u, source, new JAXBElement<Object[]>(elName, (Class<Object[]>)cls, (Object[])mObj));
                    }
                } else if (byte[].class == cls && part.getTypeQName() != null && part.getTypeQName().getLocalPart().equals("hexBinary")) {
                    mObj = new HexBinaryAdapter().marshal((byte[])mObj);
                    JAXBEncoderDecoder.writeObject(u, source, new JAXBElement<Object[]>(elName, (Class<Object[]>)String.class, (Object[])mObj));
                } else if (mObj instanceof JAXBElement) {
                    JAXBEncoderDecoder.writeObject(u, source, mObj);
                } else {
                    JAXBEncoderDecoder.writeObject(u, source, new JAXBElement<Object[]>(elName, (Class<Object[]>)cls, (Object[])mObj));
                }
            } else {
                JAXBEncoderDecoder.writeObject(u, source, mObj);
            }
        }
        catch (Fault ex) {
            throw (Fault)ex.fillInStackTrace();
        }
        catch (Exception ex) {
            if (ex instanceof MarshalException) {
                MarshalException marshalEx = (MarshalException)ex;
                Message faultMessage = new Message("MARSHAL_ERROR", BUNDLE, marshalEx.getLinkedException().getMessage());
                throw new Fault(faultMessage, (Throwable)ex);
            }
            throw new Fault(new Message("MARSHAL_ERROR", BUNDLE, ex.getMessage()), (Throwable)ex);
        }
    }

    public static void marshallException(JAXBContext context, Schema schema, Exception elValue, MessagePartInfo part, Object source, AttachmentMarshaller am, Map<String, Object> marshallerProperties) {
        XMLStreamWriter writer = JAXBEncoderDecoder.getStreamWriter(source);
        QName qn = part.getElementQName();
        try {
            writer.writeStartElement("ns1", qn.getLocalPart(), qn.getNamespaceURI());
            Class<?> cls = part.getTypeClass();
            XmlAccessorType accessorType = cls.getAnnotation(XmlAccessorType.class);
            if (accessorType == null && cls.getPackage() != null) {
                accessorType = cls.getPackage().getAnnotation(XmlAccessorType.class);
            }
            XmlAccessType accessType = accessorType != null ? accessorType.value() : XmlAccessType.PUBLIC_MEMBER;
            String namespace = part.getElementQName().getNamespaceURI();
            SchemaInfo sch = part.getMessageInfo().getOperation().getInterface().getService().getSchema(namespace);
            if (!sch.isElementFormQualified()) {
                namespace = null;
            }
            Marshaller u = JAXBEncoderDecoder.createMarshaller(context, cls, marshallerProperties);
            try {
                u.setProperty("jaxb.fragment", true);
                u.setProperty("jaxb.formatted.output", false);
            }
            catch (PropertyException e) {
                // empty catch block
            }
            for (Field field : cls.getDeclaredFields()) {
                if (!JAXBContextInitializer.isFieldAccepted(field, accessType)) continue;
                QName fname = new QName(namespace, field.getName());
                field.setAccessible(true);
                JAXBEncoderDecoder.writeObject(u, writer, new JAXBElement<Object>(fname, String.class, field.get(elValue)));
            }
            for (AccessibleObject accessibleObject : cls.getMethods()) {
                if (!JAXBContextInitializer.isMethodAccepted((Method)accessibleObject, accessType)) continue;
                int idx = ((Method)accessibleObject).getName().startsWith("get") ? 3 : 2;
                String name = ((Method)accessibleObject).getName().substring(idx);
                name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
                QName mname = new QName(namespace, name);
                JAXBEncoderDecoder.writeObject(u, writer, new JAXBElement<Object>(mname, String.class, ((Method)accessibleObject).invoke(elValue, new Object[0])));
            }
            writer.writeEndElement();
            writer.flush();
        }
        catch (Exception e) {
            throw new Fault(new Message("MARSHAL_ERROR", BUNDLE, e.getMessage()), (Throwable)e);
        }
    }

    public static Exception unmarshallException(JAXBContext context, Schema schema, Object source, MessagePartInfo part, AttachmentUnmarshaller au) {
        XMLStreamReader reader;
        if (source instanceof XMLStreamReader) {
            reader = (XMLStreamReader)source;
        } else if (source instanceof Element) {
            reader = StaxUtils.createXMLStreamReader((Element)source);
            try {
                reader.nextTag();
            }
            catch (XMLStreamException e) {}
        } else {
            throw new Fault(new Message("UNKNOWN_SOURCE", BUNDLE, source.getClass().getName()));
        }
        try {
            QName qn = part.getElementQName();
            if (!qn.equals(reader.getName())) {
                throw new Fault(new Message("ELEMENT_NAME_MISMATCH", BUNDLE, qn, reader.getName()));
            }
            Class<?> cls = part.getTypeClass();
            Object obj = null;
            try {
                Constructor<?> cons = cls.getConstructor(new Class[0]);
                obj = cons.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException nse) {
                Constructor<?> cons = cls.getConstructor(String.class);
                obj = cons.newInstance(new Object[1]);
            }
            XmlAccessorType accessorType = cls.getAnnotation(XmlAccessorType.class);
            if (accessorType == null && cls.getPackage() != null) {
                accessorType = cls.getPackage().getAnnotation(XmlAccessorType.class);
            }
            XmlAccessType accessType = accessorType != null ? accessorType.value() : XmlAccessType.PUBLIC_MEMBER;
            Unmarshaller u = JAXBEncoderDecoder.createUnmarshaller(context, cls);
            try {
                u.setProperty("jaxb.fragment", true);
                u.setProperty("jaxb.formatted.output", false);
            }
            catch (PropertyException e) {
                // empty catch block
            }
            reader.nextTag();
            while (reader.getEventType() == 1) {
                QName q = reader.getName();
                try {
                    Field f = cls.getField(q.getLocalPart());
                    if (!JAXBContextInitializer.isFieldAccepted(f, accessType)) continue;
                    f.setAccessible(true);
                    f.set(obj, u.unmarshal(reader, f.getType()));
                }
                catch (NoSuchFieldException ex) {
                    String s = Character.toUpperCase(q.getLocalPart().charAt(0)) + q.getLocalPart().substring(1);
                    Method m = null;
                    try {
                        m = cls.getMethod("get" + s, new Class[0]);
                    }
                    catch (NoSuchMethodException mex) {
                        m = cls.getMethod("is" + s, new Class[0]);
                    }
                    Method m2 = cls.getMethod("set" + s, m.getReturnType());
                    Object o = JAXBEncoderDecoder.getElementValue(u.unmarshal(reader, m.getReturnType()));
                    m2.invoke(obj, o);
                }
            }
            return obj;
        }
        catch (Exception e) {
            throw new Fault(new Message("MARSHAL_ERROR", BUNDLE, e.getMessage()), (Throwable)e);
        }
    }

    private static void writeObject(Marshaller u, Object source, Object mObj) throws Fault, JAXBException {
        if (source instanceof XMLStreamWriter) {
            u.marshal(mObj, (XMLStreamWriter)source);
        } else if (source instanceof OutputStream) {
            u.marshal(mObj, (OutputStream)source);
        } else if (source instanceof Node) {
            u.marshal(mObj, (Node)source);
        } else if (source instanceof XMLEventWriter) {
            u.marshal(mObj, (XMLEventWriter)source);
        } else {
            throw new Fault(new Message("UNKNOWN_SOURCE", BUNDLE, source.getClass().getName()));
        }
    }

    private static XMLStreamWriter getStreamWriter(Object source) throws Fault {
        if (source instanceof XMLStreamWriter) {
            return (XMLStreamWriter)source;
        }
        if (source instanceof OutputStream) {
            return StaxUtils.createXMLStreamWriter((OutputStream)source);
        }
        if (source instanceof Node) {
            return new W3CDOMStreamWriter((Element)source);
        }
        throw new Fault(new Message("UNKNOWN_SOURCE", BUNDLE, source.getClass().getName()));
    }

    public static void marshall(JAXBContext context, Schema schema, Object elValue, Object source, Map<String, Object> marshallerProperties) {
        JAXBEncoderDecoder.marshall(context, schema, elValue, null, source, null, marshallerProperties);
    }

    public static void marshallNullElement(JAXBContext context, Schema schema, Object source, MessagePartInfo part, Map<String, Object> marshallerProperties) {
        Class<?> clazz = part != null ? part.getTypeClass() : null;
        try {
            Marshaller u = JAXBEncoderDecoder.createMarshaller(context, clazz, marshallerProperties);
            u.setSchema(schema);
            try {
                u.setProperty("jaxb.fragment", true);
                u.setProperty("jaxb.formatted.output", false);
            }
            catch (PropertyException e) {
                // empty catch block
            }
            JAXBEncoderDecoder.writeObject(u, source, new JAXBElement<Object>(part.getElementQName(), clazz, null));
        }
        catch (JAXBException e) {
            throw new Fault(new Message("MARSHAL_ERROR", BUNDLE, e.getMessage()), (Throwable)e);
        }
    }

    public static void marshall(JAXBContext context, Schema schema, Object elValue, MessagePartInfo part, Object source, Map<String, Object> marshallerProperties) {
        JAXBEncoderDecoder.marshall(context, schema, elValue, part, source, null, marshallerProperties);
    }

    private static Unmarshaller createUnmarshaller(JAXBContext context, Class<?> cls) throws JAXBException {
        Unmarshaller um = null;
        if (context == null) {
            if (cls == null) {
                throw new IllegalStateException("A JAXBContext or Class to unmarshal must be provided!");
            }
            context = JAXBContext.newInstance(cls);
        }
        um = context.createUnmarshaller();
        return um;
    }

    public static Object unmarshall(JAXBContext context, Schema schema, Object source) {
        return JAXBEncoderDecoder.unmarshall(context, schema, source, null, null, true);
    }

    public static Object unmarshall(JAXBContext context, Schema schema, Object source, MessagePartInfo part, AttachmentUnmarshaller au, boolean unwrap) {
        List<Object> o;
        QName elName;
        Class<?> clazz;
        Class<?> clazz2 = clazz = part != null ? part.getTypeClass() : null;
        if (clazz != null && Exception.class.isAssignableFrom(clazz) && part != null && Boolean.TRUE.equals(part.getProperty(JAXBDataBinding.class.getName() + ".CUSTOM_EXCEPTION"))) {
            return JAXBEncoderDecoder.unmarshallException(context, schema, source, part, au);
        }
        QName qName = elName = part != null ? part.getConcreteName() : null;
        if (clazz != null && clazz.isArray() && part != null && part.getXmlSchema() instanceof XmlSchemaElement) {
            XmlSchemaElement el = (XmlSchemaElement)part.getXmlSchema();
            if (el.getSchemaType() instanceof XmlSchemaSimpleType && ((XmlSchemaSimpleType)el.getSchemaType()).getContent() instanceof XmlSchemaSimpleTypeList) {
                Object obj = JAXBEncoderDecoder.unmarshall(context, schema, source, elName, null, au, unwrap);
                if (clazz.isArray() && obj instanceof List) {
                    return ((List)obj).toArray((Object[])Array.newInstance(clazz.getComponentType(), ((List)obj).size()));
                }
                return obj;
            }
            if (part.getMessageInfo().getOperation().isUnwrapped() && el.getMaxOccurs() != 1L) {
                List<Object> ret = JAXBEncoderDecoder.unmarshallArray(context, schema, source, elName, clazz.getComponentType(), au, JAXBEncoderDecoder.createList(part));
                Object[] o2 = ret;
                if (!JAXBEncoderDecoder.isList(part)) {
                    if (clazz.getComponentType().isPrimitive()) {
                        o2 = Array.newInstance(clazz.getComponentType(), ret.size());
                        for (int x = 0; x < ret.size(); ++x) {
                            Array.set(o2, x, ret.get(x));
                        }
                    } else {
                        o2 = ret.toArray((Object[])Array.newInstance(clazz.getComponentType(), ret.size()));
                    }
                }
                return o2;
            }
        } else if (byte[].class == clazz && part != null && part.getTypeQName() != null && part.getTypeQName().getLocalPart().equals("hexBinary")) {
            String obj = (String)JAXBEncoderDecoder.unmarshall(context, schema, source, elName, String.class, au, unwrap);
            return new HexBinaryAdapter().unmarshal(obj);
        }
        if ((o = JAXBEncoderDecoder.unmarshall(context, schema, source, elName, clazz, au, unwrap)) != null && o.getClass().isArray() && JAXBEncoderDecoder.isList(part)) {
            List<Object> ret = JAXBEncoderDecoder.createList(part);
            ret.addAll(Arrays.asList((Object[])o));
            o = ret;
        }
        return o;
    }

    private static List<Object> createList(MessagePartInfo part) {
        Class cls;
        Type tp2;
        Type genericType = (Type)part.getProperty("generic.type");
        if (genericType instanceof ParameterizedType && (tp2 = ((ParameterizedType)genericType).getRawType()) instanceof Class && !(cls = (Class)tp2).isInterface() && List.class.isAssignableFrom(cls)) {
            try {
                return CastUtils.cast((List)cls.newInstance());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return new ArrayList<Object>();
    }

    private static boolean isList(MessagePartInfo part) {
        Type tp2;
        Type genericType;
        if (part.getTypeClass().isArray() && !part.getTypeClass().getComponentType().isPrimitive() && (genericType = (Type)part.getProperty("generic.type")) instanceof ParameterizedType && (tp2 = ((ParameterizedType)genericType).getRawType()) instanceof Class) {
            return Collection.class.isAssignableFrom((Class)tp2);
        }
        return false;
    }

    public static Object unmarshall(JAXBContext context, Schema schema, Object source, QName elName, Class<?> clazz, AttachmentUnmarshaller au, boolean unwrap) {
        JAXBElement<?> obj;
        block11: {
            obj = null;
            try {
                Unmarshaller u = JAXBEncoderDecoder.createUnmarshaller(context, clazz);
                u.setSchema(schema);
                if (au != null) {
                    u.setAttachmentUnmarshaller(au);
                }
                boolean unmarshalWithClass = true;
                if (clazz == null || !clazz.isPrimitive() && !clazz.isArray() && !clazz.isEnum() && !clazz.equals(Calendar.class) && (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers()))) {
                    unmarshalWithClass = false;
                }
                if (clazz != null && (clazz.getName().equals("javax.xml.datatype.XMLGregorianCalendar") || clazz.getName().equals("javax.xml.datatype.Duration"))) {
                    unmarshalWithClass = true;
                }
                if (source instanceof Node) {
                    obj = unmarshalWithClass ? u.unmarshal((Node)source, clazz) : u.unmarshal((Node)source);
                    break block11;
                }
                if (source instanceof XMLStreamReader) {
                    obj = unmarshalWithClass ? u.unmarshal((XMLStreamReader)source, clazz) : u.unmarshal((XMLStreamReader)source);
                    break block11;
                }
                if (source instanceof XMLEventReader) {
                    obj = unmarshalWithClass ? u.unmarshal((XMLEventReader)source, clazz) : u.unmarshal((XMLEventReader)source);
                    break block11;
                }
                throw new Fault(new Message("UNKNOWN_SOURCE", BUNDLE, source.getClass().getName()));
            }
            catch (Fault ex) {
                ex.fillInStackTrace();
                throw ex;
            }
            catch (Throwable ex) {
                if (ex instanceof UnmarshalException) {
                    UnmarshalException unmarshalEx = (UnmarshalException)ex;
                    if (unmarshalEx.getLinkedException() != null) {
                        throw new Fault(new Message("UNMARSHAL_ERROR", BUNDLE, unmarshalEx.getLinkedException().getMessage()), ex);
                    }
                    throw new Fault(new Message("UNMARSHAL_ERROR", BUNDLE, unmarshalEx.getMessage()), ex);
                }
                throw new Fault(new Message("UNMARSHAL_ERROR", BUNDLE, ex.getMessage()), ex);
            }
        }
        return unwrap ? JAXBEncoderDecoder.getElementValue(obj) : obj;
    }

    public static Object getElementValue(Object obj) {
        if (null == obj) {
            return null;
        }
        if (obj instanceof JAXBElement) {
            return ((JAXBElement)obj).getValue();
        }
        return obj;
    }

    public static Class<?> getClassFromType(Type t) {
        if (t instanceof Class) {
            return (Class)t;
        }
        if (t instanceof GenericArrayType) {
            GenericArrayType g = (GenericArrayType)t;
            return Array.newInstance(JAXBEncoderDecoder.getClassFromType(g.getGenericComponentType()), 0).getClass();
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)t;
            return JAXBEncoderDecoder.getClassFromType(p.getRawType());
        }
        assert (false);
        throw new IllegalArgumentException("Cannot get Class object from unknown Type");
    }

    public static List<Object> unmarshallArray(JAXBContext context, Schema schema, Object source, QName elName, Class<?> clazz, AttachmentUnmarshaller au, List<Object> ret) {
        try {
            XMLStreamReader reader;
            Unmarshaller u = JAXBEncoderDecoder.createUnmarshaller(context, clazz);
            u.setSchema(schema);
            if (au != null) {
                u.setAttachmentUnmarshaller(au);
            }
            if (source instanceof XMLStreamReader) {
                reader = (XMLStreamReader)source;
            } else if (source instanceof Element) {
                reader = StaxUtils.createXMLStreamReader((Element)source);
            } else {
                throw new Fault(new Message("UNKNOWN_SOURCE", BUNDLE, source.getClass().getName()));
            }
            while (reader.getName().equals(elName)) {
                JAXBElement<?> obj = u.unmarshal(reader, clazz);
                if (obj instanceof JAXBElement) {
                    obj = obj.getValue();
                }
                ret.add(obj);
                while (reader.getEventType() != 1 && reader.getEventType() != 2) {
                    reader.nextTag();
                }
            }
            return ret;
        }
        catch (Fault ex) {
            ex.fillInStackTrace();
            throw ex;
        }
        catch (Exception ex) {
            if (ex instanceof UnmarshalException) {
                UnmarshalException unmarshalEx = (UnmarshalException)ex;
                throw new Fault(new Message("UNMARSHAL_ERROR", BUNDLE, unmarshalEx.getLinkedException().getMessage()), (Throwable)ex);
            }
            throw new Fault(new Message("UNMARSHAL_ERROR", BUNDLE, ex.getMessage()), (Throwable)ex);
        }
    }

    private static class MtomValidationHandler
    implements ValidationEventHandler {
        ValidationEventHandler origHandler;
        JAXBAttachmentMarshaller marshaller;

        public MtomValidationHandler(ValidationEventHandler v, JAXBAttachmentMarshaller m) {
            this.origHandler = v;
            this.marshaller = m;
        }

        public boolean handleEvent(ValidationEvent event) {
            String msg = event.getMessage();
            if (msg.startsWith("cvc-type.3.1.2: ") && msg.contains(this.marshaller.getLastMTOMElementName().getLocalPart())) {
                return true;
            }
            if (this.origHandler != null) {
                return this.origHandler.handleEvent(event);
            }
            return false;
        }
    }
}

