/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator;

import javax.jws.soap.SOAPBinding;
import org.apache.cxf.tools.common.model.Annotator;
import org.apache.cxf.tools.common.model.JAnnotation;
import org.apache.cxf.tools.common.model.JAnnotationElement;
import org.apache.cxf.tools.common.model.JavaAnnotatable;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaMethod;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.annotator.SoapBindingAnnotator;

public final class BindingAnnotator
implements Annotator {
    public void annotate(JavaAnnotatable ja) {
        if (!(ja instanceof JavaInterface)) {
            throw new RuntimeException("BindingAnnotator can only annotate JavaInterface");
        }
        JavaInterface intf = (JavaInterface)ja;
        if (this.processBinding(intf)) {
            JAnnotation bindingAnnotation = new JAnnotation(SOAPBinding.class);
            if (!SOAPBinding.Style.DOCUMENT.equals((Object)intf.getSOAPStyle())) {
                bindingAnnotation.addElement(new JAnnotationElement("style", (Object)intf.getSOAPStyle()));
            }
            if (!SOAPBinding.Use.LITERAL.equals((Object)intf.getSOAPUse())) {
                bindingAnnotation.addElement(new JAnnotationElement("use", (Object)intf.getSOAPUse()));
            }
            if (intf.getSOAPStyle() == SOAPBinding.Style.DOCUMENT && intf.getSOAPParameterStyle() != SOAPBinding.ParameterStyle.WRAPPED) {
                bindingAnnotation.addElement(new JAnnotationElement("parameterStyle", (Object)intf.getSOAPParameterStyle()));
            }
            intf.addAnnotation(bindingAnnotation);
        }
        for (JavaMethod method : intf.getMethods()) {
            if (method.isAsync()) continue;
            method.annotate(new SoapBindingAnnotator());
        }
    }

    private boolean processBinding(JavaInterface intf) {
        SOAPBinding.Style soapStyle = intf.getSOAPStyle();
        SOAPBinding.Use soapUse = intf.getSOAPUse();
        boolean allWrapped = true;
        boolean allBare = true;
        boolean allRPC = true;
        boolean allDOC = true;
        for (JavaMethod method : intf.getMethods()) {
            if (!method.isWrapperStyle()) {
                allWrapped = false;
            } else {
                allBare = false;
            }
            SOAPBinding.Style mStyle = method.getSoapStyle();
            if (mStyle == null) {
                mStyle = soapStyle;
            }
            if (mStyle == null) {
                mStyle = SOAPBinding.Style.DOCUMENT;
            }
            if (soapStyle == null && method.getSoapStyle() != null) {
                soapStyle = method.getSoapStyle();
            }
            if (SOAPBinding.Style.DOCUMENT.equals((Object)mStyle)) {
                allRPC = false;
            } else {
                allDOC = false;
            }
            if (soapUse != null || method.getSoapUse() == null) continue;
            soapUse = method.getSoapUse();
        }
        if (allDOC) {
            soapStyle = SOAPBinding.Style.DOCUMENT;
        } else if (allRPC) {
            soapStyle = SOAPBinding.Style.RPC;
        }
        if (soapStyle == SOAPBinding.Style.DOCUMENT) {
            intf.setSOAPStyle(SOAPBinding.Style.DOCUMENT);
            if (allWrapped) {
                intf.setSOAPParameterStyle(SOAPBinding.ParameterStyle.WRAPPED);
            } else if (allBare) {
                intf.setSOAPParameterStyle(SOAPBinding.ParameterStyle.BARE);
            }
        } else if (soapStyle == null) {
            intf.setSOAPStyle(SOAPBinding.Style.DOCUMENT);
            if (allWrapped) {
                intf.setSOAPParameterStyle(SOAPBinding.ParameterStyle.WRAPPED);
            } else if (allBare) {
                intf.setSOAPParameterStyle(SOAPBinding.ParameterStyle.BARE);
            }
        } else {
            intf.setSOAPStyle(SOAPBinding.Style.RPC);
        }
        if (intf.getSOAPParameterStyle() == null) {
            intf.setSOAPParameterStyle(SOAPBinding.ParameterStyle.WRAPPED);
        }
        if (soapUse == SOAPBinding.Use.LITERAL) {
            intf.setSOAPUse(SOAPBinding.Use.LITERAL);
        } else if (soapUse == null) {
            intf.setSOAPUse(SOAPBinding.Use.LITERAL);
        } else {
            intf.setSOAPUse(SOAPBinding.Use.ENCODED);
        }
        return intf.getSOAPStyle() != SOAPBinding.Style.DOCUMENT || intf.getSOAPUse() != SOAPBinding.Use.LITERAL || intf.getSOAPParameterStyle() != SOAPBinding.ParameterStyle.WRAPPED;
    }
}

